/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.Straightener;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class Line
extends Roi {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public double x1d;
    public double y1d;
    public double x2d;
    public double y2d;
    protected double x1R;
    protected double y1R;
    protected double x2R;
    protected double y2R;
    private double xHandleOffset;
    private double yHandleOffset;
    protected double startxd;
    protected double startyd;
    static boolean widthChanged;
    private boolean drawOffset;
    private boolean dragged;
    private int mouseUpCount;
    private static final double[] PI_SEARCH;
    private static final double[] PI_MULT;

    public Line(int ox1, int oy1, int ox2, int oy2) {
        this((double)ox1, (double)oy1, (double)ox2, (double)oy2);
    }

    public Line(double ox1, double oy1, double ox2, double oy2) {
        super((int)ox1, (int)oy1, 0, 0);
        this.type = 5;
        this.x1d = ox1;
        this.y1d = oy1;
        this.x2d = ox2;
        this.y2d = oy2;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        this.x = (int)Math.min(this.x1d, this.x2d);
        this.y = (int)Math.min(this.y1d, this.y2d);
        this.x1R = this.x1d - (double)this.x;
        this.y1R = this.y1d - (double)this.y;
        this.x2R = this.x2d - (double)this.x;
        this.y2R = this.y2d - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
        this.updateClipRect();
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        this.state = 3;
    }

    public Line(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        this.startxd = this.ic.offScreenXD(sx);
        this.startyd = this.ic.offScreenYD(sy);
        this.x1R = this.x2R = this.startxd - (double)this.startX;
        this.y1R = this.y2R = this.startyd - (double)this.startY;
        this.type = 5;
        if (!(this instanceof Arrow) && lineWidth > 1) {
            this.updateWideLine(lineWidth);
        }
        this.drawOffset = Prefs.subPixelResolution;
    }

    public Line(int ox1, int oy1, int ox2, int oy2, ImagePlus imp) {
        this(ox1, oy1, ox2, oy2);
        this.setImage(imp);
    }

    protected void grow(int sx, int sy) {
        this.drawLine(sx, sy);
        this.dragged = true;
    }

    public void mouseMoved(MouseEvent e) {
        this.drawLine(e.getX(), e.getY());
    }

    protected void handleMouseUp(int screenX, int screenY) {
        ++this.mouseUpCount;
        if (Prefs.enhancedLineTool && this.mouseUpCount == 1 && !this.dragged) {
            return;
        }
        this.state = 3;
        if (this.imp == null) {
            return;
        }
        this.imp.draw(this.clipX - 5, this.clipY - 5, this.clipWidth + 10, this.clipHeight + 10);
        if (Recorder.record) {
            String method = this instanceof Arrow ? "makeArrow" : "makeLine";
            Recorder.record(method, this.x1, this.y1, this.x2, this.y2);
        }
        if (this.getLength() == 0.0) {
            this.imp.deleteRoi();
        }
    }

    protected void drawLine(int sx, int sy) {
        double yend;
        double xend = this.ic != null ? this.ic.offScreenXD(sx) : (double)sx;
        double d = yend = this.ic != null ? this.ic.offScreenYD(sy) : (double)sy;
        if (xend < 0.0) {
            xend = 0.0;
        }
        if (yend < 0.0) {
            yend = 0.0;
        }
        if (xend > (double)this.xMax) {
            xend = this.xMax;
        }
        if (yend > (double)this.yMax) {
            yend = this.yMax;
        }
        double xstart = (double)this.x + this.x1R;
        double ystart = (double)this.y + this.y1R;
        if (this.constrain) {
            int i;
            double dy = Math.abs(yend - ystart);
            double dx = Math.abs(xend - xstart);
            double comp = dy / dx;
            for (i = 0; i < PI_SEARCH.length && !(comp < PI_SEARCH[i]); ++i) {
            }
            if (i < PI_SEARCH.length) {
                yend = yend > ystart ? ystart + dx * PI_MULT[i] : ystart - dx * PI_MULT[i];
            } else {
                xend = xstart;
            }
        }
        this.x = (int)Math.min((double)this.x + this.x1R, xend);
        this.y = (int)Math.min((double)this.y + this.y1R, yend);
        this.x1R = xstart - (double)this.x;
        this.y1R = ystart - (double)this.y;
        this.x2R = xend - (double)this.x;
        this.y2R = yend - (double)this.y;
        if (IJ.controlKeyDown()) {
            this.x1R = (int)Math.round(this.x1R);
            this.y1R = (int)Math.round(this.y1R);
            this.x2R = (int)Math.round(this.x2R);
            this.y2R = (int)Math.round(this.y2R);
        }
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    void move(int sx, int sy) {
        int xNew = this.ic.offScreenX(sx);
        int yNew = this.ic.offScreenY(sy);
        this.x = (int)((double)this.x + ((double)xNew - this.startxd));
        this.y = (int)((double)this.y + ((double)yNew - this.startyd));
        this.clipboard = null;
        this.startxd = xNew;
        this.startyd = yNew;
        this.updateClipRect();
        if (this.ignoreClipRect) {
            this.imp.draw();
        } else {
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void moveHandle(int sx, int sy) {
        double dy;
        double dx;
        double offset = this.getOffset(-0.5);
        double ox = this.ic.offScreenXD(sx) + offset;
        double oy = this.ic.offScreenYD(sy) + offset;
        this.x1d = (double)this.x + this.x1R;
        this.y1d = (double)this.y + this.y1R;
        this.x2d = (double)this.x + this.x2R;
        this.y2d = (double)this.y + this.y2R;
        double length = Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
        switch (this.activeHandle) {
            case 0: {
                dx = ox - this.x1d;
                dy = oy - this.y1d;
                this.x1d = ox;
                this.y1d = oy;
                if (this.center) {
                    this.x2d -= dx;
                    this.y2d -= dy;
                }
                if (!this.aspect) break;
                double ratio = length / Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
                double xcd = this.x1d + (this.x2d - this.x1d) / 2.0;
                double ycd = this.y1d + (this.y2d - this.y1d) / 2.0;
                if (this.center) {
                    this.x1d = xcd - ratio * (xcd - this.x1d);
                    this.x2d = xcd + ratio * (this.x2d - xcd);
                    this.y1d = ycd - ratio * (ycd - this.y1d);
                    this.y2d = ycd + ratio * (this.y2d - ycd);
                    break;
                }
                this.x1d = this.x2d - ratio * (this.x2d - this.x1d);
                this.y1d = this.y2d - ratio * (this.y2d - this.y1d);
                break;
            }
            case 1: {
                dx = ox - this.x2d;
                dy = oy - this.y2d;
                this.x2d = ox;
                this.y2d = oy;
                if (this.center) {
                    this.x1d -= dx;
                    this.y1d -= dy;
                }
                if (!this.aspect) break;
                double ratio = length / Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
                double xcd = this.x1d + (this.x2d - this.x1d) / 2.0;
                double ycd = this.y1d + (this.y2d - this.y1d) / 2.0;
                if (this.center) {
                    this.x1d = xcd - ratio * (xcd - this.x1d);
                    this.x2d = xcd + ratio * (this.x2d - xcd);
                    this.y1d = ycd - ratio * (ycd - this.y1d);
                    this.y2d = ycd + ratio * (this.y2d - ycd);
                    break;
                }
                this.x2d = this.x1d + ratio * (this.x2d - this.x1d);
                this.y2d = this.y1d + ratio * (this.y2d - this.y1d);
                break;
            }
            case 2: {
                dx = ox - (this.x1d + (this.x2d - this.x1d) / 2.0);
                dy = oy - (this.y1d + (this.y2d - this.y1d) / 2.0);
                this.x1d += dx;
                this.y1d += dy;
                this.x2d += dx;
                this.y2d += dy;
                if (!(this.getStrokeWidth() > 1.0f)) break;
                this.x1d += this.xHandleOffset;
                this.y1d += this.yHandleOffset;
                this.x2d += this.xHandleOffset;
                this.y2d += this.yHandleOffset;
            }
        }
        if (this.constrain) {
            dx = Math.abs(this.x1d - this.x2d);
            dy = Math.abs(this.y1d - this.y2d);
            double xcd = Math.min(this.x1d, this.x2d) + dx / 2.0;
            double ycd = Math.min(this.y1d, this.y2d) + dy / 2.0;
            if (this.activeHandle == 0) {
                if (dx >= dy) {
                    if (this.aspect) {
                        this.x1d = this.x2d > this.x1d ? this.x2d - length : this.x2d + length;
                    }
                    this.y1d = this.y2d;
                    if (this.center) {
                        this.y1d = this.y2d = ycd;
                        if (this.aspect) {
                            if (xcd > this.x1d) {
                                this.x1d = xcd - length / 2.0;
                                this.x2d = xcd + length / 2.0;
                            } else {
                                this.x1d = xcd + length / 2.0;
                                this.x2d = xcd - length / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        this.y1d = this.y2d > this.y1d ? this.y2d - length : this.y2d + length;
                    }
                    this.x1d = this.x2d;
                    if (this.center) {
                        this.x1d = this.x2d = xcd;
                        if (this.aspect) {
                            if (ycd > this.y1d) {
                                this.y1d = ycd - length / 2.0;
                                this.y2d = ycd + length / 2.0;
                            } else {
                                this.y1d = ycd + length / 2.0;
                                this.y2d = ycd - length / 2.0;
                            }
                        }
                    }
                }
            } else if (this.activeHandle == 1) {
                if (dx >= dy) {
                    if (this.aspect) {
                        this.x2d = this.x1d > this.x2d ? this.x1d - length : this.x1d + length;
                    }
                    this.y2d = this.y1d;
                    if (this.center) {
                        this.y1d = this.y2d = ycd;
                        if (this.aspect) {
                            if (xcd > this.x1d) {
                                this.x1d = xcd - length / 2.0;
                                this.x2d = xcd + length / 2.0;
                            } else {
                                this.x1d = xcd + length / 2.0;
                                this.x2d = xcd - length / 2.0;
                            }
                        }
                    }
                } else {
                    if (this.aspect) {
                        this.y2d = this.y1d > this.y2d ? this.y1d - length : this.y1d + length;
                    }
                    this.x2d = this.x1d;
                    if (this.center) {
                        this.x1d = this.x2d = xcd;
                        if (this.aspect) {
                            if (ycd > this.y1d) {
                                this.y1d = ycd - length / 2.0;
                                this.y2d = ycd + length / 2.0;
                            } else {
                                this.y1d = ycd + length / 2.0;
                                this.y2d = ycd - length / 2.0;
                            }
                        }
                    }
                }
            }
        }
        this.x = (int)Math.min(this.x1d, this.x2d);
        this.y = (int)Math.min(this.y1d, this.y2d);
        this.x1R = this.x1d - (double)this.x;
        this.y1R = this.y1d - (double)this.y;
        this.x2R = this.x2d - (double)this.x;
        this.y2R = this.y2d - (double)this.y;
        this.width = (int)Math.abs(this.x2R - this.x1R);
        this.height = (int)Math.abs(this.y2R - this.y1R);
        this.updateClipRect();
        this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
    }

    protected void mouseDownInHandle(int handle, int sx, int sy) {
        this.state = 4;
        this.activeHandle = handle;
        if (this.getStrokeWidth() <= 3.0f) {
            this.ic.setCursor(new Cursor(1));
        }
    }

    public void draw(Graphics g) {
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        double x = this.getXBase();
        double y = this.getYBase();
        g.setColor(color);
        this.x1d = x + this.x1R;
        this.y1d = y + this.y1R;
        this.x2d = x + this.x2R;
        this.y2d = y + this.y2R;
        this.x1 = (int)this.x1d;
        this.y1 = (int)this.y1d;
        this.x2 = (int)this.x2d;
        this.y2 = (int)this.y2d;
        double offset = this.getOffset(0.5);
        int sx1 = this.screenXD(this.x1d + offset);
        int sy1 = this.screenYD(this.y1d + offset);
        int sx2 = this.screenXD(this.x2d + offset);
        int sy2 = this.screenYD(this.y2d + offset);
        int sx3 = sx1 + (sx2 - sx1) / 2;
        int sy3 = sy1 + (sy2 - sy1) / 2;
        Graphics2D g2d = (Graphics2D)g;
        if (this.stroke != null) {
            g2d.setStroke(this.getScaledStroke());
        }
        g.drawLine(sx1, sy1, sx2, sy2);
        if (this.wideLine && !this.overlay) {
            g2d.setStroke(onePixelWide);
            g.setColor(Line.getColor());
            g.drawLine(sx1, sy1, sx2, sy2);
        }
        if (!this.overlay) {
            int size2 = 2;
            this.mag = this.getMagnification();
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(g, sx1 - size2, sy1 - size2);
            this.handleColor = Color.white;
            this.drawHandle(g, sx2 - size2, sy2 - size2);
            this.drawHandle(g, sx3 - size2, sy3 - size2);
        }
        if (this.state != 3) {
            IJ.showStatus(this.imp.getLocationAsString(this.x2, this.y2) + ", angle=" + IJ.d2s(this.getAngle()) + ", length=" + IJ.d2s(this.getLength()));
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    public double getAngle() {
        return this.getFloatAngle(this.x1d, this.y1d, this.x2d, this.y2d);
    }

    public double getLength() {
        if (this.imp == null || IJ.altKeyDown()) {
            return this.getRawLength();
        }
        Calibration cal = this.imp.getCalibration();
        return Math.sqrt((this.x2d - this.x1d) * cal.pixelWidth * (this.x2d - this.x1d) * cal.pixelWidth + (this.y2d - this.y1d) * cal.pixelHeight * (this.y2d - this.y1d) * cal.pixelHeight);
    }

    public double getRawLength() {
        return Math.sqrt((this.x2d - this.x1d) * (this.x2d - this.x1d) + (this.y2d - this.y1d) * (this.y2d - this.y1d));
    }

    public double[] getPixels() {
        double[] profile;
        if (this.getStrokeWidth() <= 1.0f) {
            ImageProcessor ip = this.imp.getProcessor();
            profile = ip.getLine(this.x1d, this.y1d, this.x2d, this.y2d);
        } else {
            ImageProcessor ip2 = new Straightener().rotateLine(this.imp, (int)this.getStrokeWidth());
            if (ip2 == null) {
                return new double[0];
            }
            int width = ip2.getWidth();
            int height = ip2.getHeight();
            profile = new double[width];
            ip2.setInterpolate(false);
            for (int y = 0; y < height; ++y) {
                double[] aLine = ip2.getLine(0.0, y, width - 1, y);
                for (int i = 0; i < width; ++i) {
                    int n = i;
                    profile[n] = profile[n] + aLine[i];
                }
            }
            int i = 0;
            while (i < width) {
                int n = i++;
                profile[n] = profile[n] / (double)height;
            }
        }
        return profile;
    }

    public Polygon getPoints() {
        Polygon p = new Polygon();
        p.addPoint((int)Math.round(this.x1d), (int)Math.round(this.y1d));
        p.addPoint((int)Math.round(this.x2d), (int)Math.round(this.y2d));
        return p;
    }

    public FloatPolygon getFloatPoints() {
        FloatPolygon p = new FloatPolygon();
        p.addPoint((float)this.x1d, (float)this.y1d);
        p.addPoint((float)this.x2d, (float)this.y2d);
        return p;
    }

    public Polygon getPolygon() {
        FloatPolygon p = this.getFloatPolygon();
        return new Polygon(Line.toIntR(p.xpoints), Line.toIntR(p.ypoints), p.npoints);
    }

    public FloatPolygon getFloatPolygon() {
        double x = this.getXBase();
        double y = this.getYBase();
        this.x1d = x + this.x1R;
        this.y1d = y + this.y1R;
        this.x2d = x + this.x2R;
        this.y2d = y + this.y2R;
        FloatPolygon p = new FloatPolygon();
        if (this.getStrokeWidth() <= 1.0f) {
            p.addPoint((float)this.x1d, (float)this.y1d);
            p.addPoint((float)this.x2d, (float)this.y2d);
        } else {
            double angle = Math.atan2(this.y1d - this.y2d, this.x2d - this.x1d);
            double width2 = (double)this.getStrokeWidth() / 2.0;
            double p1x = this.x1d + Math.cos(angle + 1.5707963267948966) * width2;
            double p1y = this.y1d - Math.sin(angle + 1.5707963267948966) * width2;
            double p2x = this.x1d + Math.cos(angle - 1.5707963267948966) * width2;
            double p2y = this.y1d - Math.sin(angle - 1.5707963267948966) * width2;
            double p3x = this.x2d + Math.cos(angle - 1.5707963267948966) * width2;
            double p3y = this.y2d - Math.sin(angle - 1.5707963267948966) * width2;
            double p4x = this.x2d + Math.cos(angle + 1.5707963267948966) * width2;
            double p4y = this.y2d - Math.sin(angle + 1.5707963267948966) * width2;
            p.addPoint((float)p1x, (float)p1y);
            p.addPoint((float)p2x, (float)p2y);
            p.addPoint((float)p3x, (float)p3y);
            p.addPoint((float)p4x, (float)p4y);
        }
        return p;
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setLineWidth(1);
        double x = this.getXBase();
        double y = this.getYBase();
        this.x1d = x + this.x1R;
        this.y1d = y + this.y1R;
        this.x2d = x + this.x2R;
        this.y2d = y + this.y2R;
        double offset = this.getOffset(0.5);
        if (this.getStrokeWidth() <= 1.0f) {
            ip.moveTo((int)(this.x1d + offset), (int)(this.y1d + offset));
            ip.lineTo((int)(this.x2d + offset), (int)(this.y2d + offset));
        } else {
            Polygon p = null;
            if (offset > 0.0) {
                FloatPolygon fp = this.getFloatPolygon();
                int i = 0;
                while (i < fp.npoints) {
                    int n = i;
                    fp.xpoints[n] = (float)((double)fp.xpoints[n] + offset);
                    int n2 = i++;
                    fp.ypoints[n2] = (float)((double)fp.ypoints[n2] + offset);
                }
                p = new Polygon(Line.toIntR(fp.xpoints), Line.toIntR(fp.ypoints), fp.npoints);
            } else {
                p = this.getPolygon();
            }
            ip.drawPolygon(p);
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        if (this.getStrokeWidth() > 1.0f) {
            if (x == this.x1 && y == this.y1 || x == this.x2 && y == this.y2) {
                return true;
            }
            return this.getPolygon().contains(x, y);
        }
        return false;
    }

    protected void handleMouseDown(int sx, int sy) {
        super.handleMouseDown(sx, sy);
        this.startxd = this.ic.offScreenXD(sx);
        this.startyd = this.ic.offScreenYD(sy);
    }

    public int isHandle(int sx, int sy) {
        int size = 10;
        if (this.getStrokeWidth() > 1.0f) {
            size += (int)Math.log(this.getStrokeWidth());
        }
        int halfSize = size / 2;
        double offset = this.getOffset(0.5);
        int sx1 = this.ic.screenXD((double)this.x + this.x1R + offset) - halfSize;
        int sy1 = this.ic.screenYD((double)this.y + this.y1R + offset) - halfSize;
        int sx2 = this.ic.screenXD((double)this.x + this.x2R + offset) - halfSize;
        int sy2 = this.ic.screenYD((double)this.y + this.y2R + offset) - halfSize;
        int sx3 = sx1 + (sx2 - sx1) / 2 - 1;
        int sy3 = sy1 + (sy2 - sy1) / 2 - 1;
        if (sx >= sx1 && sx <= sx1 + size && sy >= sy1 && sy <= sy1 + size) {
            return 0;
        }
        if (sx >= sx2 && sx <= sx2 + size && sy >= sy2 && sy <= sy2 + size) {
            return 1;
        }
        if (sx >= sx3 && sx <= sx3 + size + 2 && sy >= sy3 && sy <= sy3 + size + 2) {
            return 2;
        }
        return -1;
    }

    private double getOffset(double value) {
        return this.getDrawOffset() && this.getMagnification() > 1.0 && !(this instanceof Arrow) ? value : 0.0;
    }

    public static int getWidth() {
        return lineWidth;
    }

    public static void setWidth(int w) {
        int max;
        if (w < 1) {
            w = 1;
        }
        if (w > (max = 500)) {
            ImagePlus imp2 = WindowManager.getCurrentImage();
            if (imp2 != null) {
                max = Math.max(max, imp2.getWidth());
                max = Math.max(max, imp2.getHeight());
            }
            if (w > max) {
                w = max;
            }
        }
        lineWidth = w;
        widthChanged = true;
    }

    public void setStrokeWidth(float width) {
        super.setStrokeWidth(width);
        if (this.getStrokeColor() == Roi.getColor()) {
            this.wideLine = true;
        }
    }

    public Rectangle getBounds() {
        int xmin = (int)Math.round(Math.min(this.x1d, this.x2d));
        int ymin = (int)Math.round(Math.min(this.y1d, this.y2d));
        int w = (int)Math.round(Math.abs(this.x2d - this.x1d));
        int h = (int)Math.round(Math.abs(this.y2d - this.y1d));
        return new Rectangle(xmin, ymin, w, h);
    }

    protected int clipRectMargin() {
        return 4;
    }

    public void nudgeCorner(int key) {
        if (this.ic == null) {
            return;
        }
        double inc = 1.0 / this.ic.getMagnification();
        switch (key) {
            case 38: {
                this.y2R -= inc;
                break;
            }
            case 40: {
                this.y2R += inc;
                break;
            }
            case 37: {
                this.x2R -= inc;
                break;
            }
            case 39: {
                this.x2R += inc;
            }
        }
        this.grow(this.ic.screenXD((double)this.x + this.x2R), this.ic.screenYD((double)this.y + this.y2R));
    }

    public boolean getDrawOffset() {
        return this.drawOffset;
    }

    public void setDrawOffset(boolean drawOffset) {
        this.drawOffset = drawOffset;
    }

    public boolean subPixelResolution() {
        return true;
    }

    static {
        PI_SEARCH = new double[]{Math.tan(0.39269908169872414), Math.tan(1.1780972450961724)};
        PI_MULT = new double[]{0.0, Math.tan(0.7853981633974483)};
    }
}

