/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.plugin.Colors;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.Java2;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class TextRoi
extends Roi {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    static final int MAX_LINES = 50;
    private static final String line1 = "Enter text, then press";
    private static final String line2 = "ctrl+b to add to overlay";
    private static final String line3 = "or ctrl+d to draw.";
    private static final String line1a = "Enter text...";
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private Font instanceFont;
    private static boolean newFont = true;
    private static boolean antialiasedText = true;
    private static int globalJustification;
    private static Color defaultFillColor;
    private int justification;
    private boolean antialiased = antialiasedText;
    private double previousMag;
    private boolean firstChar = true;
    private boolean firstMouseUp = true;
    private int cline = 0;
    private boolean drawStringMode;
    private double angle;
    private static double defaultAngle;
    private static boolean firstTime;

    public TextRoi(int x, int y, String text) {
        super(x, y, 1, 1);
        this.init(text, null);
    }

    public TextRoi(String text, double x, double y, Font font) {
        super(x, y, 1.0, 1.0);
        ImageJ ij;
        Graphics g;
        this.drawStringMode = true;
        if (text != null && text.contains("\n")) {
            String[] lines = Tools.split(text, "\n");
            int count = Math.min(lines.length, 50);
            for (int i = 0; i < count; ++i) {
                this.theText[i] = lines[i];
            }
        } else {
            this.theText[0] = text;
        }
        this.instanceFont = font;
        if (this.instanceFont == null) {
            this.instanceFont = new Font(name, style, size);
        }
        Graphics graphics = g = (ij = IJ.getInstance()) != null ? ij.getGraphics() : null;
        if (g == null) {
            return;
        }
        FontMetrics metrics = g.getFontMetrics(this.instanceFont);
        g.dispose();
        this.bounds = null;
        this.width = (int)this.stringWidth(this.theText[0], metrics, g);
        this.height = metrics.getHeight();
        this.x = (int)x;
        this.y = (int)(y - (double)this.height);
        this.setAntialiased(true);
    }

    public TextRoi(double x, double y, String text) {
        super(x, y, 1.0, 1.0);
        this.init(text, null);
    }

    public TextRoi(int x, int y, String text, Font font) {
        super(x, y, 1, 1);
        this.init(text, font);
    }

    public TextRoi(double x, double y, String text, Font font) {
        super(x, y, 1.0, 1.0);
        this.init(text, font);
    }

    public TextRoi(double x, double y, double width, double height, String text, Font font) {
        super(x, y, width, height);
        this.init(text, font);
    }

    private void init(String text, Font font) {
        String[] lines = Tools.split(text, "\n");
        int count = Math.min(lines.length, 50);
        for (int i = 0; i < count; ++i) {
            this.theText[i] = lines[i];
        }
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        this.firstChar = false;
        if (this.width == 1 && this.height == 1) {
            Graphics g;
            ImageJ ij = IJ.getInstance();
            Graphics graphics = g = ij != null ? ij.getGraphics() : null;
            if (g != null) {
                this.updateBounds(g);
            }
        }
        if (IJ.debugMode) {
            IJ.log("TextRoi: " + this.theText[0] + "  " + this.getBounds());
        }
    }

    public TextRoi(int x, int y, String text, Font font, Color color) {
        super(x, y, 1, 1);
        if (font == null) {
            font = new Font(name, style, size);
        }
        this.instanceFont = font;
        IJ.error("TextRoi", "API has changed. See updated example at\nhttp://imagej.nih.gov/ij/macros/js/TextOverlay.js");
    }

    public TextRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        ImageCanvas ic = imp.getCanvas();
        double mag = this.getMagnification();
        if (mag > 1.0) {
            mag = 1.0;
        }
        if ((double)size < 12.0 / mag) {
            size = (int)(12.0 / mag);
        }
        if (firstTime) {
            this.theText[0] = line1;
            this.theText[1] = line2;
            this.theText[2] = line3;
            firstTime = false;
        } else {
            this.theText[0] = line1a;
        }
        if (previousRoi != null && previousRoi instanceof TextRoi) {
            this.firstMouseUp = false;
            previousRoi = null;
        }
        this.instanceFont = new Font(name, style, size);
        this.justification = globalJustification;
        this.setStrokeColor(Toolbar.getForegroundColor());
        if (WindowManager.getWindow("Fonts") != null) {
            this.setFillColor(defaultFillColor);
            this.setAngle(defaultAngle);
        }
    }

    public void addChar(char c) {
        if (this.imp == null) {
            return;
        }
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            for (int i = 1; i < 50; ++i) {
                this.theText[i] = null;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            if (this.angle != 0.0) {
                this.imp.draw();
            } else {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            }
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] chr = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(chr);
            this.updateBounds(null);
            this.updateText();
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
        this.updateBounds(null);
        this.updateText();
    }

    Font getScaledFont() {
        if (this.nonScalable) {
            return this.instanceFont;
        }
        if (this.instanceFont == null) {
            this.instanceFont = new Font(name, style, size);
        }
        double mag = this.getMagnification();
        return this.instanceFont.deriveFont((float)((double)this.instanceFont.getSize() * mag));
    }

    public void drawPixels(ImageProcessor ip) {
        ip.setFont(this.instanceFont);
        ip.setAntialiasedText(this.antialiased);
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        int i = 0;
        int yy = 0;
        int xi = (int)Math.round(this.getXBase());
        int yi = (int)Math.round(this.getYBase());
        while (i < 50 && this.theText[i] != null) {
            switch (this.justification) {
                case 0: {
                    ip.drawString(this.theText[i], xi, yi + yy + fontHeight);
                    break;
                }
                case 1: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    ip.drawString(this.theText[i], xi + (this.width - tw) / 2, yi + yy + fontHeight);
                    break;
                }
                case 2: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    ip.drawString(this.theText[i], xi + this.width - tw, yi + yy + fontHeight);
                }
            }
            ++i;
            yy += fontHeight;
        }
    }

    public void draw(Graphics g) {
        if (IJ.debugMode) {
            IJ.log("draw: " + this.theText[0] + "  " + this.width + "," + this.height);
        }
        if (Interpreter.isBatchMode() && this.ic != null && this.ic.getDisplayList() != null) {
            return;
        }
        if (newFont || this.width == 1) {
            this.updateBounds(g);
        }
        Color c = this.getStrokeColor();
        this.setStrokeColor(TextRoi.getColor());
        super.draw(g);
        this.setStrokeColor(c);
        double mag = this.getMagnification();
        int sx = this.screenXD(this.getXBase());
        int sy = this.screenYD(this.getYBase());
        int swidth = (int)((this.bounds != null ? this.bounds.width : (double)this.width) * mag);
        int sheight = (int)((this.bounds != null ? this.bounds.height : (double)this.height) * mag);
        Rectangle r = null;
        if (this.angle != 0.0) {
            this.drawText(g);
        } else {
            r = g.getClipBounds();
            g.setClip(sx, sy, swidth, sheight);
            this.drawText(g);
            if (r != null) {
                g.setClip(r.x, r.y, r.width, r.height);
            }
        }
    }

    public void drawOverlay(Graphics g) {
        this.drawText(g);
    }

    void drawText(Graphics g) {
        g.setColor(this.strokeColor != null ? this.strokeColor : ROIColor);
        Java2.setAntialiasedText(g, this.antialiased);
        if (newFont || this.width == 1) {
            this.updateBounds(g);
        }
        double mag = this.getMagnification();
        int xi = (int)Math.round(this.getXBase());
        int yi = (int)Math.round(this.getYBase());
        double widthd = this.bounds != null ? this.bounds.width : (double)this.width;
        double heightd = this.bounds != null ? this.bounds.height : (double)this.height;
        int widthi = (int)Math.round(widthd);
        int heighti = (int)Math.round(heightd);
        int sx = this.nonScalable ? xi : this.screenXD(this.getXBase());
        int sy = this.nonScalable ? yi : this.screenYD(this.getYBase());
        int sw = this.nonScalable ? widthi : (int)(this.getMagnification() * widthd);
        int sh = this.nonScalable ? heighti : (int)(this.getMagnification() * heightd);
        Font font = this.getScaledFont();
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = null;
        if (this.angle != 0.0) {
            at = g2d.getTransform();
            double cx = sx;
            double cy = sy;
            double theta = Math.toRadians(this.angle);
            if (this.drawStringMode) {
                cx = this.screenX(this.x);
                cy = this.screenY(this.y + this.height - descent);
            }
            g2d.rotate(-theta, cx, cy);
        }
        int i = 0;
        if (this.fillColor != null) {
            this.updateBounds(g);
            Color c = g.getColor();
            int alpha = this.fillColor.getAlpha();
            g.setColor(this.fillColor);
            g.fillRect(sx, sy, sw, sh);
            g.setColor(c);
        }
        int y2 = this.y;
        while (i < 50 && this.theText[i] != null) {
            switch (this.justification) {
                case 0: {
                    if (this.drawStringMode) {
                        g.drawString(this.theText[i], this.screenX(this.x), this.screenY(y2 + this.height - descent));
                        y2 = (int)((double)y2 + (double)fontHeight / mag);
                        break;
                    }
                    g.drawString(this.theText[i], sx, sy + fontHeight - descent);
                    break;
                }
                case 1: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    g.drawString(this.theText[i], sx + (sw - tw) / 2, sy + fontHeight - descent);
                    break;
                }
                case 2: {
                    int tw = metrics.stringWidth(this.theText[i]);
                    g.drawString(this.theText[i], sx + sw - tw, sy + fontHeight - descent);
                }
            }
            ++i;
            sy += fontHeight;
        }
        if (at != null) {
            g2d.setTransform(at);
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public void setCurrentFont(Font font) {
        this.instanceFont = font;
        this.updateBounds(null);
    }

    public Font getCurrentFont() {
        return this.instanceFont;
    }

    public static boolean isAntialiased() {
        return antialiasedText;
    }

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
        if (this.angle > 0.0) {
            this.antialiased = true;
        }
    }

    public boolean getAntialiased() {
        return this.antialiased;
    }

    public static void setGlobalJustification(int justification) {
        Roi roi;
        if (justification < 0 || justification > 2) {
            justification = 0;
        }
        globalJustification = justification;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).setJustification(justification);
            imp.draw();
        }
    }

    public static int getGlobalJustification() {
        return globalJustification;
    }

    public void setJustification(int justification) {
        if (justification < 0 || justification > 2) {
            justification = 0;
        }
        this.justification = justification;
    }

    public int getJustification() {
        return this.justification;
    }

    public static void setFont(String fontName, int fontSize, int fontStyle) {
        TextRoi.setFont(fontName, fontSize, fontStyle, true);
    }

    public static void setFont(String fontName, int fontSize, int fontStyle, boolean antialiased) {
        Roi roi;
        name = fontName;
        size = fontSize;
        style = fontStyle;
        globalJustification = 0;
        antialiasedText = antialiased;
        newFont = true;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            ((TextRoi)roi).setAntialiased(antialiased);
            ((TextRoi)roi).setCurrentFont(new Font(name, style, size));
            imp.draw();
        }
    }

    public static void setDefaultFillColor(Color fillColor) {
        defaultFillColor = fillColor;
    }

    public static void setDefaultAngle(double angle) {
        defaultAngle = angle;
    }

    protected void handleMouseUp(int screenX, int screenY) {
        super.handleMouseUp(screenX, screenY);
        if (this.firstMouseUp) {
            this.updateBounds(null);
            this.updateText();
            this.firstMouseUp = false;
        } else if (this.width < 5 || this.height < 5) {
            this.imp.deleteRoi();
        }
    }

    void updateBounds(Graphics g) {
        boolean nullg;
        double mag;
        if (this.firstChar || this.drawStringMode) {
            return;
        }
        double d = mag = this.ic != null ? this.ic.getMagnification() : 1.0;
        if (this.nonScalable) {
            mag = 1.0;
        }
        Font font = this.getScaledFont();
        newFont = false;
        boolean bl = nullg = g == null;
        if (nullg) {
            if (this.ic != null) {
                g = this.ic.getGraphics();
            } else {
                return;
            }
        }
        Java2.setAntialiasedText(g, this.antialiased);
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = (int)((double)metrics.getHeight() / mag);
        int descent = metrics.getDescent();
        int i = 0;
        int nLines = 0;
        Rectangle2D.Double b = this.bounds;
        if (b == null) {
            b = new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }
        double oldXD = b.x;
        double oldYD = b.y;
        double oldWidthD = b.width;
        double oldHeightD = b.height;
        double newWidth = 10.0;
        while (i < 50 && this.theText[i] != null) {
            ++nLines;
            double w = this.stringWidth(this.theText[i], metrics, g) / mag;
            if (w > newWidth) {
                newWidth = w;
            }
            ++i;
        }
        if (nullg) {
            g.dispose();
        }
        b.width = newWidth += 2.0;
        switch (this.justification) {
            case 0: {
                if (this.xMax == 0 || !((double)this.x + newWidth > (double)this.xMax) || this.width == 1) break;
                b.x = this.xMax - this.width;
                break;
            }
            case 1: {
                b.x = (double)this.oldX + (double)this.oldWidth / 2.0 - newWidth / 2.0;
                break;
            }
            case 2: {
                b.x = (double)(this.oldX + this.oldWidth) - newWidth;
            }
        }
        b.height = nLines * fontHeight + 2;
        if (this.yMax != 0) {
            if (b.height > (double)this.yMax) {
                b.height = this.yMax;
            }
            if (b.y + b.height > (double)this.yMax) {
                b.y = this.yMax - this.height;
            }
        }
        this.x = (int)b.x;
        this.y = (int)b.y;
        this.width = (int)Math.ceil(b.width);
        this.height = (int)Math.ceil(b.height);
    }

    void updateText() {
        if (this.imp != null) {
            this.updateClipRect();
            if (this.angle != 0.0) {
                this.imp.draw();
            } else {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            }
        }
    }

    double stringWidth(String s, FontMetrics metrics, Graphics g) {
        Rectangle2D r = metrics.getStringBounds(s, g);
        return r.getWidth();
    }

    public String getMacroCode(String cmd, ImagePlus imp) {
        String code = "";
        boolean script = Recorder.scriptMode();
        boolean addSelection = cmd.startsWith("Add");
        if (script && !addSelection) {
            code = code + "ip = imp.getProcessor();\n";
        }
        if (script) {
            String str = "Font.PLAIN";
            if (style == 1) {
                str = "Font.BOLD";
            } else if (style == 2) {
                str = "Font.ITALIC";
            }
            code = code + "font = new Font(\"" + name + "\", " + str + ", " + size + ");\n";
            if (addSelection) {
                return this.getAddSelectionScript(code);
            }
            code = code + "ip.setFont(font);\n";
        } else {
            String options = "";
            if (style == 1) {
                options = options + "bold";
            }
            if (style == 2) {
                options = options + " italic";
            }
            if (antialiasedText) {
                options = options + " antialiased";
            }
            if (options.equals("")) {
                options = "plain";
            }
            code = code + "setFont(\"" + name + "\", " + size + ", \"" + options + "\");\n";
        }
        ImageProcessor ip = imp.getProcessor();
        ip.setFont(new Font(name, style, size));
        FontMetrics metrics = ip.getFontMetrics();
        int fontHeight = metrics.getHeight();
        code = script ? code + "ip.setColor(new Color(" + this.getColorArgs(this.getStrokeColor()) + "));\n" : code + "setColor(\"" + Colors.colorToString(this.getStrokeColor()) + "\");\n";
        if (addSelection) {
            code = code + "Overlay.drawString(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ", " + this.getAngle() + ");\n";
            code = code + "Overlay.show();\n";
        } else {
            code = code + (script ? "ip." : "") + "drawString(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
            code = script ? code + "imp.updateAndDraw();\n" : code + "//makeText(\"" + this.text() + "\", " + this.x + ", " + (this.y + fontHeight) + ");\n";
        }
        return code;
    }

    private String text() {
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i];
            if (this.theText[i + 1] == null) continue;
            text = text + "\\n";
        }
        return text;
    }

    private String getAddSelectionScript(String code) {
        code = code + "roi = new TextRoi(" + this.x + ", " + this.y + ", \"" + this.text() + "\", font);\n";
        code = code + "roi.setStrokeColor(new Color(" + this.getColorArgs(this.getStrokeColor()) + "));\n";
        if (this.getFillColor() != null) {
            code = code + "roi.setFillColor(new Color(" + this.getColorArgs(this.getFillColor()) + "));\n";
        }
        if (this.getAngle() != 0.0) {
            code = code + "roi.setAngle(" + this.getAngle() + ");\n";
        }
        code = code + "overlay.add(roi);\n";
        return code;
    }

    private String getColorArgs(Color c) {
        return IJ.d2s((double)c.getRed() / 255.0, 2) + ", " + IJ.d2s((double)c.getGreen() / 255.0, 2) + ", " + IJ.d2s((double)c.getBlue() / 255.0, 2);
    }

    public String getText() {
        String text = "";
        for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
            text = text + this.theText[i] + "\n";
        }
        return text;
    }

    public boolean isDrawingTool() {
        return true;
    }

    public void clear(ImageProcessor ip) {
        if (this.instanceFont == null) {
            ip.fill();
        } else {
            ip.setFont(this.instanceFont);
            ip.setAntialiasedText(antialiasedText);
            int width = 0;
            for (int i = 0; i < 50 && this.theText[i] != null; ++i) {
                int w = ip.getStringWidth(this.theText[i]);
                if (w <= width) continue;
                width = w;
            }
            Rectangle r = ip.getRoi();
            if (width > r.width) {
                r.width = width;
                ip.setRoi(r);
            }
            ip.fill();
        }
    }

    public synchronized Object clone() {
        TextRoi tr = (TextRoi)super.clone();
        tr.theText = new String[50];
        for (int i = 0; i < 50; ++i) {
            tr.theText[i] = this.theText[i];
        }
        return tr;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        if (angle != 0.0) {
            this.setAntialiased(true);
        }
    }

    public boolean getDrawStringMode() {
        return this.drawStringMode;
    }

    public void setDrawStringMode(boolean drawStringMode) {
        this.drawStringMode = drawStringMode;
    }

    static {
        firstTime = true;
    }
}

