/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.EllipseRoi;
import ij.gui.GenericDialog;
import ij.gui.HistogramWindow;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.ProgressBar;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.gui.WaitForUserDialog;
import ij.gui.Wand;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.macro.ExtensionDescriptor;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.MacroExtension;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.macro.Variable;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.Colors;
import ij.plugin.ImageCalculator;
import ij.plugin.MacroInstaller;
import ij.plugin.Macro_Runner;
import ij.plugin.Straightener;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.Info;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.frame.Channels;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Fitter;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.RoiManager;
import ij.plugin.frame.ThresholdAdjuster;
import ij.process.AutoThresholder;
import ij.process.ColorProcessor;
import ij.process.FloatBlitter;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.FloodFiller;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;
import ij.text.TextPanel;
import ij.text.TextWindow;
import ij.util.StringSorter;
import ij.util.Tools;
import ij.util.WildcardMatch;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;

public class Functions
implements MacroConstants,
Measurements {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImageProcessor defaultIP;
    int imageType;
    boolean colorSet;
    boolean fontSet;
    Color defaultColor;
    double defaultValue = Double.NaN;
    Plot plot;
    static int plotID;
    int justification = 0;
    Font font;
    GenericDialog gd;
    PrintWriter writer;
    boolean altKeyDown;
    boolean shiftKeyDown;
    boolean antialiasedText;
    StringBuffer buffer;
    RoiManager roiManager;
    Properties props;
    CurveFitter fitter;
    boolean showFitDialog;
    boolean logFitResults;
    boolean resultsPending;
    Overlay offscreenOverlay;
    Overlay overlayClipboard;
    GeneralPath overlayPath;
    boolean overlayDrawLabels;
    boolean saveSettingsCalled;
    boolean usePointerCursor;
    boolean hideProcessStackDialog;
    float divideByZeroValue;
    int jpegQuality;
    int saveLineWidth;
    boolean doScaling;
    boolean weightedColor;
    double[] weights;
    boolean interpolateScaledImages;
    boolean open100Percent;
    boolean blackCanvas;
    boolean useJFileChooser;
    boolean debugMode;
    Color foregroundColor;
    Color backgroundColor;
    Color roiColor;
    boolean pointAutoMeasure;
    boolean requireControlKey;
    boolean useInvertingLut;
    boolean disablePopup;
    int measurements;
    int decimalPlaces;
    boolean blackBackground;
    boolean autoContrast;
    static WaitForUserDialog waitForUserDialog;
    int pasteMode;
    int lineWidth = 1;
    boolean expandableArrays;
    int plotWidth;
    int plotHeight;
    boolean plotInterpolate;
    boolean plotNoGridLines;
    Random ran;

    Functions(Interpreter interp, Program pgm) {
        this.interp = interp;
        this.pgm = pgm;
    }

    void doFunction(int type) {
        switch (type) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: 
            case 308: {
                this.print();
                break;
            }
            case 309: {
                this.doWand();
                break;
            }
            case 310: {
                this.setMinAndMax();
                break;
            }
            case 311: {
                this.setThreshold();
                break;
            }
            case 312: {
                this.setTool();
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 402: {
                this.makeArrow();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                this.doCommand();
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                this.showProgress();
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 351: {
                this.showMessage(true);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(type);
                break;
            }
            case 337: {
                this.setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                this.selectImage();
                break;
            }
            case 340: {
                this.exit();
                break;
            }
            case 341: {
                this.setLocation();
                break;
            }
            case 342: {
                this.getCursorLoc();
                break;
            }
            case 343: {
                this.getLine();
                break;
            }
            case 344: {
                this.getVoxelSize();
                break;
            }
            case 345: {
                this.getHistogram();
                break;
            }
            case 347: 
            case 375: {
                this.getBounds();
                break;
            }
            case 348: {
                this.getLut();
                break;
            }
            case 349: {
                this.setLut();
                break;
            }
            case 350: {
                this.getCoordinates();
                break;
            }
            case 352: {
                this.makeSelection();
                break;
            }
            case 353: {
                this.setResult();
                break;
            }
            case 354: {
                this.updateResults();
                break;
            }
            case 355: {
                this.setBatchMode();
                break;
            }
            case 356: {
                this.doPlot();
                break;
            }
            case 357: {
                this.setJustification();
                break;
            }
            case 358: {
                this.setZCoordinate();
                break;
            }
            case 359: {
                this.getThreshold();
                break;
            }
            case 360: {
                this.getPixelSize();
                break;
            }
            case 361: {
                this.interp.getParens();
                Undo.setup(6, this.getImage());
                break;
            }
            case 362: {
                this.saveSettings();
                break;
            }
            case 363: {
                this.restoreSettings();
                break;
            }
            case 364: {
                this.setKeyDown();
                break;
            }
            case 365: {
                this.open();
                break;
            }
            case 366: {
                this.setFont();
                break;
            }
            case 367: {
                this.getMinAndMax();
                break;
            }
            case 368: {
                this.close();
                break;
            }
            case 369: {
                this.setSlice();
                break;
            }
            case 370: {
                this.newImage();
                break;
            }
            case 372: {
                IJ.save(this.getStringArg());
                break;
            }
            case 371: {
                this.saveAs();
                break;
            }
            case 373: {
                this.setAutoThreshold();
                break;
            }
            case 374: {
                this.getImage().setTitle(this.getStringArg());
                break;
            }
            case 346: {
                this.getStatistics(true);
                break;
            }
            case 377: {
                this.getStatistics(false);
                break;
            }
            case 378: {
                this.floodFill();
                break;
            }
            case 379: {
                this.restorePreviousTool();
                break;
            }
            case 380: {
                this.setVoxelSize();
                break;
            }
            case 381: {
                this.getLocationAndSize();
                break;
            }
            case 382: {
                this.getDateAndTime();
                break;
            }
            case 383: {
                this.setMetadata();
                break;
            }
            case 384: {
                this.imageCalculator();
                break;
            }
            case 385: {
                this.setRGBWeights();
                break;
            }
            case 386: {
                this.makePolygon();
                break;
            }
            case 387: {
                this.setSelectionName();
                break;
            }
            case 376: 
            case 388: 
            case 389: 
            case 390: {
                this.drawOrFill(type);
                break;
            }
            case 391: {
                this.setOption();
                break;
            }
            case 392: {
                this.showText();
                break;
            }
            case 393: {
                this.setSelectionLocation();
                break;
            }
            case 394: {
                this.getDimensions();
                break;
            }
            case 395: {
                this.waitForUser();
                break;
            }
            case 396: {
                this.makePoint();
                break;
            }
            case 397: {
                this.makeText();
                break;
            }
            case 398: {
                this.makeEllipse();
                break;
            }
            case 399: {
                this.getDisplayedArea();
                break;
            }
            case 400: {
                this.toScaled();
                break;
            }
            case 401: {
                this.toUnscaled();
            }
        }
    }

    final double getFunctionValue(int type) {
        double value = 0.0;
        switch (type) {
            case 1000: {
                value = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1027: 
            case 1046: 
            case 1047: {
                value = this.math(type);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: 
            case 1036: {
                value = this.math2(type);
                break;
            }
            case 1013: {
                this.interp.getParens();
                value = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                value = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                value = this.getImage().getHeight();
                break;
            }
            case 1016: {
                value = this.random();
                break;
            }
            case 1018: 
            case 1023: {
                value = this.getResultsCount();
                break;
            }
            case 1017: {
                value = this.getResult();
                break;
            }
            case 1019: {
                value = this.getNumber();
                break;
            }
            case 1020: {
                value = this.getImageCount();
                break;
            }
            case 1021: {
                value = this.getStackSize();
                break;
            }
            case 1022: {
                value = this.lengthOf();
                break;
            }
            case 1024: {
                this.interp.getParens();
                value = this.getImage().getID();
                break;
            }
            case 1025: {
                this.interp.getParens();
                value = this.getImage().getBitDepth();
                break;
            }
            case 1026: {
                value = this.getSelectionType();
                break;
            }
            case 1028: {
                value = this.isOpen();
                break;
            }
            case 1029: {
                value = this.isActive();
                break;
            }
            case 1030: {
                value = this.indexOf();
                break;
            }
            case 1031: {
                value = this.getFirstString().lastIndexOf(this.getLastString());
                break;
            }
            case 1032: {
                value = this.charCodeAt();
                break;
            }
            case 1033: {
                value = this.getBoolean();
                break;
            }
            case 1034: 
            case 1035: {
                value = this.startsWithEndsWith(type);
                break;
            }
            case 1037: {
                value = Double.isNaN(this.getArg()) ? 1.0 : 0.0;
                break;
            }
            case 1038: {
                value = this.getZoom();
                break;
            }
            case 1040: {
                value = this.parseDouble(this.getStringArg());
                break;
            }
            case 1039: {
                value = this.parseInt();
                break;
            }
            case 1041: {
                value = this.isKeyDown();
                break;
            }
            case 1042: {
                this.interp.getParens();
                value = this.getImage().getCurrentSlice();
                break;
            }
            case 1043: 
            case 1044: {
                value = this.getScreenDimension(type);
                break;
            }
            case 1045: {
                value = this.getImage().getCalibration().getCValue(this.getArg());
                break;
            }
            case 1048: {
                value = this.roiManager();
                break;
            }
            case 1049: {
                this.interp.getParens();
                value = Toolbar.getToolId();
                break;
            }
            case 1050: {
                value = this.is();
                break;
            }
            case 1051: {
                value = this.getValue();
                break;
            }
            case 1052: {
                value = this.doStack();
                break;
            }
            case 1053: {
                value = this.matches();
                break;
            }
            case 1054: {
                value = this.getStringWidth();
                break;
            }
            case 1055: {
                value = this.fit();
                break;
            }
            case 1056: {
                value = this.overlay();
                break;
            }
            case 1057: {
                value = this.selectionContains();
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return value;
    }

    String getStringFunction(int type) {
        String str;
        switch (type) {
            case 2000: {
                str = this.d2s();
                break;
            }
            case 2001: {
                str = this.toString(16);
                break;
            }
            case 2002: {
                str = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                str = this.getImage().getTitle();
                break;
            }
            case 2004: {
                str = this.getStringDialog();
                break;
            }
            case 2005: {
                str = this.substring();
                break;
            }
            case 2006: {
                str = this.fromCharCode();
                break;
            }
            case 2007: {
                str = this.getInfo();
                break;
            }
            case 2010: {
                this.interp.getParens();
                str = this.getImageInfo();
                break;
            }
            case 2008: {
                str = this.getDirectory();
                break;
            }
            case 2009: {
                this.interp.getParens();
                str = this.interp.argument != null ? this.interp.argument : "";
                break;
            }
            case 2011: {
                str = this.getStringArg().toLowerCase(Locale.US);
                break;
            }
            case 2012: {
                str = this.getStringArg().toUpperCase(Locale.US);
                break;
            }
            case 2013: {
                str = this.runMacro(false);
                break;
            }
            case 2014: {
                str = this.runMacro(true);
                break;
            }
            case 2015: {
                str = this.doToString();
                break;
            }
            case 2016: {
                str = this.replace();
                break;
            }
            case 2017: {
                str = this.doDialog();
                break;
            }
            case 2018: {
                str = this.getMetadata();
                break;
            }
            case 2019: {
                str = this.doFile();
                break;
            }
            case 2020: {
                str = this.selectionName();
                break;
            }
            case 2021: {
                this.interp.getParens();
                str = IJ.getVersion();
                break;
            }
            case 2022: {
                str = this.getResultLabel();
                break;
            }
            case 2023: {
                str = this.call();
                break;
            }
            case 2024: {
                str = this.doString();
                break;
            }
            case 2025: {
                str = this.doExt();
                break;
            }
            case 2026: {
                str = this.exec();
                break;
            }
            case 2027: {
                str = this.doList();
                break;
            }
            case 2028: {
                str = this.debug();
                break;
            }
            case 2029: {
                str = this.ijCall();
                break;
            }
            case 2030: {
                str = this.getResultString();
                break;
            }
            case 2031: {
                str = this.doRoi();
                break;
            }
            default: {
                str = "";
                this.interp.error("String function expected");
            }
        }
        return str;
    }

    private void setLineWidth(int width) {
        this.lineWidth = width;
        this.getProcessor().setLineWidth(width);
    }

    Variable[] getArrayFunction(int type) {
        Variable[] array;
        switch (type) {
            case 3000: {
                array = this.getProfile();
                break;
            }
            case 3001: {
                array = this.newArray();
                break;
            }
            case 3002: {
                array = this.split();
                break;
            }
            case 3003: {
                array = this.getFileList();
                break;
            }
            case 3004: {
                array = this.getFontList();
                break;
            }
            case 3005: {
                array = this.newMenu();
                break;
            }
            case 3006: {
                array = this.getList();
                break;
            }
            case 3007: {
                array = this.doArray();
                break;
            }
            default: {
                array = null;
                this.interp.error("Array function expected");
            }
        }
        return array;
    }

    final double math(int type) {
        double arg = this.getArg();
        switch (type) {
            case 1001: {
                return Math.abs(arg);
            }
            case 1002: {
                return Math.cos(arg);
            }
            case 1003: {
                return Math.exp(arg);
            }
            case 1004: {
                return Math.floor(arg);
            }
            case 1005: {
                return Math.log(arg);
            }
            case 1009: {
                return Math.floor(arg + 0.5);
            }
            case 1010: {
                return Math.sin(arg);
            }
            case 1011: {
                return Math.sqrt(arg);
            }
            case 1012: {
                return Math.tan(arg);
            }
            case 1027: {
                return Math.atan(arg);
            }
            case 1046: {
                return Math.asin(arg);
            }
            case 1047: {
                return Math.acos(arg);
            }
        }
        return 0.0;
    }

    final double math2(int type) {
        double a1 = this.getFirstArg();
        double a2 = this.getLastArg();
        switch (type) {
            case 1007: {
                return Math.min(a1, a2);
            }
            case 1006: {
                return Math.max(a1, a2);
            }
            case 1008: {
                return Math.pow(a1, a2);
            }
            case 1036: {
                return Math.atan2(a1, a2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String str = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            str = str + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return str;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double arg = this.interp.getExpression();
        this.interp.getRightParen();
        return arg;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    final String getFirstString() {
        this.interp.getLeftParen();
        return this.getString();
    }

    final String getNextString() {
        this.interp.getComma();
        return this.getString();
    }

    final String getLastString() {
        this.interp.getComma();
        String arg = this.getString();
        this.interp.getRightParen();
        return arg;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double arg = this.interp.getBooleanExpression();
        this.interp.checkBoolean(arg);
        this.interp.getRightParen();
        return arg != 0.0;
    }

    final Variable getVariableArg() {
        this.interp.getLeftParen();
        Variable v = this.getVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getFirstVariable() {
        this.interp.getLeftParen();
        return this.getVariable();
    }

    final Variable getNextVariable() {
        this.interp.getComma();
        return this.getVariable();
    }

    final Variable getLastVariable() {
        this.interp.getComma();
        Variable v = this.getVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getVariable() {
        Variable[] array;
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        if ((array = v.getArray()) != null) {
            int index = this.interp.getIndex();
            this.checkIndex(index, 0, v.getArraySize() - 1);
            v = array[index];
        }
        return v;
    }

    final Variable getFirstArrayVariable() {
        this.interp.getLeftParen();
        return this.getArrayVariable();
    }

    final Variable getNextArrayVariable() {
        this.interp.getComma();
        return this.getArrayVariable();
    }

    final Variable getLastArrayVariable() {
        this.interp.getComma();
        Variable v = this.getArrayVariable();
        this.interp.getRightParen();
        return v;
    }

    final Variable getArrayVariable() {
        Variable v;
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Variable expected");
        }
        if ((v = this.interp.lookupLocalVariable(this.interp.tokenAddress)) == null) {
            v = this.interp.push(this.interp.tokenAddress, 0.0, null, this.interp);
        }
        return v;
    }

    final double[] getFirstArray() {
        this.interp.getLeftParen();
        return this.getNumericArray();
    }

    final double[] getNextArray() {
        this.interp.getComma();
        return this.getNumericArray();
    }

    final double[] getLastArray() {
        this.interp.getComma();
        double[] a = this.getNumericArray();
        this.interp.getRightParen();
        return a;
    }

    double[] getNumericArray() {
        Variable[] a1 = this.getArray();
        double[] a2 = new double[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            a2[i] = a1[i].getValue();
        }
        return a2;
    }

    String[] getStringArray() {
        Variable[] a1 = this.getArray();
        String[] a2 = new String[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            String s = a1[i].getString();
            if (s == null) {
                s = "" + a1[i].getValue();
            }
            a2[i] = s;
        }
        return a2;
    }

    Variable[] getArray() {
        Variable[] a;
        boolean newArray;
        this.interp.getToken();
        boolean bl = newArray = this.interp.token == 137 && this.pgm.table[this.interp.tokenAddress].type == 3001;
        if (this.interp.token != 129 && !newArray) {
            this.interp.error("Array expected");
        }
        if (newArray) {
            a = this.getArrayFunction(3001);
        } else {
            Variable v = this.interp.lookupVariable();
            a = v.getArray();
            int size = v.getArraySize();
            if (a != null && a.length != size) {
                Variable[] a2 = new Variable[size];
                for (int i = 0; i < size; ++i) {
                    a2[i] = a[i];
                }
                v.setArray(a2);
                a = v.getArray();
            }
        }
        if (a == null) {
            this.interp.error("Array expected");
        }
        return a;
    }

    private Color getColor() {
        String color = this.getString();
        if ((color = color.toLowerCase(Locale.US)).equals("black")) {
            return Color.black;
        }
        if (color.equals("white")) {
            return Color.white;
        }
        if (color.equals("red")) {
            return Color.red;
        }
        if (color.equals("green")) {
            return Color.green;
        }
        if (color.equals("blue")) {
            return Color.blue;
        }
        if (color.equals("cyan")) {
            return Color.cyan;
        }
        if (color.equals("darkgray")) {
            return Color.darkGray;
        }
        if (color.equals("gray")) {
            return Color.gray;
        }
        if (color.equals("lightgray")) {
            return Color.lightGray;
        }
        if (color.equals("magenta")) {
            return Color.magenta;
        }
        if (color.equals("orange")) {
            return Color.orange;
        }
        if (color.equals("yellow")) {
            return Color.yellow;
        }
        if (color.equals("pink")) {
            return Color.pink;
        }
        if (color.startsWith("#")) {
            return Colors.decode(color, Color.black);
        }
        this.interp.error("'red', 'green', or '#0000ff' etc. expected");
        return null;
    }

    void checkIndex(int index, int lower, int upper) {
        if (index < lower || index > upper) {
            this.interp.error("Index (" + index + ") is outside of the " + lower + "-" + upper + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String arg1 = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String arg2 = null;
        if (this.interp.token == 44) {
            arg2 = this.getString();
            this.interp.getRightParen();
        }
        if (arg2 != null) {
            IJ.run(arg1, arg2);
        } else {
            IJ.run(arg1);
        }
        this.resetImage();
        IJ.setKeyUp(-1);
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    void setForegroundColor() {
        boolean isImage = WindowManager.getCurrentImage() != null;
        int lineWidth = 0;
        if (isImage) {
            lineWidth = this.getProcessor().getLineWidth();
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        int arg1 = (int)this.getFirstArg();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            red = (arg1 & 0xFF0000) >> 16;
            green = (arg1 & 0xFF00) >> 8;
            blue = arg1 & 0xFF;
        } else {
            red = arg1;
            green = (int)this.getNextArg();
            blue = (int)this.getLastArg();
        }
        IJ.setForegroundColor(red, green, blue);
        this.resetImage();
        if (isImage) {
            this.setLineWidth(lineWidth);
        }
        this.defaultColor = null;
        this.defaultValue = Double.NaN;
    }

    void setBackgroundColor() {
        int red = 0;
        int green = 0;
        int blue = 0;
        int arg1 = (int)this.getFirstArg();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            red = (arg1 & 0xFF0000) >> 16;
            green = (arg1 & 0xFF00) >> 8;
            blue = arg1 & 0xFF;
        } else {
            red = arg1;
            green = (int)this.getNextArg();
            blue = (int)this.getLastArg();
        }
        IJ.setBackgroundColor(red, green, blue);
        this.resetImage();
    }

    void setColor() {
        this.colorSet = true;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            this.defaultColor = this.getColor();
            this.getProcessor().setColor(this.defaultColor);
            this.defaultValue = Double.NaN;
            this.interp.getRightParen();
            return;
        }
        double arg1 = this.interp.getExpression();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            this.setColor(arg1);
            return;
        }
        int red = (int)arg1;
        int green = (int)this.getNextArg();
        int blue = (int)this.getLastArg();
        if (red < 0) {
            red = 0;
        }
        if (green < 0) {
            green = 0;
        }
        if (blue < 0) {
            blue = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        this.defaultColor = new Color(red, green, blue);
        this.getProcessor().setColor(this.defaultColor);
        this.defaultValue = Double.NaN;
    }

    void setColor(double value) {
        ImageProcessor ip = this.getProcessor();
        ImagePlus imp = this.getImage();
        switch (imp.getBitDepth()) {
            case 8: {
                if (value < 0.0 || value > 255.0) {
                    this.interp.error("Argument out of 8-bit range (0-255)");
                }
                ip.setValue(value);
                break;
            }
            case 16: {
                if (imp.getLocalCalibration().isSigned16Bit()) {
                    value += 32768.0;
                }
                if (value < 0.0 || value > 65535.0) {
                    this.interp.error("Argument out of 16-bit range (0-65535)");
                }
                ip.setValue(value);
                break;
            }
            default: {
                ip.setValue(value);
            }
        }
        this.defaultValue = value;
        this.defaultColor = null;
    }

    void makeLine() {
        double x1d = this.getFirstArg();
        double y1d = this.getNextArg();
        double x2d = this.getNextArg();
        this.interp.getComma();
        double y2d = this.interp.getExpression();
        this.interp.getToken();
        if (this.interp.token == 41) {
            IJ.makeLine(x1d, y1d, x2d, y2d);
        } else {
            int n;
            int x1 = (int)Math.round(x1d);
            int y1 = (int)Math.round(y1d);
            int x2 = (int)Math.round(x2d);
            int y2 = (int)Math.round(y2d);
            int max = 200;
            int[] x = new int[max];
            int[] y = new int[max];
            x[0] = x1;
            y[0] = y1;
            x[1] = x2;
            y[1] = y2;
            for (n = 2; this.interp.token == 44 && n < max; ++n) {
                x[n] = (int)Math.round(this.interp.getExpression());
                if (n == 2 && this.interp.nextToken() == 41) {
                    this.interp.getRightParen();
                    Line line = new Line(x1d, y1d, x2d, y2d);
                    line.updateWideLine(x[n]);
                    this.getImage().setRoi(line);
                    return;
                }
                this.interp.getComma();
                y[n] = (int)Math.round(this.interp.getExpression());
                this.interp.getToken();
            }
            if (n == max && this.interp.token != 41) {
                this.interp.error("More than " + max + " points");
            }
            this.getImage().setRoi(new PolygonRoi(x, y, n, 6));
        }
        this.resetImage();
    }

    void makeArrow() {
        String options = "";
        double x1 = this.getFirstArg();
        double y1 = this.getNextArg();
        double x2 = this.getNextArg();
        double y2 = this.getNextArg();
        if (this.interp.nextToken() == 44) {
            options = this.getNextString();
        }
        this.interp.getRightParen();
        Arrow arrow = new Arrow(x1, y1, x2, y2);
        arrow.setStyle(options);
        this.getImage().setRoi(arrow);
    }

    void makeOval() {
        Roi previousRoi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        IJ.makeOval(this.getFirstArg(), this.getNextArg(), this.getNextArg(), this.getLastArg());
        Roi roi = this.getImage().getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    void makeRectangle() {
        Roi previousRoi = this.getImage().getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            this.getImage().saveRoi();
        }
        double x = this.getFirstArg();
        double y = this.getNextArg();
        double w = this.getNextArg();
        double h = this.getNextArg();
        int arcSize = 0;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            arcSize = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        if (arcSize < 1) {
            IJ.makeRectangle(x, y, w, h);
        } else {
            ImagePlus imp = this.getImage();
            imp.setRoi(new Roi(x, y, w, h, arcSize));
        }
        Roi roi = this.getImage().getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
        IJ.setKeyUp(-1);
    }

    ImagePlus getImage() {
        ImagePlus imp = IJ.getImage();
        if (imp.getWindow() == null && IJ.getInstance() != null) {
            Functions functions = this;
            if (!functions.interp.isBatchMode() && WindowManager.getTempCurrentImage() == null) {
                throw new RuntimeException("Macro canceled");
            }
        }
        this.defaultIP = null;
        return imp;
    }

    void resetImage() {
        this.defaultIP = null;
        this.fontSet = false;
        this.colorSet = false;
        this.lineWidth = 1;
    }

    ImageProcessor getProcessor() {
        if (this.defaultIP == null) {
            this.defaultIP = this.getImage().getProcessor();
            if (this.lineWidth != 1) {
                this.defaultIP.setLineWidth(this.lineWidth);
            }
        }
        return this.defaultIP;
    }

    int getType() {
        this.imageType = this.getImage().getType();
        return this.imageType;
    }

    void setPixel() {
        this.interp.getLeftParen();
        int a1 = (int)this.interp.getExpression();
        this.interp.getComma();
        double a2 = this.interp.getExpression();
        this.interp.getToken();
        ImageProcessor ip = this.getProcessor();
        if (this.interp.token == 44) {
            double a3 = this.interp.getExpression();
            this.interp.getRightParen();
            if (ip instanceof FloatProcessor) {
                ip.putPixelValue(a1, (int)a2, a3);
            } else {
                ip.putPixel(a1, (int)a2, (int)a3);
            }
        } else {
            if (this.interp.token != 41) {
                this.interp.error("')' expected");
            }
            if (ip instanceof ColorProcessor) {
                ip.set(a1, (int)a2);
            } else {
                ip.setf(a1, (float)a2);
            }
        }
        this.updateNeeded = true;
    }

    double getPixel() {
        this.interp.getLeftParen();
        double a1 = this.interp.getExpression();
        ImageProcessor ip = this.getProcessor();
        double value = 0.0;
        this.interp.getToken();
        if (this.interp.token == 44) {
            double a2 = this.interp.getExpression();
            this.interp.getRightParen();
            int ia1 = (int)a1;
            int ia2 = (int)a2;
            value = a1 == (double)ia1 && a2 == (double)ia2 ? (ip instanceof FloatProcessor ? (double)ip.getPixelValue(ia1, ia2) : (double)ip.getPixel(ia1, ia2)) : (ip instanceof ColorProcessor ? (double)ip.getPixelInterpolated(a1, a2) : ip.getInterpolatedValue(a1, a2));
        } else {
            if (this.interp.token != 41) {
                this.interp.error("')' expected");
            }
            value = ip instanceof ColorProcessor ? (double)ip.get((int)a1) : (double)ip.getf((int)a1);
        }
        return value;
    }

    void setZCoordinate() {
        int z = (int)this.getArg();
        int n = z + 1;
        ImagePlus imp = this.getImage();
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (z < 0 || z >= size) {
            this.interp.error("Z coordinate (" + z + ") is out of 0-" + (size - 1) + " range");
        }
        this.defaultIP = stack.getProcessor(n);
    }

    void moveTo() {
        this.interp.getLeftParen();
        int a1 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int a2 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        this.getProcessor().moveTo(a1, a2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int a1 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int a2 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.lineTo(a1, a2);
        this.updateAndDraw();
    }

    void drawLine() {
        this.interp.getLeftParen();
        int x1 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int y1 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int x2 = (int)Math.round(this.interp.getExpression());
        this.interp.getComma();
        int y2 = (int)Math.round(this.interp.getExpression());
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        ip.drawLine(x1, y1, x2, y2);
        this.updateAndDraw();
    }

    void setForegroundColor(ImageProcessor ip) {
        if (this.defaultColor != null) {
            ip.setColor(this.defaultColor);
        } else if (!Double.isNaN(this.defaultValue)) {
            ip.setValue(this.defaultValue);
        } else {
            ip.setColor(Toolbar.getForegroundColor());
        }
        this.colorSet = true;
    }

    void doIPMethod(int type) {
        this.interp.getParens();
        ImageProcessor ip = this.getProcessor();
        switch (type) {
            case 333: {
                ip.snapshot();
                break;
            }
            case 334: {
                ip.reset();
                this.updateNeeded = true;
                break;
            }
            case 335: {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                if (!this.colorSet) {
                    this.setForegroundColor(ip);
                }
                if (roi == null) {
                    ip.resetRoi();
                    ip.fill();
                } else {
                    ip.setRoi(roi);
                    ip.fill(ip.getMask());
                }
                imp.updateAndDraw();
            }
        }
    }

    void updateAndDraw() {
        if (this.autoUpdate) {
            ImagePlus imp = this.getImage();
            imp.updateChannelAndDraw();
            imp.changes = true;
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded && WindowManager.getImageCount() > 0) {
            ImagePlus imp = this.getImage();
            imp.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String str = this.getString();
        this.interp.getComma();
        int x = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int y = (int)(this.interp.getExpression() + 0.5);
        Color background = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            background = this.getColor();
        }
        this.interp.getRightParen();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        this.setFont(ip);
        ip.setJustification(this.justification);
        ip.setAntialiasedText(this.antialiasedText);
        if (background != null) {
            ip.drawString(str, x, y, background);
        } else {
            ip.drawString(str, x, y);
        }
        this.updateAndDraw();
    }

    void setFont(ImageProcessor ip) {
        if (this.font != null && !this.fontSet) {
            ip.setFont(this.font);
        }
        this.fontSet = true;
    }

    void setJustification() {
        String str = this.getStringArg().toLowerCase(Locale.US);
        int just = 0;
        if (str.equals("center")) {
            just = 1;
        } else if (str.equals("right")) {
            just = 2;
        }
        this.justification = just;
    }

    void changeValues() {
        boolean isFloat;
        double darg1 = this.getFirstArg();
        double darg2 = this.getNextArg();
        double darg3 = this.getLastArg();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        Roi roi = imp.getRoi();
        ImageProcessor mask = null;
        if (roi == null || !roi.isArea()) {
            ip.resetRoi();
            roi = null;
        } else {
            ip.setRoi(roi);
            mask = ip.getMask();
            if (mask != null) {
                ip.snapshot();
            }
        }
        int xmin = 0;
        int ymin = 0;
        int xmax = imp.getWidth();
        int ymax = imp.getHeight();
        if (roi != null) {
            Rectangle r = roi.getBounds();
            xmin = r.x;
            ymin = r.y;
            xmax = r.x + r.width;
            ymax = r.y + r.height;
        }
        boolean bl = isFloat = this.getType() == 2;
        if (imp.getBitDepth() == 24) {
            darg1 = (int)darg1 & 0xFFFFFF;
            darg2 = (int)darg2 & 0xFFFFFF;
        }
        for (int y = ymin; y < ymax; ++y) {
            for (int x = xmin; x < xmax; ++x) {
                double v;
                double d = v = isFloat ? (double)ip.getPixelValue(x, y) : (double)(ip.getPixel(x, y) & 0xFFFFFF);
                if (!(v >= darg1) || !(v <= darg2)) continue;
                if (isFloat) {
                    ip.putPixelValue(x, y, darg3);
                    continue;
                }
                ip.putPixel(x, y, (int)darg3);
            }
        }
        if (mask != null) {
            ip.reset(mask);
        }
        if (imp.getType() == 1 || imp.getType() == 2) {
            ip.resetMinAndMax();
        }
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        double dseed = Double.NaN;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                String arg = this.getString().toLowerCase(Locale.US);
                if (arg.indexOf("seed") == -1) {
                    this.interp.error("'seed' expected");
                }
                this.interp.getComma();
                dseed = this.interp.getExpression();
                long seed = (long)dseed;
                if ((double)seed != dseed) {
                    this.interp.error("Seed not integer");
                }
                this.ran = new Random(seed);
            }
            this.interp.getRightParen();
            if (!Double.isNaN(dseed)) {
                return Double.NaN;
            }
        }
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        String s;
        int col;
        this.interp.getLeftParen();
        String column = this.getString();
        int row = -1;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            row = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        int counter = rt.getCounter();
        if (counter == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (row == -1) {
            row = counter - 1;
        }
        if (row < 0 || row >= counter) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (!rt.columnExists(col = rt.getColumnIndex(column))) {
            return Double.NaN;
        }
        double value = rt.getValueAsDouble(col, row);
        if (Double.isNaN(value) && (s = rt.getStringValue(col, row)) != null && !s.equals("NaN")) {
            value = Tools.parseDouble(s);
        }
        return value;
    }

    String getResultString() {
        int col;
        this.interp.getLeftParen();
        String column = this.getString();
        int row = -1;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            row = (int)this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        int counter = rt.getCounter();
        if (counter == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (row == -1) {
            row = counter - 1;
        }
        if (row < 0 || row >= counter) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (rt.columnExists(col = rt.getColumnIndex(column))) {
            return rt.getStringValue(col, row);
        }
        return "null";
    }

    String getResultLabel() {
        String label;
        int row = (int)this.getArg();
        ResultsTable rt = Analyzer.getResultsTable();
        int counter = rt.getCounter();
        if (counter == 0) {
            this.interp.error("\"Results\" table empty");
        }
        if (row < 0 || row >= counter) {
            this.interp.error("Row (" + row + ") out of range");
        }
        return (label = rt.getLabel(row)) != null ? label : "";
    }

    void setResult() {
        this.interp.getLeftParen();
        String column = this.getString();
        this.interp.getComma();
        int row = (int)this.interp.getExpression();
        this.interp.getComma();
        double value = 0.0;
        String stringValue = null;
        boolean isLabel = column.equals("Label");
        if (this.isStringArg() || isLabel) {
            stringValue = this.getString();
        } else {
            value = this.interp.getExpression();
        }
        this.interp.getRightParen();
        ResultsTable rt = Analyzer.getResultsTable();
        if (row < 0 || row > rt.getCounter()) {
            this.interp.error("Row (" + row + ") out of range");
        }
        if (row == rt.getCounter()) {
            rt.incrementCounter();
        }
        try {
            if (stringValue != null) {
                if (isLabel) {
                    rt.setLabel(stringValue, row);
                } else {
                    rt.setValue(column, row, stringValue);
                }
            } else {
                rt.setValue(column, row, value);
            }
            this.resultsPending = true;
        }
        catch (Exception e) {
            this.interp.error("" + e.getMessage());
        }
    }

    void updateResults() {
        this.interp.getParens();
        ResultsTable rt = Analyzer.getResultsTable();
        rt.show("Results");
        this.resultsPending = false;
    }

    double getNumber() {
        String title;
        String prompt = this.getFirstString();
        double defaultValue = this.getLastArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        int decimalPlaces = (double)((int)defaultValue) == defaultValue ? 0 : 2;
        gd.addNumericField(prompt, defaultValue, decimalPlaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.interp.done = true;
            return defaultValue;
        }
        double v = gd.getNextNumber();
        if (gd.invalidNumber()) {
            return defaultValue;
        }
        return v;
    }

    double getBoolean() {
        YesNoCancelDialog d;
        String title;
        String prompt = this.getStringArg();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        if ((d = new YesNoCancelDialog((Frame)IJ.getInstance(), title, prompt)).cancelPressed()) {
            this.interp.done = true;
            return 0.0;
        }
        if (d.yesPressed()) {
            return 1.0;
        }
        return 0.0;
    }

    String getStringDialog() {
        String title;
        this.interp.getLeftParen();
        String prompt = this.getString();
        this.interp.getComma();
        String defaultStr = this.getString();
        this.interp.getRightParen();
        String string = title = this.interp.macroName != null ? this.interp.macroName : "";
        if (title.endsWith(" Options")) {
            title = title.substring(0, title.length() - 8);
        }
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultStr, 20);
        gd.showDialog();
        String str = "";
        if (gd.wasCanceled()) {
            this.interp.done = true;
        } else {
            str = gd.getNextString();
        }
        return str;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int base) {
        int arg = (int)this.getArg();
        if (base == 2) {
            return Integer.toBinaryString(arg);
        }
        return Integer.toHexString(arg);
    }

    double getStackSize() {
        this.interp.getParens();
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        this.interp.getParens();
        return WindowManager.getImageCount();
    }

    double getResultsCount() {
        this.interp.getParens();
        return Analyzer.getResultsTable().getCounter();
    }

    void getCoordinates() {
        Variable[] ya;
        Variable[] xa;
        Variable xCoordinates = this.getFirstArrayVariable();
        Variable yCoordinates = this.getLastArrayVariable();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        if (roi.getType() == 5) {
            xa = new Variable[2];
            ya = new Variable[2];
            Line line = (Line)roi;
            xa[0] = new Variable(line.x1d);
            ya[0] = new Variable(line.y1d);
            xa[1] = new Variable(line.x2d);
            ya[1] = new Variable(line.y2d);
        } else {
            FloatPolygon fp = roi.getFloatPolygon();
            if (fp != null) {
                int i;
                xa = new Variable[fp.npoints];
                ya = new Variable[fp.npoints];
                for (i = 0; i < fp.npoints; ++i) {
                    xa[i] = new Variable(fp.xpoints[i]);
                }
                for (i = 0; i < fp.npoints; ++i) {
                    ya[i] = new Variable(fp.ypoints[i]);
                }
            } else {
                int i;
                Polygon p = roi.getPolygon();
                xa = new Variable[p.npoints];
                ya = new Variable[p.npoints];
                for (i = 0; i < p.npoints; ++i) {
                    xa[i] = new Variable(p.xpoints[i]);
                }
                for (i = 0; i < p.npoints; ++i) {
                    ya[i] = new Variable(p.ypoints[i]);
                }
            }
        }
        xCoordinates.setArray(xa);
        yCoordinates.setArray(ya);
    }

    Variable[] getProfile() {
        ProfilePlot pp;
        double[] array;
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        if (imp.getRoi() == null) {
            this.interp.error("Selection required");
        }
        if ((array = (pp = new ProfilePlot(imp, IJ.altKeyDown())).getProfile()) == null) {
            this.interp.done = true;
            return null;
        }
        return new Variable(array).getArray();
    }

    Variable[] newArray() {
        if (this.interp.nextToken() != 40 || this.interp.nextNextToken() == 41) {
            this.interp.getParens();
            return new Variable[0];
        }
        this.interp.getLeftParen();
        int next = this.interp.nextToken();
        int nextNext = this.interp.nextNextToken();
        if (next == 133 || nextNext == 44 || nextNext == 91 || next == 45 || next == 211) {
            return this.initNewArray();
        }
        int size = (int)this.interp.getExpression();
        if (size < 0) {
            this.interp.error("Negative array size");
        }
        this.interp.getRightParen();
        Variable[] array = new Variable[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new Variable();
        }
        return array;
    }

    Variable[] split() {
        String s1 = this.getFirstString();
        String s2 = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            s2 = this.getLastString();
        }
        if (s1 == null) {
            return null;
        }
        String[] strings = null;
        if (s1.length() > 0 && s2 != null && (s2.equals(",") || s2.equals(";"))) {
            strings = s1.split(s2, -1);
        } else if (s1.length() > 0 && s2 != null && s2.length() >= 3 && s2.startsWith("(") && s2.endsWith(")")) {
            s2 = s2.substring(1, s2.length() - 1);
            strings = s1.split(s2, -1);
        } else {
            strings = s2 == null || s2.equals("") ? Tools.split(s1) : Tools.split(s1, s2);
        }
        Variable[] array = new Variable[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            array[i] = new Variable(0, 0.0, strings[i]);
        }
        return array;
    }

    Variable[] getFileList() {
        String dir = this.getStringArg();
        File f = new File(dir);
        if (!f.exists() || !f.isDirectory()) {
            return new Variable[0];
        }
        String[] list = f.list();
        if (list == null) {
            return new Variable[0];
        }
        if (System.getProperty("os.name").indexOf("Linux") != -1) {
            StringSorter.sort(list);
        }
        int hidden = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith(".") || list[i].equals("Thumbs.db")) {
                list[i] = null;
                ++hidden;
                continue;
            }
            File f2 = new File(dir, list[i]);
            if (!f2.isDirectory()) continue;
            list[i] = list[i] + "/";
        }
        int n = list.length - hidden;
        if (n <= 0) {
            return new Variable[0];
        }
        if (hidden > 0) {
            String[] list2 = new String[n];
            int j = 0;
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == null) continue;
                list2[j++] = list[i];
            }
            list = list2;
        }
        Variable[] array = new Variable[n];
        for (int i = 0; i < n; ++i) {
            array[i] = new Variable(0, 0.0, list[i]);
        }
        return array;
    }

    Variable[] initNewArray() {
        Vector<Variable> vector = new Vector<Variable>();
        int size = 0;
        do {
            Variable v = new Variable();
            if (this.isStringArg()) {
                v.setString(this.getString());
            } else {
                v.setValue(this.interp.getExpression());
            }
            vector.addElement(v);
            ++size;
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("';' expected");
        }
        Object[] array = new Variable[size];
        vector.copyInto(array);
        if (array.length == 1 && ((Variable)array[0]).getString() == null) {
            size = (int)((Variable)array[0]).getValue();
            if (size < 0) {
                this.interp.error("Negative array size");
            }
            Variable[] array2 = new Variable[size];
            for (int i = 0; i < size; ++i) {
                array2[i] = new Variable();
            }
            return array2;
        }
        return array;
    }

    String fromCharCode() {
        char[] chars = new char[100];
        int count = 0;
        this.interp.getLeftParen();
        while (this.interp.nextToken() != 41) {
            int value = (int)this.interp.getExpression();
            if (value < 0 || value > 65535) {
                this.interp.error("Value (" + value + ") out of 0-65535 range");
            }
            chars[count++] = (char)value;
            if (this.interp.nextToken() != 44) continue;
            this.interp.getToken();
        }
        this.interp.getRightParen();
        return new String(chars, 0, count);
    }

    String getInfo() {
        if (this.interp.nextNextToken() == 133 || this.interp.nextToken() == 40 && this.interp.nextNextToken() != 41) {
            return this.getInfo(this.getStringArg());
        }
        this.interp.getParens();
        return this.getWindowContents();
    }

    String getInfo(String key) {
        String lowercaseKey = key.toLowerCase(Locale.US);
        int len = lowercaseKey.length();
        if (lowercaseKey.equals("command.name")) {
            return ImageJ.getCommandName();
        }
        if (lowercaseKey.equals("overlay")) {
            Overlay overlay = this.getImage().getOverlay();
            if (overlay == null) {
                return "";
            }
            return overlay.toString();
        }
        if (lowercaseKey.equals("log")) {
            String log = IJ.getLog();
            return log != null ? log : "";
        }
        if (key.indexOf(".") == -1) {
            ImagePlus imp = this.getImage();
            String value = imp.getStringProperty(key);
            if (value != null) {
                return value;
            }
        } else {
            if (lowercaseKey.equals("micrometer.abbreviation")) {
                return "\u00b5m";
            }
            if (lowercaseKey.equals("image.subtitle")) {
                ImagePlus imp = this.getImage();
                ImageWindow win = imp.getWindow();
                return win != null ? win.createSubtitle() : "";
            }
            if (lowercaseKey.equals("slice.label")) {
                ImagePlus imp = this.getImage();
                String label = null;
                label = imp.getStackSize() == 1 ? (String)imp.getProperty("Label") : imp.getStack().getShortSliceLabel(imp.getCurrentSlice());
                return label != null ? label : "";
            }
            if (lowercaseKey.equals("window.contents")) {
                return this.getWindowContents();
            }
            if (lowercaseKey.equals("image.description")) {
                String description = "";
                FileInfo fi = this.getImage().getOriginalFileInfo();
                if (fi != null) {
                    description = fi.description;
                }
                if (description == null) {
                    description = "";
                }
                return description;
            }
            if (lowercaseKey.equals("image.filename")) {
                String name = "";
                FileInfo fi = this.getImage().getOriginalFileInfo();
                if (fi != null && fi.fileName != null) {
                    name = fi.fileName;
                }
                return name;
            }
            if (lowercaseKey.equals("image.directory")) {
                String dir = "";
                FileInfo fi = this.getImage().getOriginalFileInfo();
                if (fi != null && fi.directory != null) {
                    dir = fi.directory;
                }
                return dir;
            }
            if (lowercaseKey.equals("selection.name") || lowercaseKey.equals("roi.name")) {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                String name = roi != null ? roi.getName() : null;
                return name != null ? name : "";
            }
            if (lowercaseKey.equals("selection.color") || lowercaseKey.equals("roi.color")) {
                ImagePlus imp = this.getImage();
                Roi roi = imp.getRoi();
                if (roi == null) {
                    this.interp.error("No selection");
                }
                Color color = roi.getStrokeColor();
                return Colors.colorToString(color);
            }
            if (lowercaseKey.equals("font.name")) {
                this.resetImage();
                ImageProcessor ip = this.getProcessor();
                this.setFont(ip);
                return ip.getFont().getName();
            }
            if (lowercaseKey.equals("threshold.method")) {
                return ThresholdAdjuster.getMethod();
            }
            if (lowercaseKey.equals("threshold.mode")) {
                return ThresholdAdjuster.getMode();
            }
            if (lowercaseKey.equals("window.type")) {
                return this.getWindowType();
            }
            if (lowercaseKey.equals("window.title") || lowercaseKey.equals("window.name")) {
                return this.getWindowTitle();
            }
            String value = "";
            try {
                value = System.getProperty(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            return value != null ? value : "";
        }
        return "";
    }

    private String getWindowTitle() {
        Window win = WindowManager.getActiveWindow();
        if (IJ.debugMode) {
            IJ.log("getWindowTitle: " + win);
        }
        if (win == null) {
            return "";
        }
        if (win instanceof Frame) {
            return ((Frame)win).getTitle();
        }
        if (win instanceof Dialog) {
            return ((Dialog)win).getTitle();
        }
        return "";
    }

    private String getWindowType() {
        Window win = WindowManager.getActiveWindow();
        if (win == null) {
            return "";
        }
        String type = win.getClass().getName();
        if (win instanceof TextWindow) {
            TextPanel tp = ((TextWindow)win).getTextPanel();
            type = tp.getColumnHeadings().isEmpty() ? "Text" : (tp.getResultsTable() != null ? "ResultsTable" : "Table");
        } else if (type.equals("ij.gui.PlotWindow")) {
            type = "Plot";
        } else if (type.equals("ij.gui.HistogramWindow")) {
            type = "Histogram";
        } else if (win instanceof ImageWindow) {
            type = "Image";
        } else if (type.contains(".")) {
            type = type.substring(type.lastIndexOf(46) + 1);
        }
        return type;
    }

    String getWindowContents() {
        Frame frame = WindowManager.getFrontWindow();
        if (frame != null && frame instanceof TextWindow) {
            TextPanel tp = ((TextWindow)frame).getTextPanel();
            return tp.getText();
        }
        if (frame != null && frame instanceof Editor) {
            return ((Editor)frame).getText();
        }
        if (frame != null && frame instanceof Recorder) {
            return ((Recorder)frame).getText();
        }
        return this.getImageInfo();
    }

    String getImageInfo() {
        ImagePlus imp = this.getImage();
        Info infoPlugin = new Info();
        return infoPlugin.getImageInfo(imp, this.getProcessor());
    }

    public String getDirectory() {
        String dir = IJ.getDirectory(this.getStringArg());
        if (dir == null) {
            dir = "";
        }
        return dir;
    }

    double getSelectionType() {
        this.interp.getParens();
        double type = -1.0;
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            type = roi.getType();
        }
        return type;
    }

    void showMessage(boolean withCancel) {
        String message;
        this.interp.getLeftParen();
        String title = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            message = this.getString();
        } else {
            message = title;
            title = "";
        }
        this.interp.getRightParen();
        if (withCancel) {
            IJ.showMessageWithCancel(title, message);
        } else {
            IJ.showMessage(title, message);
        }
    }

    double lengthOf() {
        int length = 0;
        this.interp.getLeftParen();
        switch (this.interp.nextToken()) {
            case 133: 
            case 136: 
            case 138: {
                length = this.getString().length();
                break;
            }
            case 129: {
                if (this.pgm.code[this.interp.pc + 2] == 91) {
                    length = this.getString().length();
                    break;
                }
                this.interp.getToken();
                Variable v = this.interp.lookupVariable();
                if (v == null) {
                    return 0.0;
                }
                String s = v.getString();
                if (s != null) {
                    length = s.length();
                    break;
                }
                Variable[] array = v.getArray();
                if (array != null) {
                    length = v.getArraySize();
                    break;
                }
                this.interp.error("String or array expected");
                break;
            }
            default: {
                this.interp.error("String or array expected");
            }
        }
        this.interp.getRightParen();
        return length;
    }

    void getCursorLoc() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable z = this.getNextVariable();
        Variable flags = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Point p = ic.getCursorLoc();
        x.setValue(p.x);
        y.setValue(p.y);
        z.setValue(imp.getCurrentSlice() - 1);
        Roi roi = imp.getRoi();
        flags.setValue(ic.getModifiers() + (roi != null && roi.contains(p.x, p.y) ? 32 : 0));
    }

    void getLine() {
        Variable vx1 = this.getFirstVariable();
        Variable vy1 = this.getNextVariable();
        Variable vx2 = this.getNextVariable();
        Variable vy2 = this.getNextVariable();
        Variable lineWidth = this.getLastVariable();
        ImagePlus imp = this.getImage();
        double x1 = -1.0;
        double y1 = -1.0;
        double x2 = -1.0;
        double y2 = -1.0;
        Roi roi = imp.getRoi();
        if (roi != null && roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1d;
            y1 = line.y1d;
            x2 = line.x2d;
            y2 = line.y2d;
        }
        vx1.setValue(x1);
        vy1.setValue(y1);
        vx2.setValue(x2);
        vy2.setValue(y2);
        lineWidth.setValue(roi != null ? (double)roi.getStrokeWidth() : 1.0);
    }

    void getVoxelSize() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable depth = this.getNextVariable();
        Variable unit = this.getLastVariable();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        depth.setValue(cal.pixelDepth);
        unit.setString(cal.getUnits());
    }

    void getHistogram() {
        Variable[] array;
        ImageStatistics stats;
        this.interp.getLeftParen();
        Variable values = null;
        if (this.interp.nextToken() == 130) {
            this.interp.getExpression();
        } else {
            values = this.getArrayVariable();
        }
        Variable counts = this.getNextArrayVariable();
        this.interp.getComma();
        int nBins = (int)this.interp.getExpression();
        ImagePlus imp = this.getImage();
        double histMin = 0.0;
        double histMax = 0.0;
        boolean setMinMax = false;
        int bitDepth = imp.getBitDepth();
        if (this.interp.nextToken() == 44) {
            histMin = this.getNextArg();
            histMax = this.getLastArg();
            if (bitDepth == 8 || bitDepth == 24) {
                this.interp.error("16 or 32-bit image required to set histMin and histMax");
            }
            setMinMax = true;
        } else {
            this.interp.getRightParen();
        }
        if (nBins == 65536 && bitDepth == 16) {
            Variable[] array2 = counts.getArray();
            ImageProcessor ip = imp.getProcessor();
            Roi roi = imp.getRoi();
            if (roi != null) {
                ip.setRoi(roi);
            }
            int[] hist = ip.getHistogram();
            if (array2 != null && array2.length == nBins) {
                for (int i = 0; i < nBins; ++i) {
                    array2[i].setValue(hist[i]);
                }
            } else {
                counts.setArray(new Variable(hist).getArray());
            }
            return;
        }
        boolean custom8Bit = false;
        if ((bitDepth == 8 || bitDepth == 24) && nBins != 256) {
            ImageProcessor ip = imp.getProcessor().convertToShort(false);
            imp = imp.createImagePlus();
            imp.setProcessor(ip);
            stats = imp.getStatistics(27, nBins, 0.0, 256.0);
            custom8Bit = true;
        } else {
            stats = setMinMax ? imp.getStatistics(27, nBins, histMin, histMax) : imp.getStatistics(27, nBins);
        }
        if (values != null) {
            Calibration cal = imp.getCalibration();
            double[] array3 = new double[nBins];
            double value = cal.getCValue(stats.histMin);
            double inc = 1.0;
            if (bitDepth == 16 || bitDepth == 32 || cal.calibrated() || custom8Bit) {
                inc = (cal.getCValue(stats.histMax) - cal.getCValue(stats.histMin)) / (double)stats.nBins;
            }
            for (int i = 0; i < nBins; ++i) {
                array3[i] = value;
                value += inc;
            }
            values.setArray(new Variable(array3).getArray());
        }
        if ((array = counts.getArray()) != null && array.length == nBins) {
            for (int i = 0; i < nBins; ++i) {
                array[i].setValue(stats.histogram[i]);
            }
        } else {
            counts.setArray(new Variable(stats.histogram).getArray());
        }
    }

    void getLut() {
        Variable reds = this.getFirstArrayVariable();
        Variable greens = this.getNextArrayVariable();
        Variable blues = this.getLastArrayVariable();
        ImagePlus imp = this.getImage();
        IndexColorModel cm = null;
        if (imp.isComposite()) {
            cm = ((CompositeImage)imp).getChannelLut();
        } else {
            ImageProcessor ip = imp.getProcessor();
            if (ip instanceof ColorProcessor) {
                this.interp.error("Non-RGB image expected");
            }
            cm = (IndexColorModel)ip.getColorModel();
        }
        int mapSize = cm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        cm.getReds(rLUT);
        cm.getGreens(gLUT);
        cm.getBlues(bLUT);
        reds.setArray(new Variable(rLUT).getArray());
        greens.setArray(new Variable(gLUT).getArray());
        blues.setArray(new Variable(bLUT).getArray());
    }

    void setLut() {
        ImagePlus imp;
        double[] reds = this.getFirstArray();
        double[] greens = this.getNextArray();
        double[] blues = this.getLastArray();
        int length = reds.length;
        if (greens.length != length || blues.length != length) {
            this.interp.error("Arrays are not the same length");
        }
        if ((imp = this.getImage()).getBitDepth() == 24) {
            this.interp.error("Non-RGB image expected");
        }
        ImageProcessor ip = this.getProcessor();
        byte[] r = new byte[length];
        byte[] g = new byte[length];
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            r[i] = (byte)reds[i];
            g[i] = (byte)greens[i];
            b[i] = (byte)blues[i];
        }
        LUT lut = new LUT(8, length, r, g, b);
        if (imp.isComposite()) {
            ((CompositeImage)imp).setChannelLut(lut);
        } else {
            ip.setColorModel(lut);
        }
        imp.updateAndDraw();
        this.updateNeeded = false;
    }

    void getThreshold() {
        Variable lower = this.getFirstVariable();
        Variable upper = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageProcessor ip = this.getProcessor();
        double t1 = ip.getMinThreshold();
        double t2 = ip.getMaxThreshold();
        if (t1 == -808080.0) {
            t1 = -1.0;
            t2 = -1.0;
        } else {
            Calibration cal = imp.getCalibration();
            t1 = cal.getCValue(t1);
            t2 = cal.getCValue(t2);
        }
        lower.setValue(t1);
        upper.setValue(t2);
    }

    void getPixelSize() {
        Variable unit = this.getFirstVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getNextVariable();
        Variable depth = null;
        if (this.interp.nextToken() == 44) {
            depth = this.getNextVariable();
        }
        this.interp.getRightParen();
        Calibration cal = this.getImage().getCalibration();
        unit.setString(cal.getUnits());
        width.setValue(cal.pixelWidth);
        height.setValue(cal.pixelHeight);
        if (depth != null) {
            depth.setValue(cal.pixelDepth);
        }
    }

    void makeSelection() {
        int i;
        String type = null;
        int roiType = -1;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            type = this.getString().toLowerCase();
            roiType = 2;
            if (type.indexOf("free") != -1) {
                roiType = 3;
            }
            if (type.indexOf("traced") != -1) {
                roiType = 4;
            }
            if (type.indexOf("line") != -1) {
                roiType = type.indexOf("free") != -1 ? 7 : 6;
            }
            if (type.indexOf("angle") != -1) {
                roiType = 8;
            }
            if (type.indexOf("point") != -1) {
                roiType = 10;
            }
        } else {
            roiType = (int)this.interp.getExpression();
            if (roiType < 0 || roiType == 9) {
                this.interp.error("Invalid selection type (" + roiType + ")");
            }
            if (roiType == 0) {
                roiType = 2;
            }
            if (roiType == 1) {
                roiType = 3;
            }
        }
        double[] x = this.getNextArray();
        int n = x.length;
        this.interp.getComma();
        double[] y = this.getNumericArray();
        if (this.interp.nextToken() == 44) {
            n = (int)this.getLastArg();
            if (n > x.length || n > y.length) {
                this.interp.error("Array too short");
            }
        } else {
            this.interp.getRightParen();
            if (y.length != n) {
                this.interp.error("Arrays are not the same length");
            }
        }
        ImagePlus imp = this.getImage();
        boolean floatCoordinates = false;
        for (int i2 = 0; i2 < n; ++i2) {
            if (x[i2] == (double)((int)x[i2]) && y[i2] == (double)((int)y[i2])) continue;
            floatCoordinates = true;
            break;
        }
        int[] xcoord = null;
        int[] ycoord = null;
        float[] xfcoord = null;
        float[] yfcoord = null;
        if (floatCoordinates) {
            xfcoord = new float[n];
            yfcoord = new float[n];
            for (i = 0; i < n; ++i) {
                xfcoord[i] = (float)x[i];
                yfcoord[i] = (float)y[i];
            }
        } else {
            xcoord = new int[n];
            ycoord = new int[n];
            for (i = 0; i < n; ++i) {
                xcoord[i] = (int)Math.round(x[i]);
                ycoord[i] = (int)Math.round(y[i]);
            }
        }
        Roi roi = null;
        if (roiType == 5) {
            if (xcoord.length != 2) {
                this.interp.error("2 element arrays expected");
            }
            roi = floatCoordinates ? new Line(xfcoord[0], yfcoord[0], xfcoord[1], yfcoord[1]) : new Line(xcoord[0], ycoord[0], xcoord[1], ycoord[1]);
        } else {
            roi = roiType == 10 ? (floatCoordinates ? new PointRoi(xfcoord, yfcoord, n) : new PointRoi(xcoord, ycoord, n)) : (floatCoordinates ? new PolygonRoi(xfcoord, yfcoord, n, roiType) : new PolygonRoi(xcoord, ycoord, n, roiType));
        }
        Roi previousRoi = imp.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imp.saveRoi();
        }
        imp.setRoi(roi);
        if (roiType == 2 || roiType == 3) {
            roi = imp.getRoi();
            if (previousRoi != null && roi != null) {
                this.updateRoi(roi);
            }
        }
        this.updateNeeded = false;
    }

    void doPlot() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("create")) {
            this.newPlot();
            return;
        }
        if (name.equals("getValues")) {
            this.getPlotValues();
            return;
        }
        if (this.plot == null) {
            this.interp.error("No plot defined");
        }
        if (name.equals("show")) {
            this.showPlot();
            return;
        }
        if (name.equals("update")) {
            this.updatePlot();
            return;
        }
        if (name.equals("setFrameSize")) {
            this.plot.setFrameSize((int)this.getFirstArg(), (int)this.getLastArg());
            return;
        }
        if (name.equals("setLimits")) {
            this.plot.setLimits(this.getFirstArg(), this.getNextArg(), this.getNextArg(), this.getLastArg());
            return;
        }
        if (name.equals("setLogScaleX")) {
            this.interp.getParens();
            this.plot.setLogScaleX();
            return;
        }
        if (name.equals("setLogScaleY")) {
            this.interp.getParens();
            this.plot.setLogScaleY();
            return;
        }
        if (name.equals("addText") || name.equals("drawLabel")) {
            this.addPlotText();
            return;
        }
        if (name.equals("drawLine")) {
            this.drawPlotLine(false);
            return;
        }
        if (name.equals("drawNormalizedLine")) {
            this.drawPlotLine(true);
            return;
        }
        if (name.equals("drawVectors")) {
            this.drawVectors();
            return;
        }
        if (name.equals("setColor")) {
            this.setPlotColor();
            return;
        }
        if (name.equals("add")) {
            String arg = this.getFirstString();
            arg = arg.toLowerCase(Locale.US);
            int what = 0;
            if (arg.indexOf("curve") != -1 || arg.indexOf("line") != -1) {
                what = 2;
            } else if (arg.indexOf("box") != -1) {
                what = 3;
            } else if (arg.indexOf("triangle") != -1) {
                what = 4;
            } else if (arg.indexOf("cross") != -1) {
                what = 5;
            } else if (arg.indexOf("dot") != -1) {
                what = 6;
            } else if (arg.indexOf("xerror") != -1) {
                what = -2;
            } else if (arg.indexOf("error") != -1) {
                what = -1;
            } else if (arg.indexOf("x") != -1) {
                what = 1;
            }
            this.addToPlot(what);
            return;
        }
        if (name.startsWith("setLineWidth")) {
            this.plot.setLineWidth((int)this.getArg());
            return;
        }
        if (name.startsWith("setJustification")) {
            this.doFunction(357);
            return;
        }
        this.interp.error("Unrecognized plot function");
    }

    void getPlotValues() {
        int i;
        Variable xvar = this.getFirstArrayVariable();
        Variable yvar = this.getLastArrayVariable();
        float[] xvalues = new float[]{};
        float[] yvalues = new float[]{};
        ImagePlus imp = this.getImage();
        ImageWindow win = imp.getWindow();
        if (imp.getProperty("XValues") != null) {
            xvalues = (float[])imp.getProperty("XValues");
            yvalues = (float[])imp.getProperty("YValues");
        } else if (win != null && win instanceof PlotWindow) {
            PlotWindow pw = (PlotWindow)win;
            xvalues = pw.getXValues();
            yvalues = pw.getYValues();
        } else if (win != null && win instanceof HistogramWindow) {
            HistogramWindow hw = (HistogramWindow)win;
            double[] x = hw.getXValues();
            xvalues = new float[x.length];
            for (int i2 = 0; i2 < x.length; ++i2) {
                xvalues[i2] = (float)x[i2];
            }
            int[] y = hw.getHistogram();
            yvalues = new float[y.length];
            for (int i3 = 0; i3 < y.length; ++i3) {
                yvalues[i3] = y[i3];
            }
        } else {
            this.interp.error("No plot or histogram window");
        }
        Variable[] xa = new Variable[xvalues.length];
        Variable[] ya = new Variable[yvalues.length];
        for (i = 0; i < xvalues.length; ++i) {
            xa[i] = new Variable(xvalues[i]);
        }
        for (i = 0; i < yvalues.length; ++i) {
            ya[i] = new Variable(yvalues[i]);
        }
        xvar.setArray(xa);
        yvar.setArray(ya);
    }

    void newPlot() {
        double[] x;
        double[] y;
        String title = this.getFirstString();
        String xLabel = this.getNextString();
        String yLabel = this.getNextString();
        if (this.interp.nextToken() == 41) {
            y = null;
            x = null;
        } else {
            x = this.getNextArray();
            if (this.interp.nextToken() == 41) {
                y = x;
                x = new double[y.length];
                for (int i = 0; i < y.length; ++i) {
                    x[i] = i;
                }
            } else {
                y = this.getNextArray();
            }
        }
        this.interp.getRightParen();
        this.plot = new Plot(title, xLabel, yLabel, x, y);
    }

    void showPlot() {
        PlotWindow plotWindow;
        if (this.plot != null && (plotWindow = this.plot.show()) != null) {
            plotID = plotWindow.getImagePlus().getID();
        }
        this.plot = null;
        this.interp.getParens();
    }

    void updatePlot() {
        if (this.plot != null) {
            ImageWindow win;
            ImagePlus plotImage = WindowManager.getImage(plotID);
            ImageWindow imageWindow = win = plotImage != null ? plotImage.getWindow() : null;
            if (win != null) {
                ((PlotWindow)win).drawPlot(this.plot);
            } else {
                PlotWindow plotWindow = this.plot.show();
                if (plotWindow != null) {
                    plotID = plotWindow.getImagePlus().getID();
                }
            }
        }
        this.plot = null;
        this.interp.getParens();
    }

    void addPlotText() {
        String str = this.getFirstString();
        double x = this.getNextArg();
        double y = this.getLastArg();
        this.plot.setJustification(this.justification);
        this.plot.addLabel(x, y, str);
    }

    void drawPlotLine(boolean normalized) {
        double x1 = this.getFirstArg();
        double y1 = this.getNextArg();
        double x2 = this.getNextArg();
        double y2 = this.getLastArg();
        if (normalized) {
            this.plot.drawNormalizedLine(x1, y1, x2, y2);
        } else {
            this.plot.drawLine(x1, y1, x2, y2);
        }
    }

    void drawVectors() {
        double[] x1 = this.getFirstArray();
        double[] y1 = this.getNextArray();
        double[] x2 = this.getNextArray();
        double[] y2 = this.getLastArray();
        this.plot.drawVectors(x1, y1, x2, y2);
    }

    void setPlotColor() {
        this.interp.getLeftParen();
        this.plot.setColor(this.getColor());
        this.interp.getRightParen();
    }

    void addToPlot(int what) {
        double[] y;
        boolean errorBars = false;
        double[] x = this.getNextArray();
        double[] e = new double[x.length];
        if (this.interp.nextToken() == 41) {
            y = x;
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        } else {
            this.interp.getComma();
            y = this.getNumericArray();
            if (this.interp.nextToken() != 41) {
                errorBars = true;
                this.interp.getComma();
                e = this.getNumericArray();
            }
        }
        this.interp.getRightParen();
        if (what == -1) {
            this.plot.addErrorBars(y);
        } else if (what == -2) {
            this.plot.addHorizontalErrorBars(y);
        } else if (errorBars) {
            this.plot.addPoints(x, y, e, what);
        } else {
            this.plot.addPoints(x, y, what);
        }
    }

    void getBounds() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable width = this.getNextVariable();
        Variable height = this.getLastVariable();
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi != null) {
            Rectangle2D.Double r = roi.getFloatBounds();
            x.setValue(r.x);
            y.setValue(r.y);
            width.setValue(r.width);
            height.setValue(r.height);
        } else {
            x.setValue(0.0);
            y.setValue(0.0);
            width.setValue(imp.getWidth());
            height.setValue(imp.getHeight());
        }
    }

    String substring() {
        String s = this.getFirstString();
        int index1 = (int)this.getNextArg();
        int index2 = s.length();
        if (this.interp.nextToken() == 44) {
            index2 = (int)this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        if (index1 > index2) {
            this.interp.error("beginIndex>endIndex");
        }
        this.checkIndex(index1, 0, s.length());
        this.checkIndex(index2, 0, s.length());
        return s.substring(index1, index2);
    }

    int indexOf() {
        String s1 = this.getFirstString();
        String s2 = this.getNextString();
        int fromIndex = 0;
        if (this.interp.nextToken() == 44) {
            fromIndex = (int)this.getLastArg();
            this.checkIndex(fromIndex, 0, s1.length() - 1);
        } else {
            this.interp.getRightParen();
        }
        if (fromIndex == 0) {
            return s1.indexOf(s2);
        }
        return s1.indexOf(s2, fromIndex);
    }

    int startsWithEndsWith(int type) {
        String s1 = this.getFirstString();
        String s2 = this.getLastString();
        if (type == 1034) {
            return s1.startsWith(s2) ? 1 : 0;
        }
        return s1.endsWith(s2) ? 1 : 0;
    }

    double isActive() {
        int id = (int)this.getArg();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getID() != id) {
            return 0.0;
        }
        return 1.0;
    }

    double isOpen() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            String title = this.getString();
            this.interp.getRightParen();
            return this.isOpen(title) ? 1.0 : 0.0;
        }
        int id = (int)this.interp.getExpression();
        this.interp.getRightParen();
        return WindowManager.getImage(id) == null ? 0.0 : 1.0;
    }

    boolean isOpen(String title) {
        boolean open;
        boolean bl = open = WindowManager.getWindow(title) != null;
        if (open) {
            return true;
        }
        if (Interpreter.isBatchMode() && Interpreter.imageTable != null) {
            Enumeration en = Interpreter.imageTable.elements();
            while (en.hasMoreElements()) {
                ImagePlus imp = (ImagePlus)en.nextElement();
                if (imp == null || !imp.getTitle().equals(title)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isStringArg() {
        int nextToken = this.pgm.code[this.interp.pc + 1];
        int tok = nextToken & 0xFF;
        if (tok == 133 || tok == 136) {
            return true;
        }
        if (tok != 129) {
            return false;
        }
        Variable v = this.interp.lookupVariable(nextToken >> 12);
        if (v == null) {
            return false;
        }
        int type = v.getType();
        if (type != 1) {
            return v.getType() == 2;
        }
        Variable[] array = v.getArray();
        if (array.length == 0) {
            return false;
        }
        return array[0].getType() == 2;
    }

    void exit() {
        String msg = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                msg = this.getString();
            }
            this.interp.getRightParen();
        }
        this.interp.finishUp();
        if (msg != null) {
            IJ.showMessage("Macro", msg);
        }
        throw new RuntimeException("Macro canceled");
    }

    void showProgress() {
        ImageJ ij = IJ.getInstance();
        ProgressBar progressBar = ij != null ? ij.getProgressBar() : null;
        this.interp.getLeftParen();
        double arg1 = this.interp.getExpression();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg2 = this.interp.getExpression();
            if (progressBar != null) {
                progressBar.show((arg1 + 1.0) / arg2, true);
            }
        } else if (progressBar != null) {
            progressBar.show(arg1, true);
        }
        this.interp.getRightParen();
        this.interp.showingProgress = true;
    }

    void saveSettings() {
        this.interp.getParens();
        this.usePointerCursor = Prefs.usePointerCursor;
        this.hideProcessStackDialog = IJ.hideProcessStackDialog;
        this.divideByZeroValue = FloatBlitter.divideByZeroValue;
        this.jpegQuality = FileSaver.getJpegQuality();
        this.saveLineWidth = Line.getWidth();
        this.doScaling = ImageConverter.getDoScaling();
        this.weightedColor = Prefs.weightedColor;
        this.weights = ColorProcessor.getWeightingFactors();
        this.interpolateScaledImages = Prefs.interpolateScaledImages;
        this.open100Percent = Prefs.open100Percent;
        this.blackCanvas = Prefs.blackCanvas;
        this.useJFileChooser = Prefs.useJFileChooser;
        this.debugMode = IJ.debugMode;
        this.foregroundColor = Toolbar.getForegroundColor();
        this.backgroundColor = Toolbar.getBackgroundColor();
        this.roiColor = Roi.getColor();
        this.pointAutoMeasure = Prefs.pointAutoMeasure;
        this.requireControlKey = Prefs.requireControlKey;
        this.useInvertingLut = Prefs.useInvertingLut;
        this.saveSettingsCalled = true;
        this.measurements = Analyzer.getMeasurements();
        this.decimalPlaces = Analyzer.getPrecision();
        this.blackBackground = Prefs.blackBackground;
        this.autoContrast = Prefs.autoContrast;
        this.pasteMode = Roi.getCurrentPasteMode();
        this.plotWidth = PlotWindow.plotWidth;
        this.plotHeight = PlotWindow.plotHeight;
        this.plotInterpolate = PlotWindow.interpolate;
        this.plotNoGridLines = PlotWindow.noGridLines;
    }

    void restoreSettings() {
        this.interp.getParens();
        if (!this.saveSettingsCalled) {
            this.interp.error("saveSettings() not called");
        }
        Prefs.usePointerCursor = this.usePointerCursor;
        IJ.hideProcessStackDialog = this.hideProcessStackDialog;
        FloatBlitter.divideByZeroValue = this.divideByZeroValue;
        FileSaver.setJpegQuality(this.jpegQuality);
        Line.setWidth(this.saveLineWidth);
        ImageConverter.setDoScaling(this.doScaling);
        if (this.weightedColor != Prefs.weightedColor) {
            ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
            Prefs.weightedColor = this.weights[0] != 0.3333333333333333 || this.weights[1] != 0.3333333333333333 || this.weights[2] != 0.3333333333333333;
        }
        Prefs.interpolateScaledImages = this.interpolateScaledImages;
        Prefs.open100Percent = this.open100Percent;
        Prefs.blackCanvas = this.blackCanvas;
        Prefs.useJFileChooser = this.useJFileChooser;
        Prefs.useInvertingLut = this.useInvertingLut;
        IJ.setDebugMode(this.debugMode);
        Toolbar.setForegroundColor(this.foregroundColor);
        Toolbar.setBackgroundColor(this.backgroundColor);
        Roi.setColor(this.roiColor);
        Analyzer.setMeasurements(this.measurements);
        Analyzer.setPrecision(this.decimalPlaces);
        ColorProcessor.setWeightingFactors(this.weights[0], this.weights[1], this.weights[2]);
        Prefs.blackBackground = this.blackBackground;
        Prefs.autoContrast = this.autoContrast;
        Roi.setPasteMode(this.pasteMode);
        PlotWindow.plotWidth = this.plotWidth;
        PlotWindow.plotHeight = this.plotHeight;
        PlotWindow.interpolate = this.plotInterpolate;
        PlotWindow.noGridLines = this.plotNoGridLines;
    }

    void setKeyDown() {
        String keys = this.getStringArg();
        boolean bl = this.altKeyDown = (keys = keys.toLowerCase(Locale.US)).indexOf("alt") != -1;
        if (this.altKeyDown) {
            IJ.setKeyDown(18);
        } else {
            IJ.setKeyUp(18);
        }
        boolean bl2 = this.shiftKeyDown = keys.indexOf("shift") != -1;
        if (this.shiftKeyDown) {
            IJ.setKeyDown(16);
        } else {
            IJ.setKeyUp(16);
        }
        if (keys.equals("space")) {
            IJ.setKeyDown(32);
        } else {
            IJ.setKeyUp(32);
        }
        if (keys.indexOf("esc") != -1) {
            this.abortPluginOrMacro();
        } else {
            this.interp.keysSet = true;
        }
    }

    void abortPluginOrMacro() {
        ImageWindow win;
        Interpreter.abortPrevious();
        IJ.setKeyDown(27);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (win = imp.getWindow()) != null) {
            win.running = false;
            win.running2 = false;
        }
    }

    void open() {
        this.interp.getLeftParen();
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
            IJ.open();
        } else {
            double n = Double.NaN;
            String path = this.getString();
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                n = this.interp.getExpression();
            }
            this.interp.getRightParen();
            if (!Double.isNaN(n)) {
                try {
                    IJ.open(path, (int)n);
                }
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg != null && msg.indexOf("canceled") == -1) {
                        this.interp.error("" + msg);
                    }
                }
            } else {
                IJ.open(path);
            }
            if (path != null && !path.equals("")) {
                File f = new File(path);
                OpenDialog.setLastDirectory(f.getParent() + File.separator);
                OpenDialog.setLastName(f.getName());
            }
        }
        this.resetImage();
    }

    double roiManager() {
        RoiManager rm;
        String cmd = this.getFirstString();
        cmd = cmd.toLowerCase();
        String path = null;
        String color = null;
        double lineWidth = 1.0;
        int index = 0;
        double dx = 0.0;
        double dy = 0.0;
        double countOrIndex = Double.NaN;
        boolean twoArgCommand = cmd.equals("open") || cmd.equals("save") || cmd.equals("rename") || cmd.equals("set color") || cmd.equals("set fill color") || cmd.equals("set line width") || cmd.equals("associate") || cmd.equals("centered") || cmd.equals("usenames") || cmd.equals("save selected");
        boolean select = cmd.equals("select");
        boolean multiSelect = false;
        boolean add = cmd.equals("add");
        if (twoArgCommand) {
            path = this.getLastString();
        } else if (add) {
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                color = this.interp.getString();
            }
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                lineWidth = this.interp.getExpression();
            }
            this.interp.getRightParen();
        } else if (select) {
            this.interp.getComma();
            multiSelect = this.isArrayArg();
            if (!multiSelect) {
                index = (int)this.interp.getExpression();
                this.interp.getRightParen();
            }
        } else if (cmd.equals("translate")) {
            dx = this.getNextArg();
            dy = this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        if (RoiManager.getInstance() == null && this.roiManager == null) {
            if (Interpreter.isBatchMode()) {
                this.roiManager = new RoiManager(true);
            } else {
                IJ.run("ROI Manager...");
            }
        }
        RoiManager roiManager = rm = this.roiManager != null ? this.roiManager : RoiManager.getInstance();
        if (rm == null) {
            this.interp.error("ROI Manager not found");
        }
        if (multiSelect) {
            return this.setMultipleIndexes(rm);
        }
        if (twoArgCommand) {
            rm.runCommand(cmd, path);
        } else if (add) {
            rm.runCommand("Add", color, lineWidth);
        } else if (select) {
            int n = rm.getCount();
            this.checkIndex(index, 0, n - 1);
            if (this.shiftKeyDown || this.altKeyDown) {
                rm.select(index, this.shiftKeyDown, this.altKeyDown);
                this.altKeyDown = false;
                this.shiftKeyDown = false;
            } else {
                rm.select(index);
            }
        } else if (cmd.equals("count")) {
            countOrIndex = rm.getCount();
        } else if (cmd.equals("index")) {
            countOrIndex = rm.getSelectedIndex();
        } else {
            if (cmd.equals("translate")) {
                rm.translate(dx, dy);
                return Double.NaN;
            }
            if (!rm.runCommand(cmd)) {
                this.interp.error("Invalid ROI Manager command");
            }
        }
        return countOrIndex;
    }

    boolean isArrayArg() {
        int nextToken = this.pgm.code[this.interp.pc + 1];
        int tok = nextToken & 0xFF;
        if (tok == 137) {
            return true;
        }
        if (tok != 129) {
            return false;
        }
        Variable v = this.interp.lookupVariable(nextToken >> 12);
        if (v == null) {
            return false;
        }
        int nextNextToken = this.pgm.code[this.interp.pc + 2];
        return v.getType() == 1 && nextNextToken != 91;
    }

    double setMultipleIndexes(RoiManager rm) {
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
        }
        double[] indexes = this.getNumericArray();
        this.interp.getRightParen();
        int[] selectedIndexes = new int[indexes.length];
        int count = rm.getCount();
        for (int i = 0; i < indexes.length; ++i) {
            selectedIndexes[i] = (int)indexes[i];
            if (selectedIndexes[i] >= 0 && selectedIndexes[i] < count) continue;
            this.interp.error("Invalid index: " + selectedIndexes[i]);
        }
        rm.setSelectedIndexes(selectedIndexes);
        return Double.NaN;
    }

    void setFont() {
        String name = this.getFirstString();
        int size = 0;
        int style = 0;
        if (name.equals("user")) {
            name = TextRoi.getFont();
            size = TextRoi.getSize();
            style = TextRoi.getStyle();
            this.antialiasedText = TextRoi.isAntialiased();
            this.interp.getRightParen();
        } else {
            size = (int)this.getNextArg();
            this.antialiasedText = false;
            if (this.interp.nextToken() == 44) {
                String styles = this.getLastString().toLowerCase();
                if (styles.indexOf("bold") != -1) {
                    ++style;
                }
                if (styles.indexOf("italic") != -1) {
                    style += 2;
                }
                if (styles.indexOf("anti") != -1) {
                    this.antialiasedText = true;
                }
            } else {
                this.interp.getRightParen();
            }
        }
        this.font = new Font(name, style, size);
        this.fontSet = false;
    }

    void getMinAndMax() {
        Variable min = this.getFirstVariable();
        Variable max = this.getLastVariable();
        ImagePlus imp = this.getImage();
        double v1 = imp.getDisplayRangeMin();
        double v2 = imp.getDisplayRangeMax();
        Calibration cal = imp.getCalibration();
        v1 = cal.getCValue(v1);
        v2 = cal.getCValue(v2);
        min.setValue(v1);
        max.setValue(v2);
    }

    void selectImage() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            String title = this.getString();
            if (!this.isOpen(title)) {
                this.interp.error("\"" + title + "\" not found");
            }
            this.selectImage(title);
            this.interp.getRightParen();
        } else {
            int id = (int)this.interp.getExpression();
            if (WindowManager.getImage(id) == null) {
                this.interp.error("Image " + id + " not found");
            }
            IJ.selectWindow(id);
            this.interp.getRightParen();
        }
        this.resetImage();
    }

    void selectImage(String title) {
        if (Interpreter.isBatchMode()) {
            if (Interpreter.imageTable != null) {
                Enumeration en = Interpreter.imageTable.elements();
                while (en.hasMoreElements()) {
                    ImagePlus imp = (ImagePlus)en.nextElement();
                    if (imp == null || !imp.getTitle().equals(title)) continue;
                    ImagePlus imp2 = WindowManager.getCurrentImage();
                    if (imp2 != null && imp2 != imp) {
                        imp2.saveRoi();
                    }
                    WindowManager.setTempCurrentImage(imp);
                    return;
                }
            }
            this.selectWindowManagerImage(title);
        } else {
            this.selectWindowManagerImage(title);
        }
    }

    void notFound(String title) {
        this.interp.error(title + " not found");
    }

    void selectWindowManagerImage(String title) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 4000L) {
            int[] wList = WindowManager.getIDList();
            int len = wList != null ? wList.length : 0;
            for (int i = 0; i < len; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                if (imp == null || !imp.getTitle().equals(title)) continue;
                IJ.selectWindow(imp.getID());
                return;
            }
            IJ.wait(10);
        }
        this.notFound(title);
    }

    void close() {
        String pattern = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.interp.nextToken() != 41) {
                pattern = this.getString();
            }
            this.interp.getRightParen();
        }
        if (pattern != null) {
            WildcardMatch wm = new WildcardMatch();
            wm.setCaseSensitive(false);
            ImagePlus currentImp = WindowManager.getCurrentImage();
            int[] ids = WindowManager.getIDList();
            if (ids == null) {
                this.resetImage();
                return;
            }
            boolean currentImpClosed = false;
            for (int img = ids.length - 1; img >= 0; --img) {
                boolean flagOthers;
                int id = ids[img];
                ImagePlus imp = WindowManager.getImage(id);
                if (imp == null) continue;
                String title = imp.getTitle();
                boolean bl = flagOthers = pattern.equals("\\Others") && currentImp != imp;
                if (!wm.match(title, pattern) && !flagOthers) continue;
                ImageWindow win = imp.getWindow();
                if (win != null) {
                    imp.changes = false;
                    win.close();
                } else {
                    imp.saveRoi();
                    WindowManager.setTempCurrentImage(null);
                    Interpreter.removeBatchModeImage(imp);
                }
                imp.changes = false;
                imp.close();
                if (imp != currentImp) continue;
                currentImpClosed = true;
            }
            if (!currentImpClosed && currentImp != null) {
                IJ.selectWindow(currentImp.getID());
            }
            this.resetImage();
        } else {
            ImagePlus imp = this.getImage();
            ImageWindow win = imp.getWindow();
            if (win != null) {
                imp.changes = false;
                win.close();
            } else {
                imp.saveRoi();
                WindowManager.setTempCurrentImage(null);
                Interpreter.removeBatchModeImage(imp);
            }
            this.resetImage();
        }
    }

    void setBatchMode() {
        boolean enterBatchMode = false;
        String sarg = null;
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            sarg = this.getString();
        } else {
            double arg = this.interp.getBooleanExpression();
            this.interp.checkBoolean(arg);
            enterBatchMode = arg == 1.0;
        }
        this.interp.getRightParen();
        Functions functions = this;
        if (!functions.interp.isBatchMode()) {
            this.interp.calledMacro = false;
        }
        this.resetImage();
        if (enterBatchMode) {
            Functions functions2 = this;
            if (functions2.interp.isBatchMode()) {
                return;
            }
            Interpreter.setBatchMode(true);
            ImagePlus tmp = WindowManager.getTempCurrentImage();
            if (tmp != null) {
                Interpreter.addBatchModeImage(tmp);
            }
            return;
        }
        IJ.showProgress(0, 0);
        ImagePlus imp2 = WindowManager.getCurrentImage();
        WindowManager.setTempCurrentImage(null);
        if (sarg == null) {
            Interpreter.setBatchMode(false);
            this.roiManager = null;
            this.displayBatchModeImage(imp2);
        } else if (sarg.equalsIgnoreCase("show")) {
            if (imp2 != null) {
                Interpreter.setTempShowMode(true);
                this.displayBatchModeImage(imp2);
                Interpreter.setTempShowMode(false);
                Interpreter.removeBatchModeImage(imp2);
            }
        } else if (sarg.equalsIgnoreCase("hide")) {
            Interpreter.setBatchMode(true);
            if (imp2 != null) {
                ImageWindow win = imp2.getWindow();
                if (win != null) {
                    imp2.hide();
                    Interpreter.addBatchModeImage(imp2);
                }
                IJ.selectWindow(imp2.getID());
            }
        } else {
            Vector v = Interpreter.imageTable;
            if (v == null) {
                return;
            }
            ImagePlus cImp = imp2;
            Interpreter.setBatchMode(false);
            this.roiManager = null;
            for (int i = 0; i < v.size(); ++i) {
                imp2 = (ImagePlus)v.elementAt(i);
                if (imp2 == null || imp2 == cImp) continue;
                this.displayBatchModeImage(imp2);
            }
            this.displayBatchModeImage(cImp);
        }
    }

    void displayBatchModeImage(ImagePlus imp2) {
        if (imp2 != null) {
            ImageWindow win = imp2.getWindow();
            if (win == null) {
                imp2.show();
            } else {
                if (!win.isVisible()) {
                    win.show();
                }
                imp2.updateAndDraw();
            }
            Roi roi = imp2.getRoi();
            if (roi != null) {
                imp2.setRoi(roi);
            }
        }
    }

    void setLocation() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        int width = 0;
        int height = 0;
        if (this.interp.nextToken() == 44) {
            width = (int)this.getNextArg();
            height = (int)this.getNextArg();
        }
        this.interp.getRightParen();
        if (width == 0 && height == 0) {
            Window win = WindowManager.getActiveWindow();
            if (win != null) {
                win.setLocation(x, y);
            }
        } else {
            ImagePlus imp = this.getImage();
            ImageWindow win = imp.getWindow();
            if (win != null) {
                win.setLocationAndSize(x, y, width, height);
            }
        }
    }

    void setSlice() {
        int n = (int)this.getArg();
        ImagePlus imp = this.getImage();
        int nSlices = imp.getStackSize();
        if (n == 1 && nSlices == 1) {
            return;
        }
        if (n < 1 || n > nSlices) {
            this.interp.error("Argument must be >=1 and <=" + nSlices);
        } else if (imp.isHyperStack()) {
            imp.setPosition(n);
        } else {
            imp.setSlice(n);
        }
        this.resetImage();
    }

    void newImage() {
        String title = this.getFirstString();
        String type = this.getNextString();
        int width = (int)this.getNextArg();
        int height = (int)this.getNextArg();
        int depth = (int)this.getNextArg();
        int c = -1;
        int z = -1;
        int t = -1;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            c = depth;
            z = (int)this.getNextArg();
            t = (int)this.getLastArg();
        }
        if (width < 1 || height < 1) {
            this.interp.error("Width or height < 1");
        }
        if (c < 0) {
            IJ.newImage(title, type, width, height, depth);
        } else {
            ImagePlus imp = IJ.createImage(title, type, width, height, c, z, t);
            imp.show();
        }
        this.resetImage();
    }

    void saveAs() {
        String format = this.getFirstString();
        String path = null;
        boolean oneArg = false;
        if (this.interp.nextToken() == 44) {
            path = this.getLastString();
        } else {
            this.interp.getRightParen();
            oneArg = true;
        }
        if (oneArg && format.contains(File.separator)) {
            IJ.save(format);
        } else {
            IJ.saveAs(format, path);
        }
    }

    double getZoom() {
        this.interp.getParens();
        ImagePlus imp = this.getImage();
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            this.interp.error("Image not displayed");
            return 0.0;
        }
        return ic.getMagnification();
    }

    void setAutoThreshold() {
        ImagePlus img;
        block8: {
            String mString = null;
            if (this.interp.nextToken() == 40) {
                this.interp.getLeftParen();
                if (this.isStringArg()) {
                    mString = this.getString();
                }
                this.interp.getRightParen();
            }
            img = this.getImage();
            ImageProcessor ip = this.getProcessor();
            if (ip instanceof ColorProcessor) {
                this.interp.error("Non-RGB image expected");
            }
            ip.setRoi(img.getRoi());
            if (mString != null) {
                try {
                    if (mString.indexOf("stack") != -1) {
                        IJ.setAutoThreshold(img, mString);
                        break block8;
                    }
                    ip.setAutoThreshold(mString);
                }
                catch (Exception e) {
                    this.interp.error("" + e.getMessage());
                }
            } else {
                ip.setAutoThreshold(1, 0);
            }
        }
        img.updateAndDraw();
        this.resetImage();
    }

    double parseDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if ((s = s.trim()).indexOf(32) != -1) {
            s = s.substring(0, s.indexOf(32));
        }
        return Tools.parseDouble(s);
    }

    double parseInt() {
        double n;
        String s = this.getFirstString();
        int radix = 10;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            radix = (int)this.interp.getExpression();
            if (radix < 2 || radix > 36) {
                radix = 10;
            }
        }
        this.interp.getRightParen();
        try {
            if (radix == 10) {
                n = this.parseDouble(s);
                if (!Double.isNaN(n)) {
                    n = Math.round(n);
                }
            } else {
                n = Integer.parseInt(s, radix);
            }
        }
        catch (NumberFormatException e) {
            n = Double.NaN;
        }
        return n;
    }

    void print() {
        this.interp.inPrint = true;
        String s = this.getFirstString();
        if (this.interp.nextToken() == 44) {
            if (s.startsWith("[") && s.endsWith("]")) {
                this.printToWindow(s);
                return;
            }
            if (s.equals("~0~")) {
                String s2;
                if (this.writer == null) {
                    this.interp.error("File not open");
                }
                if ((s2 = this.getLastString()).endsWith("\n")) {
                    this.writer.print(s2);
                } else {
                    this.writer.println(s2);
                }
                this.interp.inPrint = false;
                return;
            }
            StringBuffer sb = new StringBuffer(s);
            do {
                sb.append(" ");
                sb.append(this.getNextString());
            } while (this.interp.nextToken() == 44);
            s = sb.toString();
        }
        this.interp.getRightParen();
        IJ.log(s);
        this.interp.inPrint = false;
    }

    void printToWindow(String s) {
        boolean isEditor;
        String title = s.substring(1, s.length() - 1);
        String s2 = this.getLastString();
        boolean isCommand = s2.startsWith("\\");
        Frame frame = WindowManager.getFrame(title);
        if (frame == null) {
            if (isCommand) {
                this.interp.done = true;
                return;
            }
            this.interp.error("Window not found");
        }
        if (!(isEditor = frame instanceof Editor) && !(frame instanceof TextWindow)) {
            this.interp.error("Window is not text window");
        }
        if (isEditor) {
            Editor ed = (Editor)frame;
            ed.setIsMacroWindow(true);
            if (isCommand) {
                this.handleEditorCommand(ed, s2);
            } else {
                ed.append(s2);
            }
        } else {
            TextWindow tw = (TextWindow)frame;
            if (isCommand) {
                this.handleTextWindowCommand(tw, s2);
            } else {
                tw.append(s2);
            }
        }
    }

    void handleEditorCommand(Editor ed, String s) {
        if (s.startsWith("\\Update:")) {
            TextArea ta = ed.getTextArea();
            ta.setText(s.substring(8, s.length()));
            ta.setEditable(false);
        } else if (s.equals("\\Close")) {
            ed.close();
        } else {
            ed.append(s);
        }
    }

    void handleTextWindowCommand(TextWindow tw, String s) {
        TextPanel tp = tw.getTextPanel();
        if (s.startsWith("\\Update:")) {
            int n = tp.getLineCount();
            String s2 = s.substring(8, s.length());
            if (n == 0) {
                tp.append(s2);
            } else {
                tp.setLine(n - 1, s2);
            }
        } else if (s.startsWith("\\Update")) {
            int cindex = s.indexOf(":");
            if (cindex == -1) {
                tp.append(s);
                return;
            }
            String nstr = s.substring(7, cindex);
            int line = (int)Tools.parseDouble(nstr, -1.0);
            if (line < 0) {
                this.interp.error("Row index<0 or NaN");
            }
            for (int count = tp.getLineCount(); line >= count; ++count) {
                tp.append("");
            }
            String s2 = s.substring(cindex + 1, s.length());
            tp.setLine(line, s2);
        } else if (s.equals("\\Clear")) {
            tp.clear();
        } else if (s.equals("\\Close")) {
            tw.close();
        } else if (s.startsWith("\\Headings:")) {
            tp.setColumnHeadings(s.substring(10));
        } else {
            tp.append(s);
        }
    }

    double isKeyDown() {
        double value = 0.0;
        String key = this.getStringArg().toLowerCase(Locale.US);
        if (key.indexOf("alt") != -1) {
            value = IJ.altKeyDown() ? 1.0 : 0.0;
        } else if (key.indexOf("shift") != -1) {
            value = IJ.shiftKeyDown() ? 1.0 : 0.0;
        } else if (key.indexOf("space") != -1) {
            value = IJ.spaceBarDown() ? 1.0 : 0.0;
        } else {
            this.interp.error("Invalid key");
        }
        return value;
    }

    String runMacro(boolean eval) {
        this.interp.getLeftParen();
        String name = this.getString();
        String arg = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            arg = this.getString();
        }
        this.interp.getRightParen();
        if (eval) {
            if (arg != null && (name.equals("script") || name.equals("js"))) {
                return new Macro_Runner().runJavaScript(arg, "");
            }
            if (arg != null && name.equals("bsh")) {
                return Macro_Runner.runBeanShell(arg, "");
            }
            if (arg != null && name.equals("python")) {
                return Macro_Runner.runPython(arg, "");
            }
            return IJ.runMacro(name, arg);
        }
        return IJ.runMacroFile(name, arg);
    }

    void setThreshold() {
        double lower = this.getFirstArg();
        double upper = this.getNextArg();
        String mode = null;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            mode = this.getString();
        }
        this.interp.getRightParen();
        IJ.setThreshold(lower, upper, mode);
        this.resetImage();
    }

    void drawOrFill(int type) {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        int width = (int)this.getNextArg();
        int height = (int)this.getLastArg();
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        switch (type) {
            case 388: {
                ip.drawRect(x, y, width, height);
                break;
            }
            case 376: {
                ip.setRoi(x, y, width, height);
                ip.fill();
                break;
            }
            case 389: {
                ip.drawOval(x, y, width, height);
                break;
            }
            case 390: {
                ip.fillOval(x, y, width, height);
            }
        }
        this.updateAndDraw();
    }

    double getScreenDimension(int type) {
        this.interp.getParens();
        Dimension screen = IJ.getScreenSize();
        if (type == 1043) {
            return screen.width;
        }
        return screen.height;
    }

    void getStatistics(boolean calibrated) {
        Variable count = this.getFirstVariable();
        Variable mean = null;
        Variable min = null;
        Variable max = null;
        Variable std = null;
        Variable hist = null;
        int params = 19;
        this.interp.getToken();
        int arg = 1;
        while (this.interp.token == 44) {
            switch (++arg) {
                case 2: {
                    mean = this.getVariable();
                    break;
                }
                case 3: {
                    min = this.getVariable();
                    break;
                }
                case 4: {
                    max = this.getVariable();
                    break;
                }
                case 5: {
                    std = this.getVariable();
                    params += 4;
                    break;
                }
                case 6: {
                    hist = this.getArrayVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        ImagePlus imp = this.getImage();
        Calibration cal = calibrated ? imp.getCalibration() : null;
        ImageProcessor ip = this.getProcessor();
        ImageStatistics stats = null;
        Roi roi = imp.getRoi();
        int lineWidth = Line.getWidth();
        if (roi != null && roi.isLine() && lineWidth > 1) {
            ImageProcessor ip2;
            if (roi.getType() == 5) {
                ip2 = ip;
                Rectangle saveR = ip2.getRoi();
                ip2.setRoi(roi.getPolygon());
                stats = ImageStatistics.getStatistics(ip2, params, cal);
                ip2.setRoi(saveR);
            } else {
                ip2 = new Straightener().straightenLine(imp, lineWidth);
                stats = ImageStatistics.getStatistics(ip2, params, cal);
            }
        } else if (roi != null && roi.isLine()) {
            ProfilePlot profile = new ProfilePlot(imp);
            double[] values = profile.getProfile();
            FloatProcessor ip2 = new FloatProcessor(values.length, 1, values);
            if (roi instanceof Line) {
                Line l = (Line)roi;
                if ((l.y1 == l.y2 || l.x1 == l.x2) && (double)l.x1 == l.x1d && (double)l.y1 == l.y1d && (double)l.x2 == l.x2d && (double)l.y2 == l.y2d) {
                    ip2.setRoi(0, 0, ip2.getWidth() - 1, 1);
                }
            }
            stats = ImageStatistics.getStatistics(ip2, params, cal);
        } else {
            ip.setRoi(roi);
            stats = ImageStatistics.getStatistics(ip, params, cal);
        }
        if (calibrated) {
            count.setValue(stats.area);
        } else {
            count.setValue(stats.pixelCount);
        }
        if (mean != null) {
            mean.setValue(stats.mean);
        }
        if (min != null) {
            min.setValue(stats.min);
        }
        if (max != null) {
            max.setValue(stats.max);
        }
        if (std != null) {
            std.setValue(stats.stdDev);
        }
        if (hist != null) {
            boolean is16bit = !calibrated && ip instanceof ShortProcessor && stats.histogram16 != null;
            int[] histogram = is16bit ? stats.histogram16 : stats.histogram;
            int bins = is16bit ? (int)(stats.max + 1.0) : histogram.length;
            Variable[] array = new Variable[bins];
            int hmax = is16bit ? (int)stats.max : 255;
            for (int i = 0; i <= hmax; ++i) {
                array[i] = new Variable(histogram[i]);
            }
            hist.setArray(array);
        }
    }

    String replace() {
        String s1 = this.getFirstString();
        String s2 = this.getNextString();
        String s3 = this.getLastString();
        if (s2.length() == 1 && s3.length() == 1) {
            return s1.replace(s2.charAt(0), s3.charAt(0));
        }
        try {
            return s1.replaceAll(s2, s3);
        }
        catch (Exception e) {
            this.interp.error("" + e);
            return null;
        }
    }

    void floodFill() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        boolean fourConnected = true;
        if (this.interp.nextToken() == 44) {
            String s = this.getLastString();
            if (s.indexOf("8") != -1) {
                fourConnected = false;
            }
        } else {
            this.interp.getRightParen();
        }
        ImageProcessor ip = this.getProcessor();
        if (!this.colorSet) {
            this.setForegroundColor(ip);
        }
        FloodFiller ff = new FloodFiller(ip);
        if (fourConnected) {
            ff.fill(x, y);
        } else {
            ff.fill8(x, y);
        }
        this.updateAndDraw();
        if (Recorder.record && this.pgm.hasVars) {
            Recorder.record("floodFill", x, y);
        }
    }

    void restorePreviousTool() {
        this.interp.getParens();
        Toolbar tb = Toolbar.getInstance();
        if (tb != null) {
            tb.restorePreviousTool();
        }
    }

    void setVoxelSize() {
        double width = this.getFirstArg();
        double height = this.getNextArg();
        double depth = this.getNextArg();
        String unit = this.getLastString();
        ImagePlus imp = this.getImage();
        Calibration cal = imp.getCalibration();
        cal.pixelWidth = width;
        cal.pixelHeight = height;
        cal.pixelDepth = depth;
        cal.setUnit(unit);
        imp.repaintWindow();
    }

    void getLocationAndSize() {
        Variable v1 = this.getFirstVariable();
        Variable v2 = this.getNextVariable();
        Variable v3 = this.getNextVariable();
        Variable v4 = this.getLastVariable();
        ImagePlus imp = this.getImage();
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            Point loc = win.getLocation();
            Dimension size = win.getSize();
            x = loc.x;
            y = loc.y;
            w = size.width;
            h = size.height;
        }
        v1.setValue(x);
        v2.setValue(y);
        v3.setValue(w);
        v4.setValue(h);
    }

    String doDialog() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        String name = this.interp.tokenString;
        try {
            if (name.equals("create")) {
                this.gd = new GenericDialog(this.getStringArg());
                return null;
            }
            if (this.gd == null) {
                this.interp.error("No dialog created with Dialog.create()");
                return null;
            }
            if (name.equals("addString")) {
                String label = this.getFirstString();
                String defaultStr = this.getNextString();
                int columns = 8;
                if (this.interp.nextToken() == 44) {
                    columns = (int)this.getNextArg();
                }
                this.interp.getRightParen();
                this.gd.addStringField(label, defaultStr, columns);
            } else if (name.equals("addNumber")) {
                int decimalPlaces;
                int columns = 6;
                String units = null;
                String prompt = this.getFirstString();
                double defaultNumber = this.getNextArg();
                int n = decimalPlaces = (double)((int)defaultNumber) == defaultNumber ? 0 : 3;
                if (this.interp.nextToken() == 44) {
                    decimalPlaces = (int)this.getNextArg();
                    columns = (int)this.getNextArg();
                    units = this.getLastString();
                } else {
                    this.interp.getRightParen();
                }
                this.gd.addNumericField(prompt, defaultNumber, decimalPlaces, columns, units);
            } else if (name.equals("addSlider")) {
                String label = this.getFirstString();
                double minValue = this.getNextArg();
                double maxValue = this.getNextArg();
                double defaultValue = this.getLastArg();
                this.gd.addSlider(label, minValue, maxValue, defaultValue);
            } else if (name.equals("addCheckbox")) {
                this.gd.addCheckbox(this.getFirstString(), this.getLastArg() == 1.0);
            } else if (name.equals("addCheckboxGroup")) {
                this.addCheckboxGroup(this.gd);
            } else if (name.equals("addRadioButtonGroup")) {
                this.addRadioButtonGroup(this.gd);
            } else if (name.equals("addMessage")) {
                this.gd.addMessage(this.getStringArg());
            } else if (name.equals("addHelp")) {
                this.gd.addHelp(this.getStringArg());
            } else if (name.equals("addChoice")) {
                String prompt = this.getFirstString();
                this.interp.getComma();
                String[] choices = this.getStringArray();
                String defaultChoice = null;
                if (this.interp.nextToken() == 44) {
                    this.interp.getComma();
                    defaultChoice = this.getString();
                } else {
                    defaultChoice = choices[0];
                }
                this.interp.getRightParen();
                this.gd.addChoice(prompt, choices, defaultChoice);
            } else if (name.equals("setInsets")) {
                this.gd.setInsets((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
            } else if (name.equals("show")) {
                this.interp.getParens();
                this.gd.showDialog();
                if (this.gd.wasCanceled()) {
                    this.interp.finishUp();
                    throw new RuntimeException("Macro canceled");
                }
            } else {
                if (name.equals("getString")) {
                    this.interp.getParens();
                    return this.gd.getNextString();
                }
                if (name.equals("getNumber")) {
                    this.interp.getParens();
                    return "" + this.gd.getNextNumber();
                }
                if (name.equals("getCheckbox")) {
                    this.interp.getParens();
                    return this.gd.getNextBoolean() ? "1" : "0";
                }
                if (name.equals("getChoice")) {
                    this.interp.getParens();
                    return this.gd.getNextChoice();
                }
                if (name.equals("getRadioButton")) {
                    this.interp.getParens();
                    return this.gd.getNextRadioButton();
                }
                this.interp.error("Unrecognized Dialog function " + name);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.interp.error("Dialog error");
        }
        return null;
    }

    void addCheckboxGroup(GenericDialog gd) {
        int rows = (int)this.getFirstArg();
        int columns = (int)this.getNextArg();
        this.interp.getComma();
        String[] labels = this.getStringArray();
        int n = labels.length;
        double[] dstates = this.getLastArray();
        if (n != dstates.length) {
            this.interp.error("labels.length!=states.length");
        }
        boolean[] states = new boolean[n];
        for (int i = 0; i < n; ++i) {
            states[i] = dstates[i] == 1.0;
        }
        gd.addCheckboxGroup(rows, columns, labels, states);
    }

    void addRadioButtonGroup(GenericDialog gd) {
        String label = this.getFirstString();
        this.interp.getComma();
        String[] items = this.getStringArray();
        int rows = (int)this.getNextArg();
        int columns = (int)this.getNextArg();
        String defaultItem = this.getLastString();
        gd.addRadioButtonGroup(label, items, rows, columns, defaultItem);
    }

    void getDateAndTime() {
        Variable year = this.getFirstVariable();
        Variable month = this.getNextVariable();
        Variable dayOfWeek = this.getNextVariable();
        Variable dayOfMonth = this.getNextVariable();
        Variable hour = this.getNextVariable();
        Variable minute = this.getNextVariable();
        Variable second = this.getNextVariable();
        Variable millisecond = this.getLastVariable();
        Calendar date = Calendar.getInstance();
        year.setValue(date.get(1));
        month.setValue(date.get(2));
        dayOfWeek.setValue(date.get(7) - 1);
        dayOfMonth.setValue(date.get(5));
        hour.setValue(date.get(11));
        minute.setValue(date.get(12));
        second.setValue(date.get(13));
        millisecond.setValue(date.get(14));
    }

    void setMetadata() {
        String metadata = null;
        String arg1 = this.getFirstString();
        boolean oneArg = false;
        if (this.interp.nextToken() == 44) {
            metadata = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        boolean isInfo = false;
        if (metadata == null) {
            metadata = arg1;
            oneArg = true;
            if (metadata.startsWith("Info:")) {
                metadata = metadata.substring(5);
                isInfo = true;
            }
        } else {
            isInfo = arg1.startsWith("info") || arg1.startsWith("Info");
        }
        ImagePlus imp = this.getImage();
        if (metadata != null && metadata.length() == 0) {
            metadata = null;
        }
        if (isInfo) {
            imp.setProperty("Info", metadata);
        } else if (imp.getStackSize() == 1) {
            if (oneArg) {
                imp.setProperty("Info", metadata);
            } else {
                imp.setProperty("Label", metadata);
                if (!Interpreter.isBatchMode()) {
                    imp.repaintWindow();
                }
            }
        } else {
            imp.getStack().setSliceLabel(metadata, imp.getCurrentSlice());
            if (!Interpreter.isBatchMode()) {
                imp.repaintWindow();
            }
        }
    }

    String getMetadata() {
        String type = "label";
        boolean noArg = true;
        if (this.interp.nextToken() == 40 && this.interp.nextNextToken() != 41) {
            type = this.getStringArg().toLowerCase(Locale.US);
            noArg = false;
        } else {
            this.interp.getParens();
        }
        ImagePlus imp = this.getImage();
        String metadata = null;
        if (type.indexOf("label") != -1) {
            if (imp.getStackSize() == 1) {
                metadata = (String)imp.getProperty("Label");
                if (metadata == null && noArg) {
                    metadata = (String)imp.getProperty("Info");
                }
            } else {
                metadata = imp.getStack().getSliceLabel(imp.getCurrentSlice());
            }
        } else {
            metadata = (String)imp.getProperty("Info");
        }
        if (metadata == null) {
            metadata = "";
        }
        return metadata;
    }

    ImagePlus getImageArg() {
        ImagePlus img = null;
        if (this.isStringArg()) {
            String title = this.getString();
            img = WindowManager.getImage(title);
        } else {
            int id = (int)this.interp.getExpression();
            img = WindowManager.getImage(id);
        }
        if (img == null) {
            this.interp.error("Image not found");
        }
        return img;
    }

    void imageCalculator() {
        String operator = this.getFirstString();
        this.interp.getComma();
        ImagePlus img1 = this.getImageArg();
        this.interp.getComma();
        ImagePlus img2 = this.getImageArg();
        this.interp.getRightParen();
        ImageCalculator ic = new ImageCalculator();
        ic.calculate(operator, img1, img2);
        this.resetImage();
    }

    void setRGBWeights() {
        double r = this.getFirstArg();
        double g = this.getNextArg();
        double b = this.getLastArg();
        if (this.interp.rgbWeights == null) {
            this.interp.rgbWeights = ColorProcessor.getWeightingFactors();
        }
        ColorProcessor.setWeightingFactors(r, g, b);
    }

    void makePolygon() {
        int n;
        int max = 200;
        int[] x = new int[max];
        int[] y = new int[max];
        x[0] = (int)Math.round(this.getFirstArg());
        y[0] = (int)Math.round(this.getNextArg());
        this.interp.getToken();
        for (n = 1; this.interp.token == 44 && n < max; ++n) {
            x[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getComma();
            y[n] = (int)Math.round(this.interp.getExpression());
            this.interp.getToken();
        }
        if (n < 3) {
            this.interp.error("Fewer than 3 points");
        }
        if (n == max && this.interp.token != 41) {
            this.interp.error("More than " + max + " points");
        }
        ImagePlus imp = this.getImage();
        Roi previousRoi = imp.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imp.saveRoi();
        }
        imp.setRoi(new PolygonRoi(x, y, n, 2));
        Roi roi = imp.getRoi();
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    void updateRoi(Roi roi) {
        if (this.shiftKeyDown || this.altKeyDown) {
            roi.update(this.shiftKeyDown, this.altKeyDown);
        }
        this.altKeyDown = false;
        this.shiftKeyDown = false;
    }

    String doFile() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("open")) {
            return this.openFile();
        }
        if (name.equals("openAsString")) {
            return this.openAsString();
        }
        if (name.equals("openAsRawString")) {
            return this.openAsRawString();
        }
        if (name.equals("openUrlAsString")) {
            return IJ.openUrlAsString(this.getStringArg());
        }
        if (name.equals("openDialog")) {
            return this.openDialog();
        }
        if (name.equals("close")) {
            return this.closeFile();
        }
        if (name.equals("separator")) {
            this.interp.getParens();
            return File.separator;
        }
        if (name.equals("directory")) {
            this.interp.getParens();
            String lastDir = OpenDialog.getLastDirectory();
            return lastDir != null ? lastDir : "";
        }
        if (name.equals("name")) {
            this.interp.getParens();
            String lastName = OpenDialog.getLastName();
            return lastName != null ? lastName : "";
        }
        if (name.equals("nameWithoutExtension")) {
            this.interp.getParens();
            return this.nameWithoutExtension();
        }
        if (name.equals("rename")) {
            File f1 = new File(this.getFirstString());
            File f2 = new File(this.getLastString());
            if (this.checkPath(f1) && this.checkPath(f2)) {
                return f1.renameTo(f2) ? "1" : "0";
            }
            return "0";
        }
        if (name.equals("copy")) {
            File f2;
            File f1 = new File(this.getFirstString());
            String err = Functions.copyFile(f1, f2 = new File(this.getLastString()));
            if (err.length() > 0) {
                this.interp.error(err);
            }
            return null;
        }
        if (name.equals("append")) {
            String err = IJ.append(this.getFirstString(), this.getLastString());
            if (err != null) {
                this.interp.error(err);
            }
            return null;
        }
        if (name.equals("saveString")) {
            String err = IJ.saveString(this.getFirstString(), this.getLastString());
            if (err != null) {
                this.interp.error(err);
            }
            return null;
        }
        File f = new File(this.getStringArg());
        if (name.equals("getLength") || name.equals("length")) {
            return "" + f.length();
        }
        if (name.equals("getName")) {
            return f.getName();
        }
        if (name.equals("getAbsolutePath")) {
            return f.getAbsolutePath();
        }
        if (name.equals("getParent")) {
            return f.getParent();
        }
        if (name.equals("exists")) {
            return f.exists() ? "1" : "0";
        }
        if (name.equals("isDirectory")) {
            return f.isDirectory() ? "1" : "0";
        }
        if (name.equals("makeDirectory") || name.equals("mkdir")) {
            f.mkdir();
            return null;
        }
        if (name.equals("lastModified")) {
            return "" + f.lastModified();
        }
        if (name.equals("dateLastModified")) {
            return new Date(f.lastModified()).toString();
        }
        if (name.equals("delete")) {
            return f.delete() ? "1" : "0";
        }
        this.interp.error("Unrecognized File function " + name);
        return null;
    }

    String nameWithoutExtension() {
        String name = OpenDialog.getLastName();
        if (name == null) {
            return "";
        }
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0 && name.length() - dotIndex <= 5) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    boolean checkPath(File f) {
        String path = f.getPath();
        if (path.equals("0") || path.equals("NaN")) {
            this.interp.error("Invalid path");
            return false;
        }
        return true;
    }

    String openDialog() {
        String title = this.getStringArg();
        OpenDialog od = new OpenDialog(title, null);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return "";
        }
        return directory + name;
    }

    void setSelectionName() {
        Roi roi = this.getImage().getRoi();
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            roi.setName(this.getStringArg());
        }
    }

    String selectionName() {
        Roi roi = this.getImage().getRoi();
        String name = null;
        if (roi == null) {
            this.interp.error("No selection");
        } else {
            name = roi.getName();
        }
        return name != null ? name : "";
    }

    String openFile() {
        if (this.writer != null) {
            this.interp.error("Currently, only one file can be open at a time");
            return "";
        }
        String path = this.getFirstString();
        String defaultName = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            defaultName = this.getLastString();
        }
        if (path.equals("") || defaultName != null) {
            String title = defaultName != null ? path : "openFile";
            SaveDialog sd = new SaveDialog(title, defaultName = defaultName != null ? defaultName : "log.txt", ".txt");
            if (sd.getFileName() == null) {
                return "";
            }
            path = sd.getDirectory() + sd.getFileName();
        } else {
            File file = new File(path);
            if (!(!file.exists() || path.endsWith(".txt") || path.endsWith(".java") || path.endsWith(".xls") || path.endsWith(".ijm") || path.endsWith(".html") || path.endsWith(".htm"))) {
                this.interp.error("File exists and suffix is not '.txt', '.java', etc.");
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(path);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            this.writer = new PrintWriter(bos);
        }
        catch (IOException e) {
            this.interp.error("File open error \n\"" + e.getMessage() + "\"\n");
            return "";
        }
        return "~0~";
    }

    String openAsString() {
        String path = this.getStringArg();
        String str = IJ.openAsString(path);
        if (str == null) {
            this.interp.done = true;
        } else if (str.startsWith("Error: ")) {
            this.interp.error(str);
        }
        return str;
    }

    String openAsRawString() {
        int max = 5000;
        String path = this.getFirstString();
        boolean specifiedMax = false;
        if (this.interp.nextToken() == 44) {
            max = (int)this.getNextArg();
            specifiedMax = true;
        }
        this.interp.getRightParen();
        if (path.equals("")) {
            OpenDialog od = new OpenDialog("Open As String", "");
            String directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return "";
            }
            path = directory + name;
        }
        String str = "";
        File file = new File(path);
        if (!file.exists()) {
            this.interp.error("File not found");
        }
        try {
            StringBuffer sb = new StringBuffer(5000);
            int len = (int)file.length();
            if (max > len || path.endsWith(".txt") && !specifiedMax) {
                max = len;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
            DataInputStream dis = new DataInputStream(in);
            byte[] buffer = new byte[max];
            dis.readFully(buffer);
            dis.close();
            char[] buffer2 = new char[buffer.length];
            for (int i = 0; i < buffer.length; ++i) {
                buffer2[i] = (char)(buffer[i] & 0xFF);
            }
            str = new String(buffer2);
        }
        catch (Exception e) {
            this.interp.error("File open error \n\"" + e.getMessage() + "\"\n");
        }
        return str;
    }

    String closeFile() {
        String f = this.getStringArg();
        if (!f.equals("~0~")) {
            this.interp.error("Invalid file variable");
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        return null;
    }

    public static String copyFile(File source, File destination) {
        try {
            if (!source.exists()) {
                return "Source file does not exist";
            }
            if (!destination.exists()) {
                destination.createNewFile();
            }
            FileInputStream sourceStream = new FileInputStream(source);
            FileChannel sourceChannel = sourceStream.getChannel();
            FileOutputStream destStream = new FileOutputStream(destination);
            FileChannel destChannel = destStream.getChannel();
            if (destChannel != null && sourceChannel != null) {
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            sourceChannel.close();
            sourceStream.close();
            destChannel.close();
            destStream.close();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    String call() {
        Method m;
        int i;
        Class[] argClasses;
        Class<?> c;
        String fullName = this.getFirstString();
        int dot = fullName.lastIndexOf(46);
        if (dot < 0) {
            this.interp.error("'classname.methodname' expected");
            return null;
        }
        String className = fullName.substring(0, dot);
        String methodName = fullName.substring(dot + 1);
        Object[] args = null;
        if (this.interp.nextToken() == 44) {
            Vector<String> vargs = new Vector<String>();
            do {
                vargs.add(this.getNextString());
            } while (this.interp.nextToken() == 44);
            args = vargs.toArray();
        }
        this.interp.getRightParen();
        if (args == null) {
            args = new Object[]{};
        }
        try {
            c = IJ.getClassLoader().loadClass(className);
        }
        catch (Exception ex) {
            this.interp.error("Could not load class " + className);
            return null;
        }
        try {
            argClasses = null;
            if (args.length > 0) {
                argClasses = new Class[args.length];
                for (i = 0; i < args.length; ++i) {
                    argClasses[i] = args[i].getClass();
                }
            }
            m = c.getMethod(methodName, argClasses);
        }
        catch (Exception ex) {
            m = null;
        }
        if (m == null && args.length > 0) {
            try {
                argClasses = new Class[args.length];
                for (i = 0; i < args.length; ++i) {
                    double value = Tools.parseDouble((String)args[i]);
                    if (!Double.isNaN(value)) {
                        args[i] = new Integer((int)value);
                        argClasses[i] = Integer.TYPE;
                        continue;
                    }
                    argClasses[i] = args[i].getClass();
                }
                m = c.getMethod(methodName, argClasses);
            }
            catch (Exception ex) {
                m = null;
            }
        }
        if (m == null) {
            this.interp.error("Could not find the method " + methodName + " with " + args.length + " parameter(s) in class " + className);
        }
        try {
            Object obj = m.invoke(null, args);
            return obj != null ? obj.toString() : null;
        }
        catch (InvocationTargetException e) {
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            e.getCause().printStackTrace(pw);
            String s = caw.toString();
            if (IJ.getInstance() != null) {
                new TextWindow("Exception", s, 400, 400);
            } else {
                IJ.log(s);
            }
            return null;
        }
        catch (Exception e) {
            IJ.log("Call error (" + e + ")");
            return null;
        }
    }

    Variable[] getFontList() {
        this.interp.getParens();
        String[] fonts = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        fonts = ge.getAvailableFontFamilyNames();
        if (fonts == null) {
            return null;
        }
        Variable[] array = new Variable[fonts.length];
        for (int i = 0; i < fonts.length; ++i) {
            array[i] = new Variable(0, 0.0, fonts[i]);
        }
        return array;
    }

    void setOption() {
        String arg1 = this.getFirstString();
        boolean state = true;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg2 = this.interp.getBooleanExpression();
            this.interp.checkBoolean(arg2);
            state = arg2 != 0.0;
        }
        this.interp.getRightParen();
        arg1 = arg1.toLowerCase(Locale.US);
        if (arg1.equals("disablepopupmenu")) {
            ImageCanvas ic = this.getImage().getCanvas();
            if (ic != null) {
                ic.disablePopupMenu(state);
            }
        } else if (arg1.startsWith("show all")) {
            RoiManager rm;
            RoiManager roiManager = rm = this.roiManager != null ? this.roiManager : RoiManager.getInstance();
            if (rm != null) {
                rm.runCommand(state ? "show all" : "show none");
            }
        } else if (arg1.equals("changes")) {
            this.getImage().changes = state;
        } else if (arg1.equals("debugmode")) {
            IJ.setDebugMode(state);
        } else if (arg1.equals("openusingplugins")) {
            Opener.setOpenUsingPlugins(state);
        } else if (arg1.equals("queuemacros")) {
            this.pgm.queueCommands = state;
        } else if (arg1.equals("disableundo")) {
            Prefs.disableUndo = state;
        } else if (arg1.startsWith("openashyper")) {
            this.getImage().setOpenAsHyperStack(true);
        } else if (arg1.startsWith("black")) {
            Prefs.blackBackground = state;
        } else if (arg1.startsWith("display lab")) {
            Analyzer.setMeasurement(1024, state);
        } else if (arg1.startsWith("limit to")) {
            Analyzer.setMeasurement(256, state);
        } else if (arg1.startsWith("add to")) {
            Analyzer.setMeasurement(0x400000, state);
        } else if (arg1.equals("area")) {
            Analyzer.setMeasurement(1, state);
        } else if (arg1.equals("mean")) {
            Analyzer.setMeasurement(2, state);
        } else if (arg1.equals("stack position")) {
            Analyzer.setMeasurement(0x100000, state);
        } else if (arg1.startsWith("std")) {
            Analyzer.setMeasurement(4, state);
        } else if (arg1.equals("showrownumbers")) {
            ResultsTable.getResultsTable().showRowNumbers(state);
        } else if (arg1.startsWith("show")) {
            Analyzer.setOption(arg1, state);
        } else if (arg1.startsWith("bicubic")) {
            ImageProcessor.setUseBicubic(state);
        } else if (arg1.startsWith("wand") || arg1.indexOf("points") != -1) {
            Wand.setAllPoints(state);
        } else if (arg1.startsWith("expandablearrays")) {
            this.expandableArrays = state;
        } else if (arg1.startsWith("loop")) {
            Calibration.setLoopBackAndForth(state);
        } else if (arg1.startsWith("jfilechooser")) {
            Prefs.useJFileChooser = state;
        } else if (arg1.startsWith("auto")) {
            Prefs.autoContrast = state;
        } else {
            this.interp.error("Invalid option");
        }
    }

    void setMeasurementOption(String option) {
    }

    void showText() {
        String title = this.getFirstString();
        String text = null;
        if (this.interp.nextToken() == 44) {
            text = this.getLastString();
        } else {
            this.interp.getRightParen();
        }
        if (text == null) {
            text = title;
            title = "Untitled";
        }
        Frame frame = WindowManager.getFrame(title);
        Editor ed = null;
        boolean useExisting = frame instanceof Editor;
        if (useExisting) {
            ed = (Editor)frame;
            TextArea ta = ed.getTextArea();
            ta.selectAll();
            ta.replaceRange(text, ta.getSelectionStart(), ta.getSelectionEnd());
        } else {
            ed = new Editor();
            ed.setSize(350, 300);
            ed.create(title, text);
        }
        if (title.equals("Untitled") && text.contains("Test Action Tool")) {
            new MacroInstaller().installSingleTool(text);
        }
    }

    Variable[] newMenu() {
        String name = this.getFirstString();
        this.interp.getComma();
        String[] commands = this.getStringArray();
        this.interp.getRightParen();
        if (this.pgm.menus == null) {
            this.pgm.menus = new Hashtable();
        }
        this.pgm.menus.put(name, commands);
        Variable[] commands2 = new Variable[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            commands2[i] = new Variable(0, 0.0, commands[i]);
        }
        return commands2;
    }

    void setSelectionLocation() {
        int x = (int)Math.round(this.getFirstArg());
        int y = (int)Math.round(this.getLastArg());
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        roi.setLocation(x, y);
        imp.draw();
    }

    double is() {
        boolean state = false;
        String arg = this.getStringArg();
        if ((arg = arg.toLowerCase(Locale.US)).equals("locked")) {
            state = this.getImage().isLocked();
        } else if (arg.indexOf("invert") != -1) {
            state = this.getImage().isInvertedLut();
        } else if (arg.indexOf("hyper") != -1) {
            state = this.getImage().isHyperStack();
        } else if (arg.indexOf("batch") != -1) {
            state = Interpreter.isBatchMode();
        } else if (arg.indexOf("applet") != -1) {
            state = IJ.getApplet() != null;
        } else if (arg.indexOf("virtual") != -1) {
            state = this.getImage().getStack().isVirtual();
        } else if (arg.indexOf("composite") != -1) {
            state = this.getImage().isComposite();
        } else if (arg.indexOf("caps") != -1) {
            state = this.getCapsLockState();
        } else if (arg.indexOf("change") != -1) {
            state = this.getImage().changes;
        } else if (arg.indexOf("binary") != -1) {
            state = this.getProcessor().isBinary();
        } else if (arg.indexOf("grayscale") != -1) {
            state = this.getProcessor().isGrayscale();
        } else if (arg.indexOf("animated") != -1) {
            ImageWindow win = this.getImage().getWindow();
            state = win != null && win instanceof StackWindow && ((StackWindow)win).getAnimate();
        } else {
            this.interp.error("Invalid argument");
        }
        return state ? 1.0 : 0.0;
    }

    final boolean getCapsLockState() {
        boolean capsDown = false;
        try {
            capsDown = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return capsDown;
    }

    Variable[] getList() {
        String key = this.getStringArg().toLowerCase();
        if (key.equals("java.properties")) {
            Properties props = System.getProperties();
            Vector<String> v = new Vector<String>();
            Enumeration<Object> en = props.keys();
            while (en.hasMoreElements()) {
                v.addElement((String)en.nextElement());
            }
            Variable[] array = new Variable[v.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new Variable(0, 0.0, (String)v.elementAt(i));
            }
            return array;
        }
        if (key.equals("window.titles")) {
            String[] titles = WindowManager.getNonImageTitles();
            Variable[] array = new Variable[titles.length];
            for (int i = 0; i < titles.length; ++i) {
                array[i] = new Variable(0, 0.0, titles[i]);
            }
            return array;
        }
        if (key.equals("threshold.methods")) {
            String[] list = AutoThresholder.getMethods();
            Variable[] array = new Variable[list.length];
            for (int i = 0; i < list.length; ++i) {
                array[i] = new Variable(0, 0.0, list[i]);
            }
            return array;
        }
        if (key.equals("luts")) {
            String[] list = IJ.getLuts();
            Variable[] array = new Variable[list.length];
            for (int i = 0; i < list.length; ++i) {
                array[i] = new Variable(0, 0.0, list[i]);
            }
            return array;
        }
        this.interp.error("Unvalid key");
        return null;
    }

    String doString() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("append")) {
            return this.appendToBuffer();
        }
        if (name.equals("copy")) {
            return this.copyStringToClipboard();
        }
        if (name.equals("copyResults")) {
            return this.copyResults();
        }
        if (name.equals("getResultsHeadings")) {
            return this.getResultsHeadings();
        }
        if (name.equals("paste")) {
            return this.getClipboardContents();
        }
        if (name.equals("resetBuffer")) {
            return this.resetBuffer();
        }
        if (name.equals("buffer")) {
            return this.getBuffer();
        }
        if (name.equals("show")) {
            return this.showString();
        }
        this.interp.error("Unrecognized String function");
        return null;
    }

    private String showString() {
        this.showText();
        return null;
    }

    private String getResultsHeadings() {
        this.interp.getParens();
        ResultsTable rt = ResultsTable.getResultsTable();
        return rt.getColumnHeadings();
    }

    private String appendToBuffer() {
        String text = this.getStringArg();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        this.buffer.append(text);
        return null;
    }

    private String copyStringToClipboard() {
        String text = this.getStringArg();
        StringSelection ss = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(ss, null);
        return null;
    }

    private String getClipboardContents() {
        this.interp.getParens();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable data = clipboard.getContents(null);
        String s = null;
        try {
            s = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            s = data.toString();
        }
        return s;
    }

    private String copyResults() {
        TextPanel tp;
        this.interp.getParens();
        if (!IJ.isResultsWindow()) {
            this.interp.error("No results");
        }
        if ((tp = IJ.getTextPanel()) != null) {
            tp.copySelection();
        }
        return null;
    }

    private String resetBuffer() {
        this.interp.getParens();
        this.buffer = new StringBuffer(256);
        return null;
    }

    private String getBuffer() {
        this.interp.getParens();
        if (this.buffer == null) {
            this.buffer = new StringBuffer(256);
        }
        return this.buffer.toString();
    }

    private void doCommand() {
        String arg = this.getStringArg();
        if (arg.equals("Start Animation")) {
            arg = "Start Animation [\\]";
        }
        IJ.doCommand(arg);
    }

    private void getDimensions() {
        Variable width = this.getFirstVariable();
        Variable height = this.getNextVariable();
        Variable channels = this.getNextVariable();
        Variable slices = this.getNextVariable();
        Variable frames = this.getLastVariable();
        ImagePlus imp = this.getImage();
        int[] dim = imp.getDimensions();
        width.setValue(dim[0]);
        height.setValue(dim[1]);
        channels.setValue(dim[2]);
        slices.setValue(dim[3]);
        frames.setValue(dim[4]);
    }

    public static void registerExtensions(MacroExtension extensions) {
        Interpreter interp = Interpreter.getInstance();
        if (interp == null) {
            IJ.error("Macro must be running to install macro extensions");
            return;
        }
        interp.pgm.extensionRegistry = new Hashtable();
        ExtensionDescriptor[] descriptors = extensions.getExtensionFunctions();
        for (int i = 0; i < descriptors.length; ++i) {
            interp.pgm.extensionRegistry.put(descriptors[i].name, descriptors[i]);
        }
    }

    String doExt() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 136 && this.interp.token != 135 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("install")) {
            Object plugin = IJ.runPlugIn(this.getStringArg(), "");
            if (plugin == null) {
                this.interp.error("Plugin not found");
            }
            return null;
        }
        ExtensionDescriptor desc = null;
        if (this.pgm.extensionRegistry != null) {
            desc = (ExtensionDescriptor)this.pgm.extensionRegistry.get(name);
        }
        if (desc == null) {
            this.interp.error("Unrecognized Ext function");
            return null;
        }
        return desc.dispatch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String exec() {
        boolean openingDoc;
        Object[] cmd;
        StringBuffer sb = new StringBuffer(256);
        String arg1 = this.getFirstString();
        if (this.interp.nextToken() == 44) {
            Vector<String> v = new Vector<String>();
            v.add(arg1);
            do {
                v.add(this.getNextString());
            } while (this.interp.nextToken() == 44);
            cmd = new String[v.size()];
            v.copyInto(cmd);
        } else {
            cmd = Tools.split(arg1);
        }
        this.interp.getRightParen();
        boolean bl = openingDoc = cmd.length == 2 && cmd[0].equals("open") || cmd.length == 5 && cmd[3].equals("excel.exe");
        if (openingDoc && IJ.isWindows()) {
            String path = cmd[1];
            if (path.startsWith("http://") || path.startsWith("HTTP://")) {
                cmd = new String[4];
                cmd[2] = "start";
                cmd[3] = path;
            } else {
                cmd = new String[3];
                cmd[2] = path;
            }
            cmd[0] = "cmd";
            cmd[1] = "/c";
        }
        BufferedReader reader = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec((String[])cmd);
            if (openingDoc) {
                String string = null;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            int count = 1;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
                if (count++ != 1 || !line.startsWith("Microsoft Windows")) continue;
                break;
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage() + "\n");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }

    double getValue() {
        String key = this.getStringArg();
        if (key.equals("rgb.foreground")) {
            return Toolbar.getForegroundColor().getRGB() & 0xFFFFFF;
        }
        if (key.equals("rgb.background")) {
            return Toolbar.getBackgroundColor().getRGB() & 0xFFFFFF;
        }
        if (key.contains("foreground")) {
            return this.getColorValue(Toolbar.getForegroundColor());
        }
        if (key.contains("background")) {
            return this.getColorValue(Toolbar.getBackgroundColor());
        }
        if (key.equals("font.size")) {
            this.resetImage();
            ImageProcessor ip = this.getProcessor();
            this.setFont(ip);
            return ip.getFont().getSize();
        }
        if (key.equals("font.height")) {
            this.resetImage();
            ImageProcessor ip = this.getProcessor();
            this.setFont(ip);
            return ip.getFontMetrics().getHeight();
        }
        if (key.equals("selection.width")) {
            ImagePlus imp = this.getImage();
            Roi roi = imp.getRoi();
            if (roi == null) {
                this.interp.error("No selection");
            }
            return roi.getStrokeWidth();
        }
        this.interp.error("Invalid key");
        return 0.0;
    }

    double getColorValue(Color color) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null || imp.getBitDepth() == 24) {
            return color.getRGB() & 0xFFFFFF;
        }
        ImageProcessor ip = imp.getProcessor();
        ip.setRoi(0, 0, 1, 1);
        ip = ip.crop();
        ip.setColor(color);
        ip.drawDot(0, 0);
        return ip.getf(0, 0);
    }

    double doStack() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("isHyperstack") || name.equals("isHyperStack")) {
            return this.getImage().isHyperStack() ? 1.0 : 0.0;
        }
        if (name.equals("getDimensions")) {
            this.getDimensions();
            return Double.NaN;
        }
        ImagePlus imp = this.getImage();
        if (name.equals("setPosition")) {
            this.setPosition(imp);
            return Double.NaN;
        }
        if (name.equals("getPosition")) {
            this.getPosition(imp);
            return Double.NaN;
        }
        Calibration cal = imp.getCalibration();
        if (name.equals("getFrameRate")) {
            this.interp.getParens();
            return cal.fps;
        }
        if (name.equals("setFrameRate")) {
            cal.fps = this.getArg();
            return Double.NaN;
        }
        if (name.equals("getFrameInterval")) {
            this.interp.getParens();
            return cal.frameInterval;
        }
        if (name.equals("setFrameInterval")) {
            cal.frameInterval = this.getArg();
            return Double.NaN;
        }
        if (name.equals("setTUnit")) {
            cal.setTimeUnit(this.getStringArg());
            return Double.NaN;
        }
        if (name.equals("setZUnit")) {
            cal.setZUnit(this.getStringArg());
            return Double.NaN;
        }
        if (name.equals("getUnits")) {
            this.getStackUnits(cal);
            return Double.NaN;
        }
        if (imp.getStackSize() == 1) {
            this.interp.error("Stack required");
        }
        if (name.equals("setDimensions")) {
            this.setDimensions(imp);
        } else if (name.equals("setChannel")) {
            imp.setPosition((int)this.getArg(), imp.getSlice(), imp.getFrame());
        } else if (name.equals("setSlice")) {
            imp.setPosition(imp.getChannel(), (int)this.getArg(), imp.getFrame());
        } else if (name.equals("setFrame")) {
            imp.setPosition(imp.getChannel(), imp.getSlice(), (int)this.getArg());
        } else if (name.equals("setDisplayMode")) {
            this.setDisplayMode(imp, this.getStringArg());
        } else if (name.equals("getDisplayMode")) {
            this.getDisplayMode(imp);
        } else if (name.equals("setActiveChannels")) {
            this.setActiveChannels(imp, this.getStringArg());
        } else if (name.equals("getActiveChannels")) {
            this.getActiveChannels(imp);
        } else if (name.equals("toggleChannel")) {
            this.toggleChannel(imp, (int)this.getArg());
        } else if (name.equals("swap")) {
            this.swapStackImages(imp);
        } else if (name.equals("getStatistics")) {
            this.getStackStatistics(imp, true);
        } else {
            this.interp.error("Unrecognized Stack function");
        }
        return Double.NaN;
    }

    void getStackUnits(Calibration cal) {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable z = this.getNextVariable();
        Variable t = this.getNextVariable();
        Variable v = this.getLastVariable();
        x.setString(cal.getXUnit());
        y.setString(cal.getYUnit());
        z.setString(cal.getZUnit());
        t.setString(cal.getTimeUnit());
        v.setString(cal.getValueUnit());
    }

    void getStackStatistics(ImagePlus imp, boolean calibrated) {
        Variable count = this.getFirstVariable();
        Variable mean = null;
        Variable min = null;
        Variable max = null;
        Variable std = null;
        Variable hist = null;
        int params = 19;
        this.interp.getToken();
        int arg = 1;
        while (this.interp.token == 44) {
            switch (++arg) {
                case 2: {
                    mean = this.getVariable();
                    break;
                }
                case 3: {
                    min = this.getVariable();
                    break;
                }
                case 4: {
                    max = this.getVariable();
                    break;
                }
                case 5: {
                    std = this.getVariable();
                    params += 4;
                    break;
                }
                case 6: {
                    hist = this.getArrayVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        StackStatistics stats = new StackStatistics(imp);
        count.setValue(stats.pixelCount);
        if (mean != null) {
            mean.setValue(stats.mean);
        }
        if (min != null) {
            min.setValue(stats.min);
        }
        if (max != null) {
            max.setValue(stats.max);
        }
        if (std != null) {
            std.setValue(stats.stdDev);
        }
        if (hist != null) {
            int[] histogram = stats.histogram;
            int bins = histogram.length;
            Variable[] array = new Variable[bins];
            int hmax = 255;
            for (int i = 0; i <= hmax; ++i) {
                array[i] = new Variable(histogram[i]);
            }
            hist.setArray(array);
        }
    }

    void setActiveChannels(ImagePlus imp, String channels) {
        if (!imp.isComposite()) {
            this.interp.error("Composite image required");
        }
        boolean[] active = ((CompositeImage)imp).getActiveChannels();
        for (int i = 0; i < active.length; ++i) {
            boolean b = false;
            if (channels.length() > i && channels.charAt(i) == '1') {
                b = true;
            }
            active[i] = b;
        }
        imp.updateAndDraw();
        Channels.updateChannels();
    }

    void getActiveChannels(ImagePlus imp) {
        if (!imp.isComposite()) {
            this.interp.error("Composite image required");
        }
        boolean[] active = ((CompositeImage)imp).getActiveChannels();
        int n = active.length;
        char[] chars = new char[n];
        int nChannels = imp.getNChannels();
        for (int i = 0; i < n; ++i) {
            chars[i] = i < nChannels ? (active[i] ? 49 : 48) : 48;
        }
        Variable channels = this.getVariableArg();
        channels.setString(new String(chars));
    }

    void toggleChannel(ImagePlus imp, int channel) {
        boolean[] active;
        if (!imp.isComposite()) {
            this.interp.error("Composite image required");
        }
        if (channel < 1 || channel > imp.getNChannels()) {
            this.interp.error("Invalid channel: " + channel);
        }
        if (((CompositeImage)imp).getMode() != 1) {
            ((CompositeImage)imp).setMode(1);
        }
        boolean bl = !(active = ((CompositeImage)imp).getActiveChannels())[channel - 1];
        active[channel - 1] = bl;
        imp.updateAndDraw();
        Channels.updateChannels();
    }

    void setDisplayMode(ImagePlus imp, String mode) {
        mode = mode.toLowerCase(Locale.US);
        if (!imp.isComposite()) {
            this.interp.error("Composite image required");
        }
        int m = -1;
        if (mode.equals("composite")) {
            m = 1;
        } else if (mode.equals("color")) {
            m = 2;
        } else if (mode.startsWith("gray")) {
            m = 3;
        }
        if (m == -1) {
            this.interp.error("Invalid mode");
        }
        ((CompositeImage)imp).setMode(m);
        imp.updateAndDraw();
    }

    void swapStackImages(ImagePlus imp) {
        CompositeImage ci;
        int n1 = (int)this.getFirstArg();
        int n2 = (int)this.getLastArg();
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (n1 < 1 || n1 > size || n2 < 1 || n2 > size) {
            this.interp.error("Argument out of range");
        }
        Object pixels = stack.getPixels(n1);
        String label = stack.getSliceLabel(n1);
        stack.setPixels(stack.getPixels(n2), n1);
        stack.setSliceLabel(stack.getSliceLabel(n2), n1);
        stack.setPixels(pixels, n2);
        stack.setSliceLabel(label, n2);
        int current = imp.getCurrentSlice();
        if (imp.isComposite() && (ci = (CompositeImage)imp).getMode() == 1) {
            ci.reset();
            imp.updateAndDraw();
            imp.repaintWindow();
            return;
        }
        if (n1 == current || n2 == current) {
            imp.setStack(null, stack);
        }
    }

    void getDisplayMode(ImagePlus imp) {
        Variable v = this.getVariableArg();
        String mode = "";
        if (imp.isComposite()) {
            mode = ((CompositeImage)imp).getModeAsString();
        }
        v.setString(mode);
    }

    void getPosition(ImagePlus imp) {
        int t;
        int z;
        Variable channel = this.getFirstVariable();
        Variable slice = this.getNextVariable();
        Variable frame = this.getLastVariable();
        int c = imp.getChannel();
        if (c * (z = imp.getSlice()) * (t = imp.getFrame()) > imp.getStackSize()) {
            c = 1;
            z = imp.getCurrentSlice();
            t = 1;
        }
        channel.setValue(c);
        slice.setValue(z);
        frame.setValue(t);
    }

    void setPosition(ImagePlus img) {
        int channel = (int)this.getFirstArg();
        int slice = (int)this.getNextArg();
        int frame = (int)this.getLastArg();
        img.setPosition(channel, slice, frame);
    }

    void setDimensions(ImagePlus img) {
        int c = (int)this.getFirstArg();
        int z = (int)this.getNextArg();
        int t = (int)this.getLastArg();
        img.setDimensions(c, z, t);
        if (img.getWindow() == null) {
            img.setOpenAsHyperStack(true);
        }
    }

    void setTool() {
        this.interp.getLeftParen();
        if (this.isStringArg()) {
            boolean ok = IJ.setTool(this.getString());
            if (!ok) {
                this.interp.error("Unrecognized tool name");
            }
        } else {
            IJ.setTool((int)this.interp.getExpression());
        }
        this.interp.getRightParen();
    }

    String doToString() {
        String s = this.getFirstString();
        this.interp.getToken();
        if (this.interp.token == 44) {
            double value = Tools.parseDouble(s);
            s = IJ.d2s(value, (int)this.interp.getExpression());
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        return s;
    }

    double matches() {
        String regex;
        String str = this.getFirstString();
        boolean matches = str.matches(regex = this.getLastString());
        return matches ? 1.0 : 0.0;
    }

    void waitForUser() {
        if (waitForUserDialog != null && waitForUserDialog.isVisible()) {
            this.interp.error("Duplicate call");
        }
        String title = "Action Required";
        String text = "   Click \"OK\" to continue     ";
        if (this.interp.nextToken() == 40) {
            title = this.getFirstString();
            if (this.interp.nextToken() == 44) {
                text = this.getLastString();
            } else {
                text = title;
                title = "Action Required";
                this.interp.getRightParen();
            }
        }
        waitForUserDialog = new WaitForUserDialog(title, text);
        Interpreter instance = Interpreter.getInstance();
        waitForUserDialog.show();
        Interpreter.setInstance(instance);
        if (waitForUserDialog.escPressed()) {
            throw new RuntimeException("Macro canceled");
        }
    }

    void abortDialog() {
        if (waitForUserDialog != null && waitForUserDialog.isVisible()) {
            waitForUserDialog.close();
        }
    }

    double getStringWidth() {
        this.resetImage();
        ImageProcessor ip = this.getProcessor();
        this.setFont(ip);
        return ip.getStringWidth(this.getStringArg());
    }

    String doList() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        String value = null;
        String name = this.interp.tokenString;
        if (name.equals("get")) {
            value = this.props.getProperty(this.getStringArg());
            value = value != null ? value : "";
        } else if (name.equals("getValue")) {
            value = this.props.getProperty(this.getStringArg());
            if (value == null) {
                this.interp.error("Value not found");
            }
        } else if (name.equals("set") || name.equals("add") || name.equals("put")) {
            this.props.setProperty(this.getFirstString(), this.getLastString());
        } else if (name.equals("clear") || name.equals("reset")) {
            this.interp.getParens();
            this.props.clear();
        } else if (name.equals("setList")) {
            this.setProperties();
        } else if (name.equals("getList")) {
            value = this.getProperties();
        } else if (name.equals("size") || name.equals("getSize")) {
            this.interp.getParens();
            value = "" + this.props.size();
        } else if (name.equals("setMeasurements")) {
            this.setMeasurements();
        } else if (name.equals("setCommands")) {
            this.setCommands();
        } else {
            this.interp.error("Unrecognized List function");
        }
        return value;
    }

    void setCommands() {
        this.interp.getParens();
        Hashtable commands = Menus.getCommands();
        this.props = new Properties();
        Enumeration en = commands.keys();
        while (en.hasMoreElements()) {
            String command = (String)en.nextElement();
            this.props.setProperty(command, (String)commands.get(command));
        }
    }

    void setMeasurements() {
        this.interp.getParens();
        this.props.clear();
        ImagePlus imp = this.getImage();
        int measurements = 1043199;
        ImageStatistics stats = imp.getStatistics(measurements);
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = new Analyzer(imp, measurements, rt);
        analyzer.saveResults(stats, imp.getRoi());
        for (int i = 0; i <= rt.getLastColumn(); ++i) {
            if (!rt.columnExists(i)) continue;
            String name = rt.getColumnHeading(i);
            String value = "" + rt.getValueAsDouble(i, 0);
            this.props.setProperty(name, value);
        }
    }

    void setProperties() {
        String list = this.getStringArg();
        this.props.clear();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(list.getBytes("utf-8"));
            this.props.load(is);
        }
        catch (Exception e) {
            this.interp.error("" + e);
        }
    }

    String getProperties() {
        this.interp.getParens();
        Vector<Object> v = new Vector<Object>();
        Enumeration<Object> en = this.props.keys();
        while (en.hasMoreElements()) {
            v.addElement(en.nextElement());
        }
        Object[] keys = new String[v.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (String)v.elementAt(i);
        }
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append((String)keys[i]);
            sb.append("=");
            sb.append(this.props.get(keys[i]));
            sb.append("\n");
        }
        return sb.toString();
    }

    void makePoint() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getLastArg();
        IJ.makePoint(x, y);
        this.resetImage();
    }

    void makeText() {
        boolean nullFont;
        String text = this.getFirstString();
        int x = (int)this.getNextArg();
        int y = (int)this.getLastArg();
        ImagePlus imp = this.getImage();
        Font font = this.font;
        boolean bl = nullFont = font == null;
        if (nullFont) {
            font = imp.getProcessor().getFont();
        }
        TextRoi roi = new TextRoi(x, y, text, font);
        if (!nullFont) {
            roi.setAntialiased(this.antialiasedText);
        }
        imp.setRoi(roi);
    }

    void makeEllipse() {
        ImagePlus imp = this.getImage();
        Roi previousRoi = imp.getRoi();
        if (this.shiftKeyDown || this.altKeyDown) {
            imp.saveRoi();
        }
        double x1 = this.getFirstArg();
        double y1 = this.getNextArg();
        double x2 = this.getNextArg();
        double y2 = this.getNextArg();
        double aspectRatio = this.getLastArg();
        EllipseRoi roi = new EllipseRoi(x1, y1, x2, y2, aspectRatio);
        imp.setRoi(roi);
        if (previousRoi != null && roi != null) {
            this.updateRoi(roi);
        }
        this.resetImage();
    }

    double fit() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137) {
            this.interp.error("Function name expected: ");
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        if ((name = this.interp.tokenString).equals("doFit")) {
            return this.fitCurve();
        }
        if (name.equals("getEquation")) {
            return this.getEquation();
        }
        if (name.equals("nEquations")) {
            this.interp.getParens();
            return CurveFitter.fitList.length;
        }
        if (name.equals("showDialog")) {
            this.showFitDialog = true;
            return Double.NaN;
        }
        if (name.equals("logResults")) {
            this.logFitResults = true;
            return Double.NaN;
        }
        if (this.fitter == null) {
            this.interp.error("No fit");
        }
        if (name.equals("f")) {
            return this.fitter.f(this.fitter.getParams(), this.getArg());
        }
        if (name.equals("plot")) {
            this.interp.getParens();
            Fitter.plot(this.fitter);
            return Double.NaN;
        }
        if (name.equals("nParams")) {
            this.interp.getParens();
            return this.fitter.getNumParams();
        }
        if (name.equals("p")) {
            int index = (int)this.getArg();
            this.checkIndex(index, 0, this.fitter.getNumParams() - 1);
            double[] p = this.fitter.getParams();
            return index < p.length ? p[index] : Double.NaN;
        }
        if (name.equals("rSquared")) {
            this.interp.getParens();
            return this.fitter.getRSquared();
        }
        return Double.NaN;
    }

    double fitCurve() {
        this.interp.getLeftParen();
        int fit = -1;
        String name = null;
        double[] initialValues = null;
        if (this.isStringArg()) {
            boolean isCustom;
            name = this.getString().toLowerCase(Locale.US);
            String[] list = CurveFitter.fitList;
            for (int i = 0; i < list.length; ++i) {
                if (!name.equals(list[i].toLowerCase(Locale.US))) continue;
                fit = i;
                break;
            }
            boolean bl = isCustom = name.indexOf("y=") != -1 || name.indexOf("y =") != -1;
            if (fit == -1 && !isCustom) {
                this.interp.error("Unrecognized fit");
            }
        } else {
            fit = (int)this.interp.getExpression();
        }
        double[] x = this.getNextArray();
        this.interp.getComma();
        double[] y = this.getNumericArray();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            initialValues = this.getNumericArray();
        }
        this.interp.getRightParen();
        if (x.length != y.length) {
            this.interp.error("Arrays not same length");
        }
        if (x.length == 0) {
            this.interp.error("Zero length array");
        }
        this.fitter = new CurveFitter(x, y);
        this.fitter.setStatusAndEsc(null, true);
        if (fit == -1 && name != null) {
            Interpreter instance = Interpreter.getInstance();
            int params = this.fitter.doCustomFit(name, initialValues, this.showFitDialog);
            Interpreter.instance = instance;
            if (params == 0) {
                this.interp.error("Invalid custom function");
            }
        } else {
            this.fitter.doFit(fit, this.showFitDialog);
        }
        if (this.logFitResults) {
            IJ.log(this.fitter.getResultString());
            this.logFitResults = false;
        }
        this.showFitDialog = false;
        return Double.NaN;
    }

    double getEquation() {
        int index = (int)this.getFirstArg();
        Variable name = this.getNextVariable();
        Variable formula = this.getLastVariable();
        this.checkIndex(index, 0, CurveFitter.fitList.length - 1);
        name.setString(CurveFitter.fitList[index]);
        formula.setString(CurveFitter.fList[index]);
        return Double.NaN;
    }

    void setMinAndMax() {
        double min = this.getFirstArg();
        double max = this.getNextArg();
        int channels = 7;
        if (this.interp.nextToken() == 44) {
            channels = (int)this.getLastArg();
            if (this.getImage().getBitDepth() != 24) {
                this.interp.error("RGB image required");
            }
        } else {
            this.interp.getRightParen();
        }
        IJ.setMinAndMax(min, max, channels);
        this.resetImage();
    }

    String debug() {
        String arg = "break";
        if (this.interp.nextToken() == 40) {
            arg = this.getStringArg().toLowerCase(Locale.US);
        } else {
            this.interp.getParens();
        }
        if (arg.equals("conditional")) {
            if (IJ.debugMode) {
                arg = "break";
            } else {
                return null;
            }
        }
        if (this.interp.editor == null && !arg.equals("throw") && !arg.equals("dump")) {
            Editor ed = Editor.getInstance();
            if (ed == null) {
                this.interp.error("Macro editor not available");
            } else {
                this.interp.setEditor(ed);
            }
        }
        if (arg.equals("run")) {
            this.interp.setDebugMode(4);
        } else if (arg.equals("break")) {
            this.interp.setDebugMode(1);
        } else if (arg.equals("trace")) {
            this.interp.setDebugMode(2);
        } else if (arg.indexOf("fast") != -1) {
            this.interp.setDebugMode(3);
        } else if (arg.equals("dump")) {
            this.interp.dump();
        } else {
            if (arg.indexOf("throw") != -1) {
                throw new IllegalArgumentException();
            }
            this.interp.error("Argument must be 'run', 'break', 'trace', 'fast-trace' or 'dump'");
        }
        IJ.setKeyUp(-1);
        return null;
    }

    Variable[] doArray() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 134) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("copy")) {
            return this.copyArray();
        }
        if (name.equals("trim")) {
            return this.trimArray();
        }
        if (name.equals("sort")) {
            return this.sortArray();
        }
        if (name.equals("rankPositions")) {
            return this.getRankPositions();
        }
        if (name.equals("getStatistics")) {
            return this.getArrayStatistics();
        }
        if (name.equals("fill")) {
            return this.fillArray();
        }
        if (name.equals("reverse") || name.equals("invert")) {
            return this.reverseArray();
        }
        if (name.equals("concat")) {
            return this.concatArray();
        }
        if (name.equals("slice")) {
            return this.sliceArray();
        }
        if (name.equals("print")) {
            return this.printArray();
        }
        if (name.equals("resample")) {
            return this.resampleArray();
        }
        if (name.equals("findMaxima")) {
            return this.findArrayMaxima(false);
        }
        if (name.equals("findMinima")) {
            return this.findArrayMaxima(true);
        }
        if (name.equals("show")) {
            return this.showArray();
        }
        this.interp.error("Unrecognized Array function");
        return null;
    }

    Variable[] printArray() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        this.interp.getRightParen();
        int len = a.length;
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            String s = a[i].getString();
            if (s == null) {
                double v = a[i].getValue();
                s = (double)((int)v) == v ? IJ.d2s(v, 0) : ResultsTable.d2s(v, 4);
            }
            sb.append(s);
            if (i == len - 1) continue;
            sb.append(", ");
        }
        IJ.log(sb.toString());
        return null;
    }

    Variable[] concatArray() {
        this.interp.getLeftParen();
        ArrayList<Variable> list = new ArrayList<Variable>();
        int len = 0;
        do {
            Variable v;
            if (this.isArrayArg()) {
                Variable[] a = this.getArray();
                for (int i = 0; i < a.length; ++i) {
                    list.add((Variable)a[i].clone());
                    ++len;
                }
            } else if (this.isStringArg()) {
                v = new Variable();
                v.setString(this.getString());
                list.add(v);
                ++len;
            } else {
                v = new Variable();
                v.setValue(this.interp.getExpression());
                list.add(v);
                ++len;
            }
            this.interp.getToken();
        } while (this.interp.token == 44);
        Variable[] a2 = new Variable[len];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            Variable v = (Variable)list.get(i);
            a2[index++] = v;
        }
        return a2;
    }

    Variable[] sliceArray() {
        int len2;
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        int len = a.length;
        int i1 = (int)this.getNextArg();
        int i2 = len;
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            i2 = (int)this.interp.getExpression();
        }
        if (i1 < 0) {
            this.interp.error("Invalid argument");
        }
        if (i2 > len) {
            i2 = len;
        }
        if ((len2 = i2 - i1) < 0) {
            len2 = 0;
        }
        if (len2 > len) {
            len2 = len;
        }
        this.interp.getRightParen();
        Variable[] a2 = new Variable[len2];
        for (int i = 0; i < len2; ++i) {
            a2[i] = (Variable)a[i1++].clone();
        }
        return a2;
    }

    Variable[] copyArray() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        this.interp.getRightParen();
        return this.duplicate(a);
    }

    Variable[] duplicate(Variable[] a1) {
        Variable[] a2 = new Variable[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            a2[i] = (Variable)a1[i].clone();
        }
        return a2;
    }

    Variable[] trimArray() {
        this.interp.getLeftParen();
        Variable[] a1 = this.getArray();
        int len = a1.length;
        int size = (int)this.getLastArg();
        if (size < 0) {
            size = 0;
        }
        if (size > len) {
            size = len;
        }
        Variable[] a2 = new Variable[size];
        for (int i = 0; i < size; ++i) {
            a2[i] = (Variable)a1[i].clone();
        }
        return a2;
    }

    Variable[] sortArray() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        this.interp.getRightParen();
        int len = a.length;
        int nNumbers = 0;
        for (int i = 0; i < len; ++i) {
            if (a[i].getString() != null) continue;
            ++nNumbers;
        }
        if (nNumbers == len) {
            int i;
            double[] d = new double[len];
            for (i = 0; i < len; ++i) {
                d[i] = a[i].getValue();
            }
            Arrays.sort(d);
            for (i = 0; i < len; ++i) {
                a[i].setValue(d[i]);
            }
        } else if (nNumbers == 0) {
            int i;
            String[] s = new String[len];
            for (i = 0; i < len; ++i) {
                s[i] = a[i].getString();
            }
            Arrays.sort(s, String.CASE_INSENSITIVE_ORDER);
            for (i = 0; i < len; ++i) {
                a[i].setString(s[i]);
            }
        } else {
            this.interp.error("Mixed strings and numbers");
        }
        return a;
    }

    Variable[] getRankPositions() {
        int[] indexes;
        int i;
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        this.interp.getRightParen();
        int len = a.length;
        int nNumbers = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (a[i2].getString() != null) continue;
            ++nNumbers;
        }
        if (nNumbers != len && nNumbers != 0) {
            this.interp.error("Mixed strings and numbers");
            return a;
        }
        Variable[] varArray = new Variable[len];
        if (nNumbers == len) {
            double[] doubles = new double[len];
            for (i = 0; i < len; ++i) {
                doubles[i] = a[i].getValue();
            }
            indexes = Tools.rank(doubles);
        } else {
            String[] strings = new String[len];
            for (i = 0; i < len; ++i) {
                strings[i] = a[i].getString();
            }
            indexes = Tools.rank(strings);
        }
        for (int i3 = 0; i3 < len; ++i3) {
            varArray[i3] = new Variable(indexes[i3]);
        }
        return varArray;
    }

    Variable[] getArrayStatistics() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        Variable minv = this.getNextVariable();
        Variable maxv = null;
        Variable mean = null;
        Variable std = null;
        this.interp.getToken();
        int arg = 1;
        while (this.interp.token == 44) {
            switch (++arg) {
                case 2: {
                    maxv = this.getVariable();
                    break;
                }
                case 3: {
                    mean = this.getVariable();
                    break;
                }
                case 4: {
                    std = this.getVariable();
                    break;
                }
                default: {
                    this.interp.error("')' expected");
                }
            }
            this.interp.getToken();
        }
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        int n = a.length;
        double sum = 0.0;
        double sum2 = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double value = a[i].getValue();
            sum += value;
            sum2 += value * value;
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        minv.setValue(min);
        if (maxv != null) {
            maxv.setValue(max);
        }
        if (mean != null) {
            mean.setValue(sum / (double)n);
        }
        if (std != null) {
            double stdDev = ((double)n * sum2 - sum * sum) / (double)n;
            stdDev = Math.sqrt(stdDev / ((double)n - 1.0));
            std.setValue(stdDev);
        }
        return a;
    }

    Variable[] fillArray() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        double v = this.getLastArg();
        for (int i = 0; i < a.length; ++i) {
            a[i].setValue(v);
        }
        return a;
    }

    Variable[] resampleArray() {
        this.interp.getLeftParen();
        Variable[] a1 = this.getArray();
        int len1 = a1.length;
        int len2 = (int)this.getLastArg();
        if (len2 <= 0) {
            this.interp.error("Length<=0");
        }
        double[] d1 = new double[len1];
        for (int i = 0; i < len1; ++i) {
            d1[i] = a1[i].getValue();
        }
        double[] d2 = Functions.resampleArray(d1, len2);
        Variable[] a2 = new Variable[len2];
        for (int i = 0; i < len2; ++i) {
            a2[i] = new Variable(d2[i]);
        }
        return a2;
    }

    private static double[] resampleArray(double[] y1, int len2) {
        int jj;
        int len1 = y1.length;
        double factor = (double)(len2 - 1) / (double)(len1 - 1);
        double[] y2 = new double[len2];
        double[] f1 = new double[len1];
        double[] f2 = new double[len2];
        for (jj = 0; jj < len1; ++jj) {
            f1[jj] = (double)jj * factor;
        }
        for (jj = 0; jj < len2; ++jj) {
            f2[jj] = (double)jj / factor;
        }
        for (jj = 0; jj < len2 - 1; ++jj) {
            double value;
            double pos = f2[jj];
            int leftPos = (int)Math.floor(pos);
            int rightPos = (int)Math.floor(pos) + 1;
            double fraction = pos - Math.floor(pos);
            y2[jj] = value = y1[leftPos] + fraction * (y1[rightPos] - y1[leftPos]);
        }
        y2[len2 - 1] = y1[len1 - 1];
        return y2;
    }

    Variable[] reverseArray() {
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        this.interp.getRightParen();
        int n = a.length;
        for (int i = 0; i < n / 2; ++i) {
            Variable temp = a[i];
            a[i] = a[n - i - 1];
            a[n - i - 1] = temp;
        }
        return a;
    }

    Variable[] findArrayMaxima(boolean minima) {
        boolean excludeOnEdges = false;
        this.interp.getLeftParen();
        Variable[] a = this.getArray();
        double tolerance = this.getNextArg();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            double arg = this.interp.getBooleanExpression();
            this.interp.checkBoolean(arg);
            excludeOnEdges = arg != 0.0;
        }
        this.interp.getRightParen();
        int n = a.length;
        double[] d = new double[n];
        for (int i = 0; i < n; ++i) {
            d[i] = a[i].getValue();
        }
        int[] maxima = null;
        maxima = minima ? MaximumFinder.findMinima(d, tolerance, excludeOnEdges) : MaximumFinder.findMaxima(d, tolerance, excludeOnEdges);
        int n2 = maxima.length;
        Variable[] a2 = new Variable[n2];
        for (int i = 0; i < n2; ++i) {
            a2[i] = new Variable(maxima[i]);
        }
        return a2;
    }

    Variable[] showArray() {
        int n;
        int maxLength = 0;
        String title = "Arrays";
        ArrayList<Variable[]> arrays = new ArrayList<Variable[]>();
        ArrayList<String> names = new ArrayList<String>();
        this.interp.getLeftParen();
        do {
            if (this.isStringArg() && !this.isArrayArg()) {
                title = this.getString();
            } else {
                int symbolTableAddress = this.pgm.code[this.interp.pc + 1] >> 12;
                names.add(this.pgm.table[symbolTableAddress].str);
                Variable[] a = this.getArray();
                arrays.add(a);
                if (a.length > maxLength) {
                    maxLength = a.length;
                }
            }
            this.interp.getToken();
        } while (this.interp.token == 44);
        if (this.interp.token != 41) {
            this.interp.error("')' expected");
        }
        if ((n = arrays.size()) == 1) {
            if (title.equals("Arrays")) {
                title = (String)names.get(0);
            }
            names.set(0, "Value");
        }
        ResultsTable rt = new ResultsTable();
        boolean showRowNumbers = false;
        int openParenIndex = title.indexOf("(");
        if (openParenIndex >= 0) {
            String options = title.substring(openParenIndex, title.length());
            title = title.substring(0, openParenIndex);
            title = title.trim();
            boolean bl = showRowNumbers = options.contains("row") || options.contains("1");
            if (!showRowNumbers && options.contains("index")) {
                for (int i = 0; i < maxLength; ++i) {
                    rt.setValue("Index", i, "" + i);
                }
            }
        }
        if (!showRowNumbers) {
            rt.showRowNumbers(false);
        }
        for (int arr = 0; arr < n; ++arr) {
            Variable[] a = (Variable[])arrays.get(arr);
            String heading = (String)names.get(arr);
            for (int i = 0; i < maxLength; ++i) {
                if (i >= a.length) {
                    rt.setValue(heading, i, "");
                    continue;
                }
                String s = a[i].getString();
                if (s != null) {
                    rt.setValue(heading, i, s);
                    continue;
                }
                rt.setValue(heading, i, a[i].getValue());
            }
        }
        rt.show(title);
        return null;
    }

    double charCodeAt() {
        String str = this.getFirstString();
        int index = (int)this.getLastArg();
        this.checkIndex(index, 0, str.length() - 1);
        return str.charAt(index);
    }

    void doWand() {
        int x = (int)this.getFirstArg();
        int y = (int)this.getNextArg();
        double tolerance = 0.0;
        String mode = null;
        if (this.interp.nextToken() == 44) {
            tolerance = this.getNextArg();
            mode = this.getNextString();
        }
        this.interp.getRightParen();
        IJ.doWand(x, y, tolerance, mode);
        this.resetImage();
    }

    private String ijCall() {
        String name;
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 135) {
            this.interp.error("Function name expected: ");
        }
        if ((name = this.interp.tokenString).equals("pad")) {
            return IJ.pad((int)this.getFirstArg(), (int)this.getLastArg());
        }
        if (name.equals("deleteRows")) {
            IJ.deleteRows((int)this.getFirstArg(), (int)this.getLastArg());
        } else if (name.equals("log")) {
            IJ.log(this.getStringArg());
        } else {
            if (name.equals("freeMemory")) {
                this.interp.getParens();
                return IJ.freeMemory();
            }
            if (name.equals("currentMemory")) {
                this.interp.getParens();
                return "" + IJ.currentMemory();
            }
            if (name.equals("maxMemory")) {
                this.interp.getParens();
                return "" + IJ.maxMemory();
            }
            if (name.equals("getToolName")) {
                this.interp.getParens();
                return "" + IJ.getToolName();
            }
            if (name.equals("redirectErrorMessages")) {
                this.interp.getParens();
                IJ.redirectErrorMessages();
                return null;
            }
            if (name.equals("renameResults")) {
                this.renameResults();
            } else {
                if (name.equals("getFullVersion")) {
                    this.interp.getParens();
                    return "" + IJ.getFullVersion();
                }
                this.interp.error("Unrecognized IJ function name");
            }
        }
        return null;
    }

    private void renameResults() {
        String arg1 = this.getFirstString();
        String arg2 = null;
        if (this.interp.nextToken() == 41) {
            this.interp.getRightParen();
        } else {
            arg2 = this.getLastString();
        }
        if (this.resultsPending) {
            ResultsTable rt = Analyzer.getResultsTable();
            if (rt != null && rt.getCounter() > 0) {
                rt.show("Results");
            }
            this.resultsPending = false;
        }
        if (arg2 != null) {
            IJ.renameResults(arg1, arg2);
        } else {
            IJ.renameResults(arg1);
        }
    }

    double overlay() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129 && this.interp.token != 137 && this.interp.token != 134 && this.interp.token != 138) {
            this.interp.error("Function name expected: ");
        }
        String name = this.interp.tokenString;
        ImagePlus imp = this.getImage();
        if (name.equals("lineTo")) {
            return this.overlayLineTo();
        }
        if (name.equals("moveTo")) {
            return this.overlayMoveTo();
        }
        if (name.equals("drawLine")) {
            return this.overlayDrawLine();
        }
        if (name.equals("drawRect")) {
            return this.overlayDrawRectOrEllipse(imp, false);
        }
        if (name.equals("drawEllipse")) {
            return this.overlayDrawRectOrEllipse(imp, true);
        }
        if (name.equals("drawString")) {
            return this.overlayDrawString(imp);
        }
        if (name.equals("add")) {
            return this.addDrawing(imp);
        }
        if (name.equals("show")) {
            return this.showOverlay(imp);
        }
        if (name.equals("hide")) {
            return this.hideOverlay(imp);
        }
        if (name.equals("remove")) {
            return this.removeOverlay(imp);
        }
        if (name.equals("clear")) {
            return this.clearOverlay(imp);
        }
        if (name.equals("paste")) {
            this.interp.getParens();
            if (this.overlayClipboard == null) {
                this.interp.error("Overlay clipboard empty");
            }
            this.getImage().setOverlay(this.overlayClipboard);
            return Double.NaN;
        }
        if (name.equals("drawLabels")) {
            this.overlayDrawLabels = this.getBooleanArg();
            Overlay overlay = imp.getOverlay();
            if (overlay != null) {
                overlay.drawLabels(this.overlayDrawLabels);
                imp.draw();
            }
            return Double.NaN;
        }
        Overlay overlay = imp.getOverlay();
        if (overlay == null && name.equals("size")) {
            return 0.0;
        }
        if (name.equals("hidden")) {
            return overlay != null && imp.getHideOverlay() ? 1.0 : 0.0;
        }
        if (name.equals("addSelection")) {
            return this.overlayAddSelection(imp, overlay);
        }
        if (name.equals("setPosition")) {
            return this.overlaySetPosition(overlay);
        }
        if (name.equals("setFillColor")) {
            return this.overlaySetFillColor(overlay);
        }
        if (overlay == null) {
            this.interp.error("No overlay");
        }
        int size = overlay.size();
        if (name.equals("size") || name.equals("getSize")) {
            return size;
        }
        if (name.equals("copy")) {
            this.interp.getParens();
            this.overlayClipboard = this.getImage().getOverlay();
            return Double.NaN;
        }
        if (name.equals("removeSelection") || name.equals("removeRoi")) {
            int index = (int)this.getArg();
            this.checkIndex(index, 0, size - 1);
            overlay.remove(index);
            imp.draw();
            return Double.NaN;
        }
        if (name.equals("activateSelection")) {
            int index = (int)this.getArg();
            this.checkIndex(index, 0, size - 1);
            Roi roi = overlay.get(index);
            if (imp.getStackSize() > 1) {
                if (imp.isHyperStack()) {
                    int c = roi.getCPosition();
                    int z = roi.getZPosition();
                    int t = roi.getTPosition();
                    if (c > 0 || z > 0 || t > 0) {
                        c = c > 0 ? c : imp.getChannel();
                        z = z > 0 ? z : imp.getSlice();
                        t = t > 0 ? t : imp.getFrame();
                        imp.setPosition(c, z, t);
                    }
                } else if (roi.getPosition() > 0) {
                    imp.setSlice(roi.getPosition());
                }
            }
            imp.setRoi(roi, !Interpreter.isBatchMode());
            return Double.NaN;
        }
        if (name.equals("moveSelection")) {
            int index = (int)this.getFirstArg();
            int x = (int)this.getNextArg();
            int y = (int)this.getLastArg();
            this.checkIndex(index, 0, size - 1);
            Roi roi = overlay.get(index);
            roi.setLocation(x, y);
            imp.draw();
            return Double.NaN;
        }
        this.interp.error("Unrecognized function name");
        return Double.NaN;
    }

    double overlayAddSelection(ImagePlus imp, Overlay overlay) {
        Roi roi;
        String strokeColor = null;
        double strokeWidth = Double.NaN;
        String fillColor = null;
        if (this.interp.nextToken() == 40) {
            this.interp.getLeftParen();
            if (this.isStringArg()) {
                strokeColor = this.getString();
                if (this.interp.nextToken() == 44) {
                    this.interp.getComma();
                    strokeWidth = this.interp.getExpression();
                    if (this.interp.nextToken() == 44) {
                        this.interp.getComma();
                        fillColor = this.interp.getString();
                    }
                }
            }
            this.interp.getRightParen();
        }
        if ((roi = imp.getRoi()) == null) {
            this.interp.error("No selection");
        }
        if (overlay == null) {
            overlay = new Overlay();
        }
        if (strokeColor != null && !strokeColor.equals("")) {
            roi.setFillColor(null);
            roi.setStrokeColor(Colors.decode(strokeColor, Color.black));
        }
        if (!Double.isNaN(strokeWidth)) {
            roi.setStrokeWidth(strokeWidth);
        }
        if (fillColor != null && !fillColor.equals("")) {
            roi.setFillColor(Colors.decode(fillColor, Color.black));
        }
        overlay.add(roi);
        imp.setOverlay(overlay);
        return Double.NaN;
    }

    double overlaySetPosition(Overlay overlay) {
        int size;
        int c = 0;
        int z = 0;
        int t = 0;
        int nargs = 1;
        int n = (int)this.getFirstArg();
        if (this.interp.nextToken() == 44) {
            nargs = 3;
            c = n;
            z = (int)this.getNextArg();
            t = (int)this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        if (overlay == null) {
            overlay = this.offscreenOverlay;
        }
        if (overlay == null) {
            this.interp.error("No overlay");
        }
        if ((size = overlay.size()) == 0) {
            return Double.NaN;
        }
        if (nargs == 1) {
            overlay.get(size - 1).setPosition(n);
        } else if (nargs == 3) {
            overlay.get(size - 1).setPosition(c, z, t);
        }
        return Double.NaN;
    }

    double overlaySetFillColor(Overlay overlay) {
        int size;
        this.interp.getLeftParen();
        Color color = this.getColor();
        this.interp.getRightParen();
        if (overlay == null) {
            overlay = this.offscreenOverlay;
        }
        if (overlay == null) {
            this.interp.error("No overlay");
        }
        if ((size = overlay.size()) > 0) {
            overlay.get(size - 1).setFillColor(color);
        }
        return Double.NaN;
    }

    double overlayMoveTo() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float x = (float)this.interp.getExpression();
        this.interp.getComma();
        float y = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.moveTo(x, y);
        return Double.NaN;
    }

    double overlayLineTo() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float x = (float)this.interp.getExpression();
        this.interp.getComma();
        float y = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.lineTo(x, y);
        return Double.NaN;
    }

    double overlayDrawLine() {
        if (this.overlayPath == null) {
            this.overlayPath = new GeneralPath();
        }
        this.interp.getLeftParen();
        float x1 = (float)this.interp.getExpression();
        this.interp.getComma();
        float y1 = (float)this.interp.getExpression();
        this.interp.getComma();
        float x2 = (float)this.interp.getExpression();
        this.interp.getComma();
        float y2 = (float)this.interp.getExpression();
        this.interp.getRightParen();
        this.overlayPath.moveTo(x1, y1);
        this.overlayPath.lineTo(x2, y2);
        return Double.NaN;
    }

    double overlayDrawRectOrEllipse(ImagePlus imp, boolean ellipse) {
        this.addDrawingToOverlay(imp);
        float x = Math.round(this.getFirstArg());
        float y = Math.round(this.getNextArg());
        float w = Math.round(this.getNextArg());
        float h = Math.round(this.getLastArg());
        RectangularShape shape = null;
        shape = ellipse ? new Ellipse2D.Float(x, y, w, h) : new Rectangle2D.Float(x, y, w, h);
        ShapeRoi roi = new ShapeRoi(shape);
        this.addRoi(imp, roi);
        return Double.NaN;
    }

    double overlayDrawString(ImagePlus imp) {
        boolean nullFont;
        this.addDrawingToOverlay(imp);
        String text = this.getFirstString();
        int x = (int)this.getNextArg();
        int y = (int)this.getNextArg();
        double angle = 0.0;
        if (this.interp.nextToken() == 44) {
            angle = this.getLastArg();
        } else {
            this.interp.getRightParen();
        }
        Font font = this.font;
        boolean bl = nullFont = font == null;
        if (nullFont) {
            font = imp.getProcessor().getFont();
        }
        TextRoi roi = new TextRoi(text, (double)x, (double)y, font);
        if (!nullFont && !this.antialiasedText) {
            roi.setAntialiased(false);
        }
        roi.setAngle(angle);
        this.addRoi(imp, roi);
        return Double.NaN;
    }

    double addDrawing(ImagePlus imp) {
        this.interp.getParens();
        this.addDrawingToOverlay(imp);
        return Double.NaN;
    }

    void addDrawingToOverlay(ImagePlus imp) {
        if (this.overlayPath == null) {
            return;
        }
        ShapeRoi roi = new ShapeRoi(this.overlayPath);
        this.overlayPath = null;
        this.addRoi(imp, roi);
    }

    void addRoi(ImagePlus imp, Roi roi) {
        Overlay overlay = imp.getOverlay();
        if (overlay == null || overlay.size() == 0) {
            if (this.offscreenOverlay == null) {
                this.offscreenOverlay = new Overlay();
            }
            overlay = this.offscreenOverlay;
        }
        if (this.defaultColor != null) {
            roi.setStrokeColor(this.defaultColor);
        }
        roi.setLineWidth(this.getProcessor().getLineWidth());
        overlay.add(roi);
    }

    double showOverlay(ImagePlus imp) {
        this.interp.getParens();
        this.addDrawingToOverlay(imp);
        if (this.offscreenOverlay != null) {
            imp.setOverlay(this.offscreenOverlay);
            this.offscreenOverlay = null;
        } else {
            imp.setHideOverlay(false);
        }
        return Double.NaN;
    }

    double hideOverlay(ImagePlus imp) {
        this.interp.getParens();
        imp.setHideOverlay(true);
        return Double.NaN;
    }

    double removeOverlay(ImagePlus imp) {
        this.interp.getParens();
        imp.setOverlay(null);
        this.offscreenOverlay = null;
        return Double.NaN;
    }

    double clearOverlay(ImagePlus imp) {
        this.interp.getParens();
        this.offscreenOverlay = null;
        Overlay overlay = imp.getOverlay();
        if (overlay != null) {
            overlay.clear();
        }
        return Double.NaN;
    }

    final double selectionContains() {
        int x = (int)Math.round(this.getFirstArg());
        int y = (int)Math.round(this.getLastArg());
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("Selection required");
        }
        return roi.contains(x, y) ? 1.0 : 0.0;
    }

    void getDisplayedArea() {
        Variable x = this.getFirstVariable();
        Variable y = this.getNextVariable();
        Variable w = this.getNextVariable();
        Variable h = this.getLastVariable();
        ImagePlus imp = this.getImage();
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Rectangle r = ic.getSrcRect();
        x.setValue(r.x);
        y.setValue(r.y);
        w.setValue(r.width);
        h.setValue(r.height);
    }

    void toScaled() {
        ImagePlus imp = this.getImage();
        int height = imp.getHeight();
        Calibration cal = imp.getCalibration();
        this.interp.getLeftParen();
        if (this.isArrayArg()) {
            int i;
            Variable[] x = this.getArray();
            this.interp.getComma();
            Variable[] y = this.getArray();
            this.interp.getRightParen();
            for (i = 0; i < x.length; ++i) {
                x[i].setValue(cal.getX(x[i].getValue()));
            }
            for (i = 0; i < y.length; ++i) {
                y[i].setValue(cal.getY(y[i].getValue(), height));
            }
        } else {
            boolean twoArgs;
            Variable xv = this.getVariable();
            Variable yv = null;
            boolean bl = twoArgs = this.interp.nextToken() == 44;
            if (twoArgs) {
                this.interp.getComma();
                yv = this.getVariable();
            }
            this.interp.getRightParen();
            double x = xv.getValue();
            if (twoArgs) {
                double y = yv.getValue();
                xv.setValue(cal.getX(x));
                yv.setValue(cal.getY(y, height));
            } else {
                xv.setValue(x * cal.pixelWidth);
            }
        }
    }

    void toUnscaled() {
        ImagePlus imp = this.getImage();
        int height = imp.getHeight();
        Calibration cal = imp.getCalibration();
        this.interp.getLeftParen();
        if (this.isArrayArg()) {
            int i;
            Variable[] x = this.getArray();
            this.interp.getComma();
            Variable[] y = this.getArray();
            this.interp.getRightParen();
            for (i = 0; i < x.length; ++i) {
                x[i].setValue(cal.getRawX(x[i].getValue()));
            }
            for (i = 0; i < y.length; ++i) {
                y[i].setValue(cal.getRawY(y[i].getValue(), height));
            }
        } else {
            boolean twoArgs;
            Variable xv = this.getVariable();
            Variable yv = null;
            boolean bl = twoArgs = this.interp.nextToken() == 44;
            if (twoArgs) {
                this.interp.getComma();
                yv = this.getVariable();
            }
            this.interp.getRightParen();
            double x = xv.getValue();
            if (twoArgs) {
                double y = yv.getValue();
                xv.setValue(cal.getRawX(x));
                yv.setValue(cal.getRawY(y, height));
            } else {
                xv.setValue(x / cal.pixelWidth);
            }
        }
    }

    String doRoi() {
        this.interp.getToken();
        if (this.interp.token != 46) {
            this.interp.error("'.' expected");
        }
        this.interp.getToken();
        if (this.interp.token != 129) {
            this.interp.error("Function name expected: ");
        }
        String name = this.interp.tokenString;
        ImagePlus imp = this.getImage();
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.interp.error("No selection");
        }
        if (name.equals("getBounds")) {
            this.getBounds();
            return null;
        }
        if (name.equals("getDefaultColor")) {
            this.interp.getParens();
            Color color = Roi.getColor();
            return Colors.colorToString(color);
        }
        if (name.equals("getStrokeColor")) {
            this.interp.getParens();
            Color color = roi.getStrokeColor();
            return Colors.colorToString(color);
        }
        if (name.equals("getFillColor")) {
            this.interp.getParens();
            Color color = roi.getFillColor();
            return Colors.colorToString(color);
        }
        if (name.equals("getCoordinates")) {
            this.getCoordinates();
            return null;
        }
        if (name.equals("getName")) {
            this.interp.getParens();
            String roiName = roi.getName();
            return roiName != null ? roiName : "";
        }
        if (name.equals("getProperty")) {
            String property = roi.getProperty(this.getStringArg());
            return property != null ? property : "";
        }
        if (name.equals("getProperties")) {
            this.interp.getParens();
            String properties = roi.getProperties();
            return properties != null ? properties : "";
        }
        if (name.equals("setFillColor")) {
            roi.setFillColor(Colors.decode(this.getStringArg(), null));
            imp.draw();
            return null;
        }
        if (name.equals("move")) {
            this.setSelectionLocation();
            return null;
        }
        if (name.equals("setName")) {
            roi.setName(this.getStringArg());
            return null;
        }
        if (name.equals("setStrokeColor")) {
            roi.setStrokeColor(Colors.decode(this.getStringArg(), null));
            imp.draw();
            return null;
        }
        if (name.equals("setStrokeWidth")) {
            roi.setStrokeWidth(this.getArg());
            imp.draw();
            return null;
        }
        if (name.equals("setProperty")) {
            String value = "1";
            this.interp.getLeftParen();
            String key = this.getString();
            if (this.interp.nextToken() == 44) {
                this.interp.getComma();
                value = this.getString();
            }
            this.interp.getRightParen();
            roi.setProperty(key, value);
            return null;
        }
        if (name.equals("getType")) {
            this.interp.getParens();
            String type = roi.getTypeAsString();
            if (type.equals("Straight Line")) {
                type = "Line";
            }
            return type.toLowerCase(Locale.US);
        }
        this.interp.error("Unrecognized Roi function");
        return null;
    }
}

