/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.ZProjector;

public class GroupedZProjector
implements PlugIn {
    private static int method = 0;
    private int groupSize;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        int size = imp.getStackSize();
        if (size == 1) {
            IJ.error("Z Project", "This command requires a stack");
            return;
        }
        if (imp.isHyperStack()) {
            new ZProjector().run("");
            return;
        }
        if (!this.showDialog(imp)) {
            return;
        }
        ImagePlus imp2 = this.groupZProject(imp, method, this.groupSize);
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        cal.pixelDepth *= (double)this.groupSize;
        if (imp != null) {
            imp2.show();
        }
    }

    public ImagePlus groupZProject(ImagePlus imp, int method, int groupSize) {
        if (method < 0 || method >= ZProjector.METHODS.length) {
            return null;
        }
        imp.setDimensions(1, groupSize, imp.getStackSize() / groupSize);
        ZProjector zp = new ZProjector(imp);
        zp.setMethod(method);
        zp.setStartSlice(1);
        zp.setStopSlice(groupSize);
        zp.doHyperStackProjection(true);
        return zp.getProjection();
    }

    boolean showDialog(ImagePlus imp) {
        int size = imp.getStackSize();
        GenericDialog gd = new GenericDialog("Z Project");
        gd.addChoice("Projection method:", ZProjector.METHODS, ZProjector.METHODS[method]);
        gd.addNumericField("Group size:", size, 0);
        String factors = "Valid factors: ";
        int count = 0;
        for (int i = 1; i <= size && count < 10; ++i) {
            if (size % i != 0) continue;
            ++count;
            factors = factors + " " + i + ",";
        }
        gd.setInsets(10, 0, 0);
        gd.addMessage(factors + "...");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        method = gd.getNextChoiceIndex();
        this.groupSize = (int)gd.getNextNumber();
        if (this.groupSize < 1 || this.groupSize > size || size % this.groupSize != 0) {
            IJ.error("ZProject", "Group size must divide evenly into the stack size.");
            return false;
        }
        return true;
    }
}

