/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class Zoom
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        Point loc = ic.getCursorLoc();
        if (!ic.cursorOverImage()) {
            Rectangle srcRect = ic.getSrcRect();
            loc.x = srcRect.x + srcRect.width / 2;
            loc.y = srcRect.y + srcRect.height / 2;
        }
        int x = ic.screenX(loc.x);
        int y = ic.screenY(loc.y);
        if (arg.equals("in")) {
            ic.zoomIn(x, y);
            if (ic.getMagnification() <= 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("out")) {
            ic.zoomOut(x, y);
            if (ic.getMagnification() < 1.0) {
                imp.repaintWindow();
            }
        } else if (arg.equals("orig")) {
            ic.unzoom();
        } else if (arg.equals("100%")) {
            ic.zoom100Percent();
        } else if (arg.equals("to")) {
            this.zoomToSelection(imp, ic);
        } else if (arg.equals("set")) {
            this.setZoom(imp, ic);
        } else if (arg.equals("max")) {
            ImageWindow win = imp.getWindow();
            win.setBounds(win.getMaximumBounds());
            win.maximize();
        }
        if (arg.equals("scale")) {
            this.scaleToFit(imp);
        }
    }

    void zoomToSelection(ImagePlus imp, ImageCanvas ic) {
        Roi roi = imp.getRoi();
        ic.unzoom();
        if (roi == null) {
            return;
        }
        Rectangle w = imp.getWindow().getBounds();
        Rectangle r = roi.getBounds();
        double mag = ic.getMagnification();
        int marginw = (int)((double)w.width - mag * (double)imp.getWidth());
        int marginh = (int)((double)w.height - mag * (double)imp.getHeight());
        int x = r.x + r.width / 2;
        int y = r.y + r.height / 2;
        mag = ImageCanvas.getHigherZoomLevel(mag);
        while ((double)r.width * mag < (double)(w.width - marginw) && (double)r.height * mag < (double)(w.height - marginh)) {
            ic.zoomIn(ic.screenX(x), ic.screenY(y));
            double cmag = ic.getMagnification();
            if (cmag == 32.0) break;
            mag = ImageCanvas.getHigherZoomLevel(cmag);
            w = imp.getWindow().getBounds();
        }
    }

    void setZoom(ImagePlus imp, ImageCanvas ic) {
        boolean smallImage;
        int width = imp.getWidth();
        int height = imp.getHeight();
        int x = width / 2;
        int y = height / 2;
        Rectangle srcRect = ic.getSrcRect();
        Roi roi = imp.getRoi();
        boolean areaSelection = false;
        if (roi != null) {
            Rectangle bounds = roi.getBounds();
            x = bounds.x + bounds.width / 2;
            y = bounds.y + bounds.height / 2;
            areaSelection = roi.isArea();
            if (areaSelection) {
                srcRect = bounds;
            }
        }
        ImageWindow win = imp.getWindow();
        GenericDialog gd = new GenericDialog("Set Zoom");
        gd.addNumericField("Zoom:", ic.getMagnification() * 200.0, 0, 4, "%");
        gd.addNumericField("X center:", x, 0, 5, "");
        gd.addNumericField("Y center:", y, 0, 5, "");
        if (areaSelection) {
            gd.addNumericField("Width:", srcRect.width, 0, 5, "");
            gd.addNumericField("Height:", srcRect.height, 0, 5, "");
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double mag = gd.getNextNumber() / 100.0;
        x = (int)gd.getNextNumber();
        y = (int)gd.getNextNumber();
        int srcWidth = srcRect.width;
        int srcHeight = srcRect.height;
        if (areaSelection) {
            srcWidth = (int)gd.getNextNumber();
            srcHeight = (int)gd.getNextNumber();
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        String options = IJ.macroRunning() ? Macro.getOptions() : null;
        boolean legacyMacro = areaSelection && options != null && options.contains("x=") && !options.contains("width=");
        Rectangle bounds = GUI.getMaxWindowBounds();
        boolean bl = smallImage = mag > 1.0 && (double)width * mag < (double)bounds.width && (double)height * mag < (double)bounds.height;
        if ((areaSelection || smallImage || srcWidth != srcRect.width || srcHeight != srcRect.height) && !legacyMacro) {
            if (areaSelection && roi.getType() == 0) {
                imp.deleteRoi();
            }
            ic.setSourceRect(new Rectangle(x - srcWidth / 2, y - srcHeight / 2, srcWidth, srcHeight));
            ic.setMagnification(mag);
            Insets insets = win.getInsets();
            win.setSize((int)((double)srcWidth * mag + (double)insets.right + (double)insets.left + 10.0), (int)((double)srcHeight * mag + (double)insets.top + (double)insets.bottom + 10.0 + (double)win.getSliderHeight()));
            return;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y >= height) {
            y = height - 1;
        }
        if (mag <= 0.0) {
            mag = 1.0;
        }
        ic.setMagnification(mag);
        double newWidth = (double)width * mag;
        double newHeight = (double)height * mag;
        Dimension size = ic.getSize();
        if (newWidth >= (double)size.width && newHeight >= (double)size.height) {
            srcWidth = (int)Math.round((double)size.width / mag);
            srcHeight = (int)Math.round((double)size.height / mag);
            if ((int)((double)srcWidth * mag) < size.width) {
                ++srcWidth;
            }
            if ((int)((double)srcHeight * mag) < size.height) {
                ++srcHeight;
            }
            y -= srcHeight / 2;
            if ((x -= srcWidth / 2) + srcWidth > width) {
                x = width - srcWidth;
            }
            if (y + srcHeight > height) {
                y = height - srcHeight;
            }
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            ic.setSourceRect(new Rectangle(x, y, srcWidth, srcHeight));
        } else {
            srcWidth = width;
            srcHeight = height;
            ic.setSourceRect(new Rectangle(0, 0, srcWidth, srcHeight));
            ic.setDrawingSize((int)newWidth, (int)newHeight);
            win.pack();
        }
        ic.repaint();
    }

    private void scaleToFit(ImagePlus imp) {
        ImageCanvas ic = imp.getCanvas();
        if (ic == null) {
            return;
        }
        if (ic.getScaleToFit()) {
            ic.setScaleToFit(false);
            ic.unzoom();
            IJ.showStatus("Exiting scale to fit mode (resize with 'alt' key to scale to fit)");
        } else {
            ic.setScaleToFit(true);
            ic.fitToWindow();
            IJ.showStatus("Resize window to scale (use 'alt' key as shortcut)");
        }
    }
}

