/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib;

import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.RegistryHelper;
import net.infstudio.infinitylib.api.utils.NameFormatter;
import net.infstudio.infinitylib.common.registry.ContainerMeta;
import net.infstudio.infinitylib.common.registry.Namespace;
import net.infstudio.infinitylib.common.registry.NamespaceMakerComplex;
import net.infstudio.infinitylib.login.restriction.ModRestriction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonProxy {
    public Side getSide() {
        return Side.SERVER;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public boolean isSinglePlayer() {
        return Minecraft.func_71410_x().func_71356_B();
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    void preInit(FMLPreInitializationEvent event) {
        NamespaceMakerComplex maker = new NamespaceMakerComplex(RegistryHelper.INSTANCE.getAnnotationMap());
        ModRestriction.preInit(event);
        Iterator<ContainerMeta> itr = RegistryHelper.INSTANCE.getRegistryInfo();
        while (itr.hasNext()) {
            ContainerMeta meta = itr.next();
            RegistryHelper.INSTANCE.start(meta);
            HelperMod.LOG.info("Start to register [".concat(meta.modid).concat("] mod."));
            for (Class c : meta.getRawContainer()) {
                ImmutableSet<Namespace> cache = maker.make(c);
                if (cache == null) continue;
                meta.addUnregistered(cache);
            }
            RegistryHelper.INSTANCE.end();
        }
    }

    void init(FMLInitializationEvent event) {
        Iterator<ContainerMeta> itr = RegistryHelper.INSTANCE.getRegistryInfo();
        while (itr.hasNext()) {
            ContainerMeta meta = itr.next();
            RegistryHelper.INSTANCE.start(meta);
            this.register(meta);
            RegistryHelper.INSTANCE.end();
        }
    }

    protected void register(ContainerMeta meta) {
        for (Namespace namespace : meta.getUnregistered()) {
            String registerName;
            String unlocalizedName = registerName = NameFormatter.upperTo_(namespace.toString());
            namespace.getComponent().setUnlocalizedName(unlocalizedName);
            namespace.getComponent().register(registerName);
            if (!namespace.needRegOre()) continue;
            namespace.getComponent().registerOre(namespace.getOreName());
        }
    }
}

