/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.CommonProxy;
import net.infstudio.infinitylib.RegistryHelper;
import net.infstudio.infinitylib.api.utils.Environment;
import net.infstudio.infinitylib.common.registry.RegistryBufferManager;
import net.infstudio.infinitylib.entity.IPropertiesManager;
import net.infstudio.infinitylib.login.restriction.ModRestriction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="helper", name="Helper", version="beta 0.8", useMetadata=true, acceptedMinecraftVersions="[1.8.9]")
public class HelperMod {
    public static final String MODID = "helper";
    public static final String NAME = "Helper";
    public static final String VERSION = "beta 0.8";
    @Mod.Metadata(value="helper")
    public static ModMetadata metadata;
    @Mod.Instance(value="helper")
    public static HelperMod instance;
    public static Logger LOG;
    @SidedProxy(modId="helper", serverSide="CommonProxy", clientSide="ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        List<String> inputArguments = bean.getInputArguments();
        System.out.println(inputArguments);
        RegistryHelper.INSTANCE.container = Loader.instance().activeModContainer();
        RegistryBufferManager.instance().load(event.getASMHarvestedData());
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOG = event.getModLog();
        if (Environment.debug()) {
            LOG.info("Detected that this is a development environment. Debug mode on.");
        }
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        HelperMod.metadata.autogenerated = false;
        HelperMod.metadata.description = "A mod that can simplify the mod registrant.";
        HelperMod.metadata.url = "https://github.com/InfinityStudio/InfinityLib";
        HelperMod.metadata.authorList.add(0, "ci010");
        HelperMod.metadata.updateUrl = "https://github.com/InfinityStudio/InfinityLib/releases";
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void complete(FMLLoadCompleteEvent event) {
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
        RegistryHelper.INSTANCE.close();
    }

    @Mod.EventHandler
    void serverAboutStart(FMLServerAboutToStartEvent event) {
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (IPropertiesManager.enable()) {
            MinecraftServer.func_71276_C().func_82010_a((ITickable)IPropertiesManager.instance());
        }
        RegistryBufferManager.instance().invoke((FMLStateEvent)event);
    }

    @NetworkCheckHandler
    public boolean acceptModList(Map<String, String> modList, Side side) {
        return ModRestriction.acceptModList(modList, side);
    }
}

