/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.registry.components.ArgumentHelper;
import net.infstudio.infinitylib.api.sitting.Sitable;
import net.infstudio.infinitylib.api.utils.FMLLoadingUtil;
import net.infstudio.infinitylib.common.registry.ContainerMeta;
import net.infstudio.infinitylib.common.registry.Namespace;
import net.infstudio.infinitylib.common.registry.RegBlock;
import net.infstudio.infinitylib.common.registry.RegItem;
import net.infstudio.infinitylib.sitting.SitHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;

public enum RegistryHelper {
    INSTANCE;

    private Map<String, ContainerMeta> containerIdx = Maps.newHashMap();
    private Map<Class<? extends Annotation>, ArgumentHelper> annoMap = Maps.newHashMap();
    private String currentModid;
    ModContainer container;

    void track(ContainerMeta meta) {
        this.containerIdx.put(meta.modid, meta);
    }

    public void start(ContainerMeta meta) {
        this.currentModid = meta.modid;
        FMLLoadingUtil.setActiveContainer(FMLLoadingUtil.getModContainer(this.currentModid));
    }

    public void end() {
        FMLLoadingUtil.setActiveContainer(this.container);
        this.currentModid = this.container.getModId();
    }

    public String currentMod() {
        return this.currentModid;
    }

    public void setLang(String modid, String ... lang) {
        if (lang == null || lang.length == 0 || lang[0].equals("")) {
            lang = new String[]{"zh_CN", "en_US"};
        }
        if (!this.containerIdx.containsKey(modid)) {
            this.track(new ContainerMeta(modid).lang(true).langType(lang));
        } else {
            this.containerIdx.get(modid).lang(true).langType(lang);
        }
    }

    public void setModel(String modid) {
        if (!this.containerIdx.containsKey(modid)) {
            this.track(new ContainerMeta(modid).model(true));
        } else {
            this.containerIdx.get(modid).model(true);
        }
    }

    public void registerMod(String modid, Class<?> container) {
        if (!this.containerIdx.containsKey(modid)) {
            this.track(new ContainerMeta(modid).addRawContainer(container));
        } else {
            this.containerIdx.get(modid).addRawContainer(container);
        }
    }

    public void register(String modid, ImmutableSet set) {
        if (!this.containerIdx.containsKey(modid)) {
            this.track(new ContainerMeta(modid).addUnregistered((ImmutableSet<Namespace>)set));
        } else {
            this.containerIdx.get(modid).addUnregistered((ImmutableSet<Namespace>)set);
        }
    }

    public void registerBlock(String modid, Block block, String name) {
        this.registerBlock(modid, block, name, null);
    }

    public void registerBlock(String modid, Block block, String name, String ore) {
        ImmutableSet temp = ImmutableSet.of((Object)new Namespace(name, new RegBlock(block)).setOreName(ore));
        this.register(modid, temp);
    }

    public void registerItem(String modid, Item item, String name) {
        this.registerItem(modid, item, name, null);
    }

    public void registerItem(String modid, Item item, String name, String ore) {
        ImmutableSet temp = ImmutableSet.of((Object)new Namespace(name, new RegItem(item)).setOreName(ore));
        this.register(modid, temp);
    }

    public Map<Class<? extends Annotation>, ArgumentHelper> getAnnotationMap() {
        return ImmutableMap.copyOf(this.annoMap);
    }

    public Iterator<ContainerMeta> getRegistryInfo() {
        return this.containerIdx.values().iterator();
    }

    public Set<Field> parseContainer(Class<?> container) {
        HashSet temp = Sets.newHashSet();
        for (Field f : container.getFields()) {
            if (Modifier.isStatic(f.getModifiers())) {
                temp.add(f);
                continue;
            }
            HelperMod.LOG.info("The field {} in container {} is not static so that it won'registerInit be constructed and registered", new Object[]{f.getName(), container.getName()});
        }
        return temp;
    }

    public void registerSittableBlock(final Block block) {
        SitHandler.register(new Sitable(){

            @Override
            public Block sitableBlock() {
                return block;
            }

            @Override
            public Sitable.Situation getSituation() {
                return Sitable.DEFAULT;
            }
        });
    }

    public void registerAnnotation(Class<? extends Annotation> annotation, ArgumentHelper helper) {
        if (this.annoMap.containsKey(annotation)) {
            throw new IllegalArgumentException("The annotation has already been registerd!");
        }
        this.annoMap.put(annotation, helper);
    }

    public void register(Class<?> ... containers) {
        this.register(false, false, containers);
    }

    public void register(boolean ifGenerateLang, boolean ifGenerateModel, Class<?> ... containers) {
        String modid = Loader.instance().activeModContainer().getModId();
        ContainerMeta meta = new ContainerMeta(modid).lang(ifGenerateLang).model(ifGenerateModel);
        for (Class<?> container : containers) {
            meta.addRawContainer(container);
        }
        this.track(meta);
    }

    public void close() {
        if (Loader.instance().getLoaderState() == LoaderState.AVAILABLE) {
            this.containerIdx = null;
            this.annoMap = null;
        }
    }
}

