/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.coremod;

import com.google.common.collect.ImmutableList;
import net.infstudio.infinitylib.api.coremod.ClassPatch;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class Transformer
implements IClassTransformer {
    private ImmutableList<ClassPatch> lst;
    private boolean isObfscated;

    public Transformer() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.buildClassPatch((ImmutableList.Builder<ClassPatch>)builder);
        this.lst = builder.build();
    }

    protected abstract void buildClassPatch(ImmutableList.Builder<ClassPatch> var1);

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        this.isObfscated = !name.equals(transformedName);
        for (ClassPatch patch : this.lst) {
            if (!patch.patchClass().equals(transformedName)) continue;
            return this.handle(patch, bytes);
        }
        return bytes;
    }

    private byte[] handle(ClassPatch patch, byte[] original) {
        try {
            ClassWriter writer = new ClassWriter(3);
            new ClassReader(original).accept((ClassVisitor)patch.accept((ClassVisitor)writer), 0);
            return writer.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }
}

