/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.io.cache;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.infstudio.infinitylib.api.io.cache.CacheSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ImageCache {
    public static final ImageCache INSTANCE = new ImageCache();
    private Map<ResourceLocation, ITextureObject> mapTextureObjects = (Map)ReflectionHelper.getPrivateValue(TextureManager.class, (Object)Minecraft.func_71410_x().func_110434_K(), (String[])new String[]{"mapTextureObjects"});
    private TextureManager manager = Minecraft.func_71410_x().func_110434_K();
    private Set<ResourceLocation> loading = Sets.newHashSet();

    private ImageCache() {
    }

    public void cacheImage(final ResourceLocation location, URL url) {
        if (CacheSystem.INSTANCE.hasCached(location)) {
            return;
        }
        if (CacheSystem.INSTANCE.isPending(location)) {
            return;
        }
        if (this.loading.contains(location)) {
            return;
        }
        try {
            final ListenableFuture<File> cache = CacheSystem.INSTANCE.cache(location, url);
            cache.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedImage image = ImageIO.read((File)cache.get());
                        int id = TextureUtil.func_110996_a();
                        TextureUtil.func_110987_a((int)id, (BufferedImage)image);
                        TextureImage obj = new TextureImage(id);
                        ImageCache.this.mapTextureObjects.put(location, obj);
                        ImageCache.this.loading.add(location);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, (Executor)CacheSystem.INSTANCE.service);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeImage(ResourceLocation location) {
        ITextureObject itextureobject = this.manager.func_110581_b(location);
        if (itextureobject != null) {
            TextureUtil.func_147942_a((int)itextureobject.func_110552_b());
            this.mapTextureObjects.remove(location);
        }
        this.loading.remove(location);
        CacheSystem.INSTANCE.remove(location);
    }

    public void clear() {
        HashSet set = Sets.newHashSet(this.loading);
        for (ResourceLocation location : set) {
            this.removeImage(location);
        }
    }

    private class TextureImage
    implements ITextureObject {
        int id;

        TextureImage(int id) {
            this.id = id;
        }

        public void func_174936_b(boolean p_174936_1_, boolean p_174936_2_) {
        }

        public void func_174935_a() {
        }

        public void func_110551_a(IResourceManager resourceManager) throws IOException {
        }

        public int func_110552_b() {
            return this.id;
        }
    }
}

