/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infstudio.infinitylib.api.network.AbstractBiMessage;
import net.infstudio.infinitylib.api.network.AbstractClientMessage;
import net.infstudio.infinitylib.api.network.AbstractServerMessage;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class ModNetwork {
    private static ModNetwork instance;
    private byte packetId = 0;
    private List<Class> protocol = new ArrayList<Class>();
    private final SimpleNetworkWrapper dispatcher;

    public static ModNetwork instance() {
        if (instance == null) {
            instance = new ModNetwork("net");
        }
        return instance;
    }

    private ModNetwork(String modid) {
        this.dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel(modid);
    }

    public final <Message extends IMessage> void registerMessage(IMessageHandler<Message, IMessage> handler) {
        Class messageClass;
        if (handler instanceof AbstractClientMessage) {
            messageClass = TypeUtils.cast(handler.getClass());
            byte by = this.packetId;
            this.packetId = (byte)(by + 1);
            this.dispatcher.registerMessage(handler, messageClass, (int)by, Side.CLIENT);
        } else if (handler instanceof AbstractServerMessage) {
            messageClass = TypeUtils.cast(handler.getClass());
            byte by = this.packetId;
            this.packetId = (byte)(by + 1);
            this.dispatcher.registerMessage(handler, messageClass, (int)by, Side.SERVER);
        } else if (handler instanceof AbstractBiMessage) {
            messageClass = TypeUtils.cast(handler.getClass());
            this.dispatcher.registerMessage(handler, messageClass, (int)this.packetId, Side.CLIENT);
            messageClass = TypeUtils.cast(handler.getClass());
            byte by = this.packetId;
            this.packetId = (byte)(by + 1);
            this.dispatcher.registerMessage(handler, messageClass, (int)by, Side.SERVER);
        } else {
            throw new IllegalArgumentException("Cannot register " + handler.getClass().getName() + ". Not Support type ModHandler maybe?");
        }
        this.protocol.add(messageClass);
    }

    public List<Class> getProtocol() {
        return Collections.unmodifiableList(this.protocol);
    }

    public final void sendTo(IMessage message, EntityPlayerMP player) {
        this.dispatcher.sendTo(message, player);
    }

    public final void sendTo(IMessage message) {
        this.sendToServer(message);
    }

    public final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.dispatcher.sendToAllAround(message, point);
    }

    public final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        this.dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        this.sendToAllAround(message, player.field_70170_p.field_73011_w.func_177502_q(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public final void sendToDimension(IMessage message, int dimensionId) {
        this.dispatcher.sendToDimension(message, dimensionId);
    }

    public final void sendToServer(IMessage message) {
        this.dispatcher.sendToServer(message);
    }
}

