/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.infstudio.infinitylib.api.gui.ComponentProvider;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.remote.gui.event.ClickEvent;
import net.infstudio.infinitylib.api.remote.gui.event.DragEvent;
import net.infstudio.infinitylib.api.remote.gui.event.HoverEvent;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GuiScreenCommon
extends GuiScreen {
    protected List<GuiComponent> back;
    protected GuiComponent current;
    protected boolean adjusted;
    protected MouseEvent currentState;

    public GuiScreenCommon(ComponentProvider provider) {
        ArrayList components = Lists.newArrayList();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ClickEvent(this.currentState, this.current, this));
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new ClickEvent.Release(this.currentState, this.current, this));
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (this.current != null) {
            MinecraftForge.EVENT_BUS.post((Event)new DragEvent(this.currentState, this.current, this));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.adjusted) {
            this.adjusted = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean checked = false;
        if (this.current != null) {
            if (this.include(this.current, mouseX, mouseY)) {
                checked = true;
                MinecraftForge.EVENT_BUS.post((Event)new HoverEvent(this.currentState, this.current, this));
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new HoverEvent.End(this.currentState, this.current, this));
            }
        }
        for (GuiComponent component : this.back) {
            if (checked || !this.include(component, mouseX, mouseY)) continue;
            checked = true;
            this.current = component;
        }
    }

    protected boolean include(GuiComponent gui, int x, int y) {
        return gui.transform().x + gui.transform().width > x && gui.transform().x < x && gui.transform().y < y && gui.transform().y + gui.transform().y > y;
    }

    public void accept(MouseEvent event) {
        this.currentState = event;
    }
}

