/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.remote.gui.node;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.infstudio.infinitylib.api.Pipeline;
import net.infstudio.infinitylib.api.remote.gui.Properties;
import net.infstudio.infinitylib.api.remote.gui.components.GuiComponent;
import net.infstudio.infinitylib.api.remote.gui.components.GuiText;
import net.infstudio.infinitylib.api.remote.gui.node.DrawNode;
import net.infstudio.infinitylib.api.utils.ArrayUtils;
import net.infstudio.infinitylib.api.utils.Local;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class DrawText
extends Gui
implements DrawNode {
    public static final DrawText INSTANCE = new DrawText();
    private String[] stringBuffer = ArrayUtils.newArray(new String[0]);

    private DrawText() {
    }

    @Override
    public void draw(GuiComponent.Transform transform, Pipeline<DrawNode> pipeline, Properties properties) {
        if (properties instanceof GuiText.Prop) {
            FontRenderer renderer;
            GuiText.Prop prop = (GuiText.Prop)properties;
            if (prop.getCacheString() == null) {
                prop.setCacheString(this.buildCacheTexts(prop.getRawString()));
            }
            if ((renderer = prop.getFontRender()) == null) {
                renderer = Minecraft.func_71410_x().field_71466_p;
            }
            this.renderTextBlock(transform.x, transform.y, prop, renderer);
        }
    }

    private CharSequence buildCacheTexts(String[] strings) {
        StringBuilder builder = new StringBuilder();
        ArrayList list = Lists.newArrayList();
        for (String string : strings) {
            list.addAll(Arrays.asList(string.split("\n")));
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                if (!s.startsWith("$")) continue;
                list.set(i, Local.trans(s.substring(1)));
            }
        }
        for (String s : list) {
            builder.append(s).append("\n");
        }
        return builder;
    }

    private void fitIntoArgs(CharSequence cache, Object[] args) {
        this.stringBuffer = String.format(cache.toString(), args).split("\n");
    }

    private void renderTextBlock(int x, int y, GuiText.Prop properties, FontRenderer renderer) {
        int currentY = y;
        Integer height_offset = (Integer)properties.getCache("height_offset");
        if (height_offset == null) {
            height_offset = 2;
        }
        int realHeight = renderer.field_78288_b + height_offset;
        if (properties.isDirty()) {
            this.fitIntoArgs(properties.getCacheString(), properties.getArgs());
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < this.stringBuffer.length; ++i) {
                String content = this.stringBuffer[i];
                Integer width = (Integer)properties.getCache("text_width");
                if (width != null) {
                    list.addAll(renderer.func_78271_c(content, width.intValue()));
                    continue;
                }
                list.add(content);
            }
            properties.setRenderString(list.toArray(new String[list.size()]));
            properties.markDirty(false);
        }
        String[] renderString = properties.getRenderString();
        int cursIdx = properties.cursor();
        int startIdx = properties.startCursor();
        boolean selecting = startIdx != -1;
        for (String s : renderString) {
            boolean cursorInLine;
            int length = s.length();
            boolean bl = cursorInLine = cursIdx < length + 1;
            if (!cursorInLine) {
                cursIdx -= length + 1;
            }
            if (selecting) {
                if (startIdx > length + 1) {
                    startIdx -= length + 1;
                } else {
                    int startX = x;
                    if (startIdx > 0) {
                        startX += renderer.func_78256_a(s.substring(0, startIdx));
                        startIdx = 0;
                    }
                    if (!cursorInLine) {
                        Gui.func_73734_a((int)startX, (int)currentY, (int)(startX + renderer.func_78256_a(s)), (int)renderer.field_78288_b, (int)Color.BLUE.getRGB());
                    } else {
                        Gui.func_73734_a((int)startX, (int)currentY, (int)(startX + renderer.func_78256_a(s.substring(0, cursIdx))), (int)renderer.field_78288_b, (int)Color.BLUE.getRGB());
                    }
                }
            }
            renderer.func_175063_a(s, (float)x, (float)currentY, 0);
            currentY += realHeight;
            if (!cursorInLine) continue;
            renderer.func_78276_b("|", renderer.func_78256_a(s.substring(0, cursIdx)), currentY, 0);
        }
    }
}

