/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.seril;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.api.seril.NBTBasement;
import net.infstudio.infinitylib.api.seril.NBTDeserializer;
import net.infstudio.infinitylib.api.seril.NBTSerializer;
import net.infstudio.infinitylib.api.utils.NBTTagBuilder;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTSerial {
    private Map<Class, NBTDeserializer> deserializerMap;
    private Map<Class, NBTSerializer> serializerMap;

    public <T> NBTTagCompound toTag(T obj) {
        NBTBase base = this.toNBTBase(obj);
        NBTTagBuilder builder = NBTTagBuilder.newBuilder();
        if (base instanceof NBTTagCompound) {
            return (NBTTagCompound)base;
        }
        return builder.addTag("obj", base).build();
    }

    public <T> Optional<T> fromTag(NBTTagCompound tag, Class<T> type) {
        if (this.deserializerMap.containsKey(type)) {
            return Optional.fromNullable(((NBTDeserializer)TypeUtils.cast(this.deserializerMap.get(type))).deserialize(tag));
        }
        return Optional.absent();
    }

    public NBTTagList toNBTList(List list) {
        NBTTagList nbtTagList = new NBTTagList();
        for (Object o : list) {
            nbtTagList.func_74742_a(this.toNBTBase(o));
        }
        return nbtTagList;
    }

    public List fromNBTList(NBTTagList list) {
        return null;
    }

    private <T> NBTBase toNBTBase(T obj) {
        Class<?> type = obj.getClass();
        if (this.serializerMap.containsKey(obj.getClass())) {
            return ((NBTSerializer)TypeUtils.cast(this.serializerMap.get(obj.getClass()))).serialize(obj);
        }
        NBTBase base = NBTBasement.instance().serialize((Object)obj);
        if (base != null) {
            return base;
        }
        NBTTagBuilder builder = NBTTagBuilder.newBuilder();
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAccessible()) continue;
            try {
                Object fieldObj = field.get(obj);
                if (fieldObj == null) continue;
                builder.addTag(field.getName(), this.toNBTBase(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return builder.build();
    }

    public <T> NBTDeserializer<T> getDeserializer(Class<T> clz) {
        if (this.deserializerMap.containsKey(clz)) {
            return (NBTDeserializer)TypeUtils.cast(this.deserializerMap.get(clz));
        }
        return null;
    }

    public <T> NBTSerializer<T> getSerializer(Class<T> clz) {
        if (this.serializerMap.containsKey(clz)) {
            return (NBTSerializer)TypeUtils.cast(this.serializerMap.get(clz));
        }
        return null;
    }

    public <T> NBTSerial with(NBTDeserializer<T> deserializer, Class<T> clz) {
        if (this.deserializerMap == null) {
            this.deserializerMap = Maps.newHashMap();
        }
        this.deserializerMap.put(clz, deserializer);
        return this;
    }

    public <T> NBTSerial with(NBTSerializer<T> serializer, Class<T> clz) {
        if (this.serializerMap == null) {
            this.serializerMap = Maps.newHashMap();
        }
        this.serializerMap.put(clz, serializer);
        return this;
    }
}

