/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import net.infstudio.infinitylib.api.utils.TypeUtils;

public class ArrayUtils {
    public static int[] ensureCapacity(int[] arr, int length) {
        if (arr.length < length) {
            int[] newArr = new int[length];
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            return newArr;
        }
        return arr;
    }

    public static <T> T[] ensureCapacity(T[] arr, int length) {
        if (arr.length < length) {
            T[] newArr = ArrayUtils.newArray(length);
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            return newArr;
        }
        return arr;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] newArr = new int[a.length + b.length];
        System.arraycopy(a, 0, newArr, 0, a.length);
        System.arraycopy(b, 0, newArr, a.length, b.length);
        return newArr;
    }

    public static <T> void concat(T[] arr, T[] arr2) {
        int i;
        int oldLength = arr.length;
        int length = oldLength + arr.length;
        arr = TypeUtils.cast(new Object[length]);
        for (i = 0; i < oldLength; ++i) {
            arr[i] = arr[i];
        }
        while (i < length) {
            arr[i] = arr2[i - oldLength];
            ++i;
        }
    }

    public static <T> void switchElement(T[] arr, int first, int second) {
        T temp = arr[first];
        arr[first] = arr[second];
        arr[second] = temp;
    }

    public static <T> T[] newArray(int size) {
        return TypeUtils.cast(new Object[size]);
    }

    public static <T> T[] newArray(T ... obj) {
        return obj;
    }
}

