/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.infstudio.infinitylib.api.utils.Tools;

public enum FinalFieldUtils {
    INSTANCE;

    private Object unsafeObj;
    private Method putObjectMethod;
    private Method objectFieldOffsetMethod;
    private Method staticFieldOffsetMethod;
    private Method staticFieldBaseMethod;

    private FinalFieldUtils() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = Tools.setAccessible(unsafeClass.getDeclaredField("theUnsafe"));
            this.unsafeObj = unsafeField.get(null);
            this.putObjectMethod = unsafeClass.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            this.objectFieldOffsetMethod = unsafeClass.getMethod("objectFieldOffset", Field.class);
            this.staticFieldOffsetMethod = unsafeClass.getMethod("staticFieldOffset", Field.class);
            this.staticFieldBaseMethod = unsafeClass.getMethod("staticFieldBase", Field.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void set(Object o, Field field, Object value) throws Exception {
        Object fieldBase = o;
        long fieldOffset = (Long)this.objectFieldOffsetMethod.invoke(this.unsafeObj, field);
        this.putObjectMethod.invoke(this.unsafeObj, fieldBase, fieldOffset, value);
    }

    public void setStatic(Field field, Object value) throws Exception {
        Object fieldBase = this.staticFieldBaseMethod.invoke(this.unsafeObj, field);
        long fieldOffset = (Long)this.staticFieldOffsetMethod.invoke(this.unsafeObj, field);
        this.putObjectMethod.invoke(this.unsafeObj, fieldBase, fieldOffset, value);
    }
}

