/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PackageModIdMap {
    private int size = 0;
    private List<Entry> rootList = Lists.newLinkedList();
    private static Comparator<Entry> cmp = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.pkg.compareTo(o2.pkg);
        }
    };

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String getModid(String pkg) {
        if (pkg == null) {
            return null;
        }
        if (this.size == 0) {
            return null;
        }
        Entry entry = this.getRootEntry(pkg);
        while (entry != null) {
            int r = pkg.compareTo(entry.pkg);
            if (r < 0) {
                if (entry.left != null) {
                    entry = entry.left;
                    continue;
                }
                return entry.modid;
            }
            if (r > 0) {
                if (entry.right != null) {
                    entry = entry.right;
                    continue;
                }
                return entry.modid;
            }
            return entry.modid;
        }
        return null;
    }

    private Entry getRootEntry(String pkg) {
        Entry entry = null;
        int idx = pkg.indexOf(".");
        String root = idx > 0 ? pkg.substring(0, idx) : pkg;
        for (Entry e : this.rootList) {
            idx = e.pkg.indexOf(".");
            if (idx > 0 && e.pkg.substring(0, idx).equals(root)) {
                entry = e;
                continue;
            }
            if (!e.pkg.equals(root)) continue;
            entry = e;
        }
        return entry;
    }

    public void put(String pkg, String modid) {
        Entry entry = this.getRootEntry(pkg);
        if (entry == null) {
            this.rootList.add(this.newEntry(pkg, modid));
            Collections.sort(this.rootList, cmp);
        } else {
            while (entry.left != null || entry.right != null) {
                int r = pkg.compareTo(entry.pkg);
                if (r < 0) {
                    if (entry.left != null) {
                        entry = entry.left;
                        continue;
                    }
                    entry.left = this.newEntry(pkg, modid);
                    continue;
                }
                if (r > 0) {
                    if (entry.right != null) {
                        entry = entry.right;
                        continue;
                    }
                    entry.right = this.newEntry(pkg, modid);
                    continue;
                }
                throw new IllegalArgumentException("Duplicated pkg! This should not happen!");
            }
        }
    }

    private Entry newEntry(String key, String value) {
        Entry entry = new Entry();
        entry.pkg = key;
        entry.modid = value;
        ++this.size;
        return entry;
    }

    public void clear() {
        this.rootList = Lists.newLinkedList();
    }

    private class Entry {
        String pkg;
        String modid;
        Entry left;
        Entry right;

        private Entry() {
        }
    }
}

