/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import com.google.common.base.Function;
import java.util.HashMap;
import net.infstudio.infinitylib.common.CompiledLayout;
import net.infstudio.infinitylib.common.LayoutBuilder;
import org.lwjgl.util.vector.Vector2f;

public class TreeLayoutBuilder
implements LayoutBuilder {
    private int numOfNode;
    private Function<Node, Vector2f> nodeSize;
    private Vector2f containerSize;
    private Vector2f gap;
    private Vector2f rootPos;
    private boolean unify;
    private boolean symmetry;
    private boolean changed;
    private Node root;
    private HashMap<Node, Vector2f> pos;
    private Tree tree = new Tree();

    private void make() {
        this.discoverBase(this.root, null, 0, 0);
        for (Layer layer : this.tree.layers) {
            float height = 0.0f;
            for (TreeNode node : layer.nodes) {
                layer.gWidth += node.size.getX() + this.gap.getX();
                if (!(layer.gHeight > height)) continue;
                height = layer.gHeight;
            }
            layer.gHeight = height;
        }
    }

    private void ensureTreeHeight(Tree tree, int height) {
        if (tree.layers.length < height) {
            Layer[] layers = new Layer[height * 2];
            System.arraycopy(tree.layers, 0, layers, 0, tree.layers.length);
            tree.layers = layers;
            for (int i = 0; i < tree.layers.length; ++i) {
                if (layers[i] != null) continue;
                layers[i] = new Layer(tree, i);
            }
        }
    }

    private void ensureLayerWidth(Layer layer) {
        if (layer.width > layer.nodes.length) {
            TreeNode[] nodes = new TreeNode[layer.width * 2];
            System.arraycopy(layer.nodes, 0, nodes, 0, layer.nodes.length);
            layer.nodes = nodes;
        }
    }

    private void discoverBase(Node node, TreeNode parent, int index, int depth) {
        this.ensureTreeHeight(this.tree, depth);
        Layer layer = this.tree.layers[depth];
        ++layer.width;
        this.ensureLayerWidth(layer);
        TreeNode treeNode = new TreeNode(layer, (Vector2f)this.nodeSize.apply((Object)node), node);
        treeNode.parent = parent;
        layer.nodes[index] = treeNode;
        Node[] children = node.children();
        if (children != null) {
            if (children.length > this.tree.treeWidth) {
                this.tree.treeWidth = children.length;
            }
            for (int i = 0; i < children.length; ++i) {
                this.discoverBase(children[i], treeNode, i, depth + 1);
            }
        } else if (depth > this.tree.treeHeight) {
            this.tree.treeHeight = depth;
        }
    }

    private void discoverGraphic() {
    }

    @Override
    public CompiledLayout build() {
        return null;
    }

    private class Tree {
        Layer[] layers = new Layer[0];
        int treeHeight;
        int treeWidth;
        int maxWidthLayer;

        private Tree() {
        }
    }

    private class TreeNode {
        private Layer layer;
        private TreeNode parent;
        private Vector2f size;
        private Node delegate;

        public TreeNode(Layer layer, Vector2f vector2f, Node node) {
            this.layer = layer;
            this.size = vector2f;
            this.delegate = node;
        }
    }

    private class Layer {
        Tree parent;
        TreeNode[] nodes;
        int depth;
        int width;
        float gWidth;
        float gHeight;

        public Layer(Tree parent, int depth) {
            this.parent = parent;
            this.depth = depth;
            this.nodes = new TreeNode[0];
        }
    }

    public static interface Node {
        public Node[] children();
    }
}

