/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.api.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.infstudio.infinitylib.HelperMod;

public class TypeUtils {
    public static Type getGenericType(Object obj, int parameter) {
        try {
            return ((ParameterizedType)obj.getClass().getGenericSuperclass()).getActualTypeArguments()[parameter];
        }
        catch (Exception e) {
            HelperMod.LOG.warn("Cannot found the generic type by superclass for {}. Now try to search from interface.", new Object[]{obj.getClass()});
            return TypeUtils.getInterfaceGenericType(obj, null, parameter);
        }
    }

    public static Type getGenericType(Class<?> clz, int parameter) {
        try {
            return ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments()[parameter];
        }
        catch (Exception e) {
            HelperMod.LOG.warn("Cannot found the generic type by superclass for {}. Now try to search from interface.", new Object[]{clz});
            return TypeUtils.getInterfaceGenericType(clz, null, parameter);
        }
    }

    public static Type getInterfaceGenericType(Class<?> clz, Type interfaceType, int parameter) {
        for (Type type : clz.getGenericInterfaces()) {
            if (interfaceType == null || type == interfaceType) {
                return ((ParameterizedType)type).getActualTypeArguments()[parameter];
            }
            if (!(type instanceof ParameterizedType)) continue;
            return ((ParameterizedType)type).getActualTypeArguments()[parameter];
        }
        throw new IllegalArgumentException("Not found a interface with type " + interfaceType + ".");
    }

    public static Type getInterfaceGenericType(Object obj, Type interfaceType, int parameter) {
        return TypeUtils.getInterfaceGenericType(obj.getClass(), interfaceType, parameter);
    }

    public static Type getGenericType(Object obj) {
        return TypeUtils.getGenericType(obj, 0);
    }

    public static Type getInterfaceGenericType(Object obj) {
        return TypeUtils.getInterfaceGenericType(obj, null, 0);
    }

    public static Type getInterfaceGenericType(Class<?> clz) {
        return TypeUtils.getInterfaceGenericType(clz, null, 0);
    }

    public static Type getInterfaceGenericType(Object obj, int parameter) {
        return TypeUtils.getInterfaceGenericType(obj, null, parameter);
    }

    public static <T> Class<T> getInterfaceGenericTypeTo(Class<?> clz) {
        return TypeUtils.getInterfaceGenericTypeTo(clz, 0);
    }

    public static <T> Class<T> getInterfaceGenericTypeTo(Class<?> clz, int parameter) {
        return (Class)TypeUtils.cast(TypeUtils.getInterfaceGenericType(clz, null, parameter));
    }

    public static <T> Class<T> getInterfaceGenericTypeTo(Class<?> clz, Type t) {
        return (Class)TypeUtils.cast(TypeUtils.getInterfaceGenericType(clz, t, 0));
    }

    public static <T> Class<T> getInterfaceGenericTypeTo(Object obj) {
        return TypeUtils.getInterfaceGenericTypeTo(obj.getClass());
    }

    public static <T> Class<T> getGenericTypeTo(Object obj, int parameter) {
        return (Class)TypeUtils.cast(TypeUtils.getGenericType(obj, parameter));
    }

    public static <T> Class<T> getGenericTypeTo(Object obj) {
        return TypeUtils.getGenericTypeTo(obj, 0);
    }

    public static Type getInterfaceGenericType(Object obj, Type interfaceType) {
        return TypeUtils.getInterfaceGenericType(obj, interfaceType, 0);
    }

    public static <T> T[] cast(Object[] arr) {
        return arr;
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    public static <T> Class<T> cast(Class<?> clz) {
        Class<?> future = null;
        try {
            future = clz;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (future != null) {
            return future;
        }
        throw new ClassCastException();
    }
}

