/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.client.loading;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.client.loading.Pack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLContainerHolder;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.IOUtils;

public class ExternalResource
implements IResourcePack,
FMLContainerHolder {
    private ModContainer container;
    private static Map<String, Pack> delegate = Maps.newHashMap();

    public static void register(Pack pack) {
        for (String s : pack.domain()) {
            delegate.put(s, pack);
        }
    }

    public ExternalResource(ModContainer container) {
        this.container = container;
    }

    public InputStream func_110590_a(ResourceLocation location) {
        if (!delegate.containsKey(location.func_110624_b())) {
            return null;
        }
        return delegate.get(location.func_110624_b()).getInputStream(location);
    }

    public boolean func_110589_b(ResourceLocation location) {
        if (!delegate.containsKey(location.func_110624_b())) {
            return false;
        }
        return delegate.get(location.func_110624_b()).resourceExists(location);
    }

    public Set<String> func_110587_b() {
        return delegate.keySet();
    }

    public <T extends IMetadataSection> T func_135058_a(IMetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        TypeUtils.cast(new ByteArrayInputStream(("{\n \"pack\": {\n   \"description\": \"dummy FML pack for " + this.container.getName() + "\",\n   \"pack_format\": 1\n}\n}").getBytes(Charsets.UTF_8)));
        JsonObject jsonobject = null;
        BufferedReader bufferedreader = null;
        try {
            bufferedreader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(("{\n \"pack\": {\n   \"description\": \"dummy FML pack for " + this.container.getName() + "\",\n   \"pack_format\": 1\n}\n}").getBytes(Charsets.UTF_8))));
            jsonobject = new JsonParser().parse((Reader)bufferedreader).getAsJsonObject();
        }
        catch (RuntimeException runtimeexception) {
            try {
                throw new JsonParseException((Throwable)runtimeexception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedreader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedreader);
        return (T)metadataSerializer.func_110503_a(metadataSectionName, jsonobject);
    }

    private InputStream getRealInputStream(ResourceLocation location) {
        try {
            ZipFile zipfile = new ZipFile(new File(this.container.getSource(), String.format("%s/%s/%s/", "assets", location.func_110624_b(), location.func_110623_a())));
            ZipEntry zipentry = zipfile.getEntry("assets/pack.mcmeta");
            return zipfile.getInputStream(zipentry);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedImage func_110586_a() throws IOException {
        return Minecraft.func_71410_x().func_110438_M().func_148530_e().func_110586_a();
    }

    public String func_130077_b() {
        return "extra";
    }

    public ModContainer getFMLContainer() {
        return this.container;
    }
}

