/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.client.render;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.ListIterator;
import net.infstudio.infinitylib.client.render.ClientRenderUtils;
import net.infstudio.infinitylib.client.render.ClientRenderer;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vector3d;

public class WorkBox
implements ClientRenderer.Work {
    private Vector3d a;
    private Vector3d b;
    private LinkedList<RenderWorker> workers = Lists.newLinkedList();
    public static final RenderWorker FULL_BOX = new RenderWorker(){

        @Override
        public void render(RenderGlobal context, float partialTicks, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            Tessellator instance = Tessellator.func_178181_a();
            WorldRenderer vertex = instance.func_178180_c();
            vertex.func_181668_a(8, DefaultVertexFormats.field_181705_e);
            vertex.func_181662_b(minX, minY, minZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, maxZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, minY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, minY, minZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, minZ).func_181675_d();
            instance.func_78381_a();
            vertex.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertex.func_181662_b(minX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, minY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, minY, maxZ).func_181675_d();
            instance.func_78381_a();
        }
    };
    public static final RenderWorker EMPTY_BOX = new RenderWorker(){

        @Override
        public void render(RenderGlobal context, float partialTicks, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            Tessellator instance = Tessellator.func_178181_a();
            WorldRenderer vertex = instance.func_178180_c();
            vertex.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            vertex.func_181662_b(minX, minY, minZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, minZ).func_181675_d();
            instance.func_78381_a();
            vertex.func_181668_a(2, DefaultVertexFormats.field_181705_e);
            vertex.func_181662_b(minX, minY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, maxZ).func_181675_d();
            instance.func_78381_a();
            vertex.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            vertex.func_181662_b(minX, minY, minZ).func_181675_d();
            vertex.func_181662_b(minX, minY, maxZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(minX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, maxY, maxZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, minZ).func_181675_d();
            vertex.func_181662_b(maxX, minY, maxZ).func_181675_d();
            instance.func_78381_a();
        }
    };

    public WorkBox(BlockPos a, BlockPos b) {
        this.a = ClientRenderUtils.getRealPositionX(a);
        this.b = ClientRenderUtils.getRealPositionX(b);
    }

    public WorkBox addFirst(RenderWorker worker) {
        this.workers.addFirst(worker);
        return this;
    }

    public WorkBox addAfter(RenderWorker target, RenderWorker newWorker) {
        ListIterator<RenderWorker> iterator = this.workers.listIterator();
        while (iterator.hasNext()) {
            if (iterator.next() != target) continue;
            iterator.add(newWorker);
        }
        return this;
    }

    public WorkBox addBefore(RenderWorker target, RenderWorker newWorker) {
        ListIterator<RenderWorker> iterator = this.workers.listIterator();
        while (iterator.hasNext()) {
            if (iterator.next() != target) continue;
            iterator.previous();
            iterator.add(newWorker);
        }
        return this;
    }

    public WorkBox addLast(RenderWorker worker) {
        this.workers.addLast(worker);
        return this;
    }

    @Override
    public void render(RenderGlobal context, float partialTicks) {
        for (RenderWorker worker : this.workers) {
            worker.render(context, partialTicks, this.a.field_181059_a, this.a.field_181060_b, this.a.field_181061_c, this.b.field_181059_a, this.b.field_181060_b, this.b.field_181061_c);
        }
    }

    static interface RenderWorker {
        public void render(RenderGlobal var1, float var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }
}

