/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.infstudio.infinitylib.common.Pattern3D;
import net.minecraft.util.BlockPos;

public class Pattern3DBlockPos
extends Pattern3D {
    protected List<BlockPos> sub;

    private Pattern3DBlockPos(List<Pattern3D.Vector3D> pos) {
        super(pos);
    }

    public static Pattern3DBlockPos newPattern(List<BlockPos> poses) {
        ArrayList temp = Lists.newArrayList();
        for (BlockPos pose : poses) {
            temp.add(new BlockAdaptorVector3D(pose));
        }
        return new Pattern3DBlockPos(temp);
    }

    public ImmutableList<BlockPos> transferTo(BlockPos origin) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BlockPos pos : this.sub) {
            builder.add((Object)pos.func_177982_a(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p()));
        }
        return builder.build();
    }

    static class BlockAdaptorVector3D
    implements Pattern3D.Vector3D {
        BlockPos pos;

        public BlockAdaptorVector3D(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public int getX() {
            return this.pos.func_177958_n();
        }

        @Override
        public int getY() {
            return this.pos.func_177956_o();
        }

        @Override
        public int getZ() {
            return this.pos.func_177952_p();
        }

        @Override
        public Pattern3D.Vector3D offset(int x, int y, int z) {
            return new BlockAdaptorVector3D(this.pos.func_177982_a(x, y, z));
        }

        @Override
        public int compareTo(Pattern3D.Vector3D o) {
            return this.getX() - o.getX() + this.getY() - o.getY() + this.getZ() - o.getZ();
        }
    }
}

