/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common;

import net.infstudio.infinitylib.api.utils.TypeUtils;

public class RegionalCacheGeneric<T> {
    private T[][] cache;
    private int radius;
    private int diameter;
    private OffsetMapping mapping;
    private int centerX;
    private int centerZ;
    private ValueReplacement<T> delegate;
    private Logic logic;

    public RegionalCacheGeneric(int radius, OffsetMapping mapping, ValueReplacement<T> delegate) {
        this.diameter = radius * 2 + 1;
        this.cache = (Object[][])TypeUtils.cast((Object[])new Object[this.diameter][this.diameter]);
        this.mapping = mapping;
        this.radius = radius;
        this.centerX = Integer.MIN_VALUE;
        this.centerZ = Integer.MIN_VALUE;
        this.delegate = delegate;
        this.logic = this.initLogic();
    }

    public T getCenter() {
        return this.cache[this.radius][this.radius];
    }

    public T[][] getCache() {
        Object[][] temp = (Object[][])TypeUtils.cast((Object[])new Object[this.diameter][this.diameter]);
        System.arraycopy(this.cache, 0, temp, 0, this.diameter);
        return temp;
    }

    public void moveTo(int x, int z) {
        int oldX = this.centerX;
        int oldZ = this.centerZ;
        this.centerX = x;
        this.centerZ = z;
        int xOffset = this.mapping.getOffset(this.centerX - x);
        int zOffset = this.mapping.getOffset(this.centerZ - z);
        if (oldX == Integer.MIN_VALUE || oldZ == Integer.MIN_VALUE || xOffset > this.diameter || zOffset > this.diameter) {
            this.logic.refresh();
        } else {
            this.logic.move(xOffset, zOffset);
        }
    }

    public T get(int x, int z) {
        return this.cache[x][z];
    }

    public void set(T data, int x, int z) {
        this.cache[x][z] = data;
    }

    private Logic initLogic() {
        return this.delegate instanceof ValueModify ? new Logic(){
            private ValueModify<T> delegate;
            private boolean init;
            {
                this.delegate = (ValueModify)RegionalCacheGeneric.this.delegate;
                this.init = false;
            }

            @Override
            public void refresh() {
                if (!this.init) {
                    for (int x = 0; x < RegionalCacheGeneric.this.diameter; ++x) {
                        for (int z = 0; z < RegionalCacheGeneric.this.diameter; ++z) {
                            ((RegionalCacheGeneric)RegionalCacheGeneric.this).cache[x][z] = this.delegate.create(RegionalCacheGeneric.this.centerX + RegionalCacheGeneric.this.mapping.getRealOffset(x - RegionalCacheGeneric.this.radius), RegionalCacheGeneric.this.centerZ + RegionalCacheGeneric.this.mapping.getRealOffset(z - RegionalCacheGeneric.this.radius));
                        }
                    }
                    this.init = true;
                    return;
                }
                for (int x = 0; x < RegionalCacheGeneric.this.diameter; ++x) {
                    for (int z = 0; z < RegionalCacheGeneric.this.diameter; ++z) {
                        this.delegate.modify(RegionalCacheGeneric.this.cache[x][z], RegionalCacheGeneric.this.centerX + RegionalCacheGeneric.this.mapping.getRealOffset(x - RegionalCacheGeneric.this.radius), RegionalCacheGeneric.this.centerZ + RegionalCacheGeneric.this.mapping.getRealOffset(z - RegionalCacheGeneric.this.radius));
                    }
                }
            }

            @Override
            public void move(int xOffset, int zOffset) {
                if (xOffset < 0) {
                    for (int x = 0; x < RegionalCacheGeneric.this.diameter + xOffset; ++x) {
                        if (zOffset < 0) continue;
                        for (int z = 0; z < RegionalCacheGeneric.this.diameter - zOffset; ++z) {
                            this.delegate.switchValue(RegionalCacheGeneric.this.cache[x][z], RegionalCacheGeneric.this.cache[x - xOffset][z + zOffset]);
                        }
                    }
                }
            }
        } : new Logic(){

            @Override
            public void refresh() {
                for (int x = 0; x < RegionalCacheGeneric.this.diameter; ++x) {
                    for (int z = 0; z < RegionalCacheGeneric.this.diameter; ++z) {
                        ((RegionalCacheGeneric)RegionalCacheGeneric.this).cache[x][z] = RegionalCacheGeneric.this.delegate.create(RegionalCacheGeneric.this.centerX + RegionalCacheGeneric.this.mapping.getRealOffset(x - RegionalCacheGeneric.this.radius), RegionalCacheGeneric.this.centerZ + RegionalCacheGeneric.this.mapping.getRealOffset(z - RegionalCacheGeneric.this.radius));
                    }
                }
            }

            @Override
            public void move(int xOffset, int zOffset) {
                int x;
                Object[][] temp = (Object[][])TypeUtils.cast((Object[])new Object[RegionalCacheGeneric.this.diameter][RegionalCacheGeneric.this.diameter]);
                int range = RegionalCacheGeneric.this.diameter - xOffset;
                if (xOffset < 0) {
                    for (x = 0; x < range; ++x) {
                        if (zOffset >= 0) {
                            System.arraycopy(RegionalCacheGeneric.this.cache[x], 0, temp[x - xOffset], zOffset, RegionalCacheGeneric.this.diameter - zOffset);
                            continue;
                        }
                        System.arraycopy(RegionalCacheGeneric.this.cache[x], -zOffset, temp[x - xOffset], 0, RegionalCacheGeneric.this.diameter + zOffset);
                    }
                } else if (xOffset >= 0) {
                    for (x = xOffset; x < RegionalCacheGeneric.this.diameter; ++x) {
                        if (zOffset >= 0) {
                            System.arraycopy(RegionalCacheGeneric.this.cache[x], 0, temp[x - xOffset], zOffset, RegionalCacheGeneric.this.diameter - zOffset);
                            continue;
                        }
                        System.arraycopy(RegionalCacheGeneric.this.cache[x], -zOffset, temp[x - xOffset], 0, RegionalCacheGeneric.this.diameter + zOffset);
                    }
                }
                for (x = 0; x < RegionalCacheGeneric.this.diameter; ++x) {
                    for (int z = 0; z < RegionalCacheGeneric.this.diameter; ++z) {
                        Object v = temp[x][z];
                        if (v != null) continue;
                        temp[x][z] = RegionalCacheGeneric.this.delegate.create(RegionalCacheGeneric.this.centerX + RegionalCacheGeneric.this.mapping.getRealOffset(x - RegionalCacheGeneric.this.radius), RegionalCacheGeneric.this.centerZ + RegionalCacheGeneric.this.mapping.getRealOffset(z - RegionalCacheGeneric.this.radius));
                    }
                }
                RegionalCacheGeneric.access$202(RegionalCacheGeneric.this, temp);
            }
        };
    }

    static /* synthetic */ Object[][] access$202(RegionalCacheGeneric x0, Object[][] x1) {
        x0.cache = x1;
        return x1;
    }

    public static interface OffsetMapping {
        public int getOffset(int var1);

        public int getRealOffset(int var1);
    }

    public static interface ValueModify<T>
    extends ValueReplacement<T> {
        public void modify(T var1, int var2, int var3);

        public void switchValue(T var1, T var2);
    }

    public static interface ValueReplacement<T> {
        public T create(int var1, int var2);
    }

    private static interface Logic {
        public void refresh();

        public void move(int var1, int var2);
    }
}

