/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.infstudio.infinitylib.event.ClientStopEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.output.FileWriterWithEncoding;

@ModHandler
public class LanguageReporter {
    @Instance
    private static LanguageReporter instance = new LanguageReporter();
    private List<String> langNodes = Lists.newArrayList();
    private Set<File> fileLang = Sets.newHashSet();

    public void report(String unlocalizedName) {
        unlocalizedName = unlocalizedName.concat("=");
        this.langNodes.add(unlocalizedName);
    }

    public LanguageReporter start(String modid, String[] str) {
        try {
            for (String name : str) {
                File f = new File(FileReference.getRefer((String)modid).dirLang, name.concat(".lang"));
                if (!f.exists()) {
                    f.createNewFile();
                }
                this.fileLang.add(f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void end() {
        try {
            for (File lang : this.fileLang) {
                BufferedWriter writer = new BufferedWriter((Writer)new FileWriterWithEncoding(lang, "UTF-8"));
                Collections.sort(this.langNodes);
                char last = '\u0000';
                boolean init = false;
                for (String name : this.langNodes) {
                    if (init && name.charAt(0) != last) {
                        writer.write("\n");
                    }
                    last = name.charAt(0);
                    init = true;
                    writer.write(name);
                    writer.newLine();
                }
                writer.flush();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.langNodes.clear();
        this.fileLang.clear();
    }

    @SubscribeEvent
    public void exit(ClientStopEvent event) {
        if (this.langNodes.isEmpty()) {
            return;
        }
        this.start("all", new String[]{"zh_CN", "en_US"});
        this.end();
    }

    public static LanguageReporter instance() {
        return instance;
    }

    void close() {
        instance = null;
    }
}

