/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.common.registry.abstracts;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.registry.components.ArgumentHelper;
import net.infstudio.infinitylib.api.registry.components.Construct;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.common.Maker;

public abstract class ReflectionAnnotatedMaker<Input, Output>
implements Maker<Field, Output> {
    private Map<Class<? extends Annotation>, ArgumentHelper> map;
    private Object obj;

    public ReflectionAnnotatedMaker(Map<Class<? extends Annotation>, ArgumentHelper> map) {
        this.map = map;
    }

    public ReflectionAnnotatedMaker(Map<Class<? extends Annotation>, ArgumentHelper> map, Object obj) {
        this.map = map;
        this.obj = obj;
    }

    @Override
    public Output make(Field f) {
        Input item = null;
        Construct ctr = f.getAnnotation(Construct.class);
        boolean needSetValue = true;
        if (ctr != null) {
            Object[] args = new Object[]{};
            for (Annotation a : f.getAnnotations()) {
                if (!this.map.containsKey(a.annotationType())) continue;
                args = this.map.get(a.annotationType()).getArguments(a);
                break;
            }
            int length = args.length;
            Class[] argType = new Class[length];
            for (int i = 0; i < length; ++i) {
                Class<Object> c = args[i].getClass();
                if (c.equals(Float.class)) {
                    c = Float.TYPE;
                } else if (c.equals(Integer.class)) {
                    c = Integer.TYPE;
                } else if (c.equals(Boolean.class)) {
                    c = Boolean.TYPE;
                } else if (c.equals(Double.class)) {
                    c = Double.TYPE;
                } else if (c.equals(Long.class)) {
                    c = Long.TYPE;
                } else if (c.equals(Short.class)) {
                    c = Short.TYPE;
                }
                argType[i] = c;
            }
            try {
                Class temp = TypeUtils.cast(ctr.value());
                item = (Input)temp.getConstructor(argType).newInstance(args);
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                for (Object o : args) {
                    HelperMod.LOG.fatal(o);
                }
                if (args.length == 0) {
                    HelperMod.LOG.fatal("args is NULL!!!");
                }
                for (Class c : argType) {
                    HelperMod.LOG.fatal(c.getName());
                }
                HelperMod.LOG.fatal("not found constructor in {} ", new Object[]{ctr.value().getName()});
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
        } else if (!f.isAnnotationPresent(Construct.Ignore.class)) {
            try {
                item = this.obj == null ? (Input)TypeUtils.cast(f.get(null)) : (Input)TypeUtils.cast(f.get(this.obj));
                needSetValue = false;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (item == null) {
            HelperMod.LOG.fatal("Item Field {}'s value is null. It will not be registied!", new Object[]{f.getName()});
            return null;
        }
        if (needSetValue) {
            try {
                if (this.obj == null) {
                    f.set(null, item);
                } else {
                    f.set(this.obj, item);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this.warp(f, item);
    }

    protected abstract Output warp(Field var1, Input var2);
}

