/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import com.google.common.collect.ImmutableList;
import net.infstudio.infinitylib.api.seril.ITagSerializable;
import net.infstudio.infinitylib.api.seril.ITagSerializer;
import net.infstudio.infinitylib.api.vars.VarSync;
import net.infstudio.infinitylib.api.vars.VarSyncBase;
import net.infstudio.infinitylib.api.vars.VarSyncFactory;
import net.infstudio.infinitylib.entity.VarWatchingImpl;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTTagCompound;

public class EntityVarFactory
implements VarSyncFactory {
    private ImmutableList.Builder<ITagSerializable> builder = ImmutableList.builder();
    private Entity entity;
    private int currentId;

    public EntityVarFactory(Entity entity) {
        this.entity = entity;
        this.currentId = 10;
    }

    protected int registerDataWatcher(Object o) {
        boolean retry;
        if (this.currentId >= 31) {
            return -1;
        }
        do {
            retry = false;
            try {
                this.entity.func_70096_w().func_75682_a(++this.currentId, o);
                this.entity.func_70096_w().func_75692_b(this.currentId, o);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Duplicate")) {
                    retry = true;
                    continue;
                }
                throw e;
            }
        } while (retry);
        return this.currentId;
    }

    public VarWatchingImpl<Integer> newInteger(String name, int i) {
        VarWatchingImpl<Integer> var = new VarWatchingImpl<Integer>(this.registerDataWatcher(i), this.entity.func_70096_w(), name, Integer.valueOf(i)){

            @Override
            public Integer get() {
                return this.getDelegate().func_75679_c(this.getId());
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    public VarWatchingImpl<Float> newFloat(String name, float f) {
        VarWatchingImpl<Float> var = new VarWatchingImpl<Float>(this.registerDataWatcher(Float.valueOf(f)), this.entity.func_70096_w(), name, Float.valueOf(f)){

            @Override
            public Float get() {
                Float f = Float.valueOf(0.0f);
                try {
                    f = Float.valueOf(this.getDelegate().func_111145_d(this.getId()));
                }
                catch (NullPointerException e) {
                    System.out.println("null for " + this.getId());
                }
                return f;
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    public VarWatchingImpl<Short> newShort(String name, short s) {
        VarWatchingImpl<Short> var = new VarWatchingImpl<Short>(this.registerDataWatcher(s), this.entity.func_70096_w(), name, Short.valueOf(s)){

            @Override
            public Short get() {
                return this.getDelegate().func_75693_b(this.getId());
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    public VarWatchingImpl<Byte> newByte(String name, byte b) {
        VarWatchingImpl<Byte> var = new VarWatchingImpl<Byte>(this.registerDataWatcher(b), this.entity.func_70096_w(), name, Byte.valueOf(b)){

            @Override
            public Byte get() {
                return this.getDelegate().func_75683_a(this.getId());
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    public VarWatchingImpl<String> newString(String name, String s) {
        VarWatchingImpl<String> var = new VarWatchingImpl<String>(this.registerDataWatcher(s), this.entity.func_70096_w(), name, s){

            @Override
            public String get() {
                return this.getDelegate().func_75681_e(this.getId());
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    @Override
    public VarSync<Double> newDouble(final String name, double d) {
        VarSyncBase var;
        if (this.entity instanceof EntityLivingBase) {
            EntityLivingBase base = (EntityLivingBase)this.entity;
            final IAttributeInstance attributeInstance = base.func_110140_aT().func_111150_b((IAttribute)new RangedAttribute(null, name, d, Double.MIN_VALUE, Double.MAX_VALUE).func_111112_a(true));
            var = new VarSyncBase<Double>(){

                @Override
                public void readFromNBT(NBTTagCompound tag) {
                    this.data = tag.func_74769_h(name);
                }

                @Override
                public void writeToNBT(NBTTagCompound tag) {
                    tag.func_74780_a(name, ((Double)this.data).doubleValue());
                }

                @Override
                public Double get() {
                    return attributeInstance.func_111125_b();
                }

                @Override
                public void set(Double value) {
                    attributeInstance.func_111128_a(value.doubleValue());
                }
            };
        } else {
            var = new VarWatchingImpl<Double>(this.registerDataWatcher(Double.toString(d)), this.entity.func_70096_w(), name, Double.valueOf(d)){

                @Override
                public void set(Double data) {
                    this.getDelegate().func_75692_b(this.getId(), (Object)Double.toString(data));
                }

                @Override
                public Double get() {
                    return Double.parseDouble(this.getDelegate().func_75681_e(this.getId()));
                }
            };
        }
        this.builder.add((Object)var);
        return var;
    }

    @Override
    public <T extends Enum<T>> VarSync<T> newEnum(String name, T e, final Class<T> enumClass) {
        VarWatchingImpl var = new VarWatchingImpl<T>(this.registerDataWatcher(e.name()), this.entity.func_70096_w(), name, e){

            @Override
            public void set(T data) {
                this.getDelegate().func_75692_b(this.getId(), (Object)((Enum)data).name());
            }

            @Override
            public T get() {
                return Enum.valueOf(enumClass, this.getDelegate().func_75681_e(this.getId()));
            }
        };
        this.builder.add((Object)var);
        return var;
    }

    @Override
    public <T> VarSync<T> newVar(T init, final ITagSerializer<T> serializer) {
        VarSyncBase sync = new VarSyncBase<T>(){

            @Override
            public void readFromNBT(NBTTagCompound tag) {
                serializer.readFromNBT(tag, this.get());
            }

            @Override
            public void writeToNBT(NBTTagCompound tag) {
                serializer.writeToNBT(tag, this.get());
            }
        };
        sync.set(init);
        this.builder.add((Object)sync);
        return sync;
    }

    ImmutableList<ITagSerializable> getAllTracking() {
        return this.builder.build();
    }
}

