/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.entity.EntityHandler;
import net.infstudio.infinitylib.api.entity.IStatus;
import net.infstudio.infinitylib.api.entity.StatusHook;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.registry.ModProxy;
import net.infstudio.infinitylib.api.utils.Nullable;
import net.infstudio.infinitylib.entity.Status;
import net.infstudio.infinitylib.entity.StatusCollection;
import net.minecraft.entity.Entity;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@ModHandler
@ModProxy(side=Side.SERVER, genericType=StatusHook.class)
public class IPropertiesManager
implements ITickable,
StatusHook {
    @Instance(weak=true)
    private static IPropertiesManager instance;
    private ArrayList<EntityHandler> handlers = Lists.newArrayList();
    private WeakHashMap<Entity, ITickable> updateWeakHashMap = new WeakHashMap();
    private StatusCollection collection = new StatusCollection(this.updateWeakHashMap);

    public void registerStatus(EntityHandler property) {
        HelperMod.LOG.info("Register EntityHandler: [{}]", new Object[]{property.getClass()});
        this.handlers.add(property);
    }

    public static boolean enable() {
        return instance != null;
    }

    public static IPropertiesManager instance() {
        if (instance == null) {
            instance = new IPropertiesManager();
        }
        return instance;
    }

    @Nullable
    public IExtendedEntityProperties get(Entity entity, String id) {
        return entity.getExtendedProperties(id);
    }

    @Override
    @Nullable
    public IStatus getStatus(Entity entity, String id) {
        IExtendedEntityProperties p = this.get(entity, id);
        if (p instanceof Status) {
            return ((Status)p).real;
        }
        return null;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        for (EntityHandler handler : this.handlers) {
            this.collection.start(event.entity);
            handler.handle(event.entity, this.collection);
            this.collection.end();
        }
    }

    public void func_73660_a() {
        for (Map.Entry<Entity, ITickable> entry : this.updateWeakHashMap.entrySet()) {
            if (entry.getKey().func_70089_S()) {
                entry.getValue().func_73660_a();
                continue;
            }
            this.updateWeakHashMap.remove(entry.getKey());
        }
    }
}

