/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.WeakHashMap;
import net.infstudio.infinitylib.api.entity.EntityHandler;
import net.infstudio.infinitylib.api.entity.IStatus;
import net.infstudio.infinitylib.entity.Status;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class StatusCollection
implements EntityHandler.Manager {
    private AIManagerImpl ai = new AIManagerImpl();
    private Entity delegate;
    private boolean hasAI;
    private WeakHashMap<Entity, ITickable> updateWeakHashMap;

    StatusCollection(WeakHashMap<Entity, ITickable> updateWeakHashMap) {
        this.updateWeakHashMap = updateWeakHashMap;
    }

    void start(Entity entity) {
        this.delegate = entity;
        if (entity instanceof EntityLiving) {
            this.hasAI = true;
            this.ai.start((EntityLiving)entity);
        }
    }

    void end() {
        if (this.hasAI) {
            this.ai.end();
        }
    }

    @Override
    public EntityHandler.Manager add(String id, IExtendedEntityProperties properties) {
        this.delegate.registerExtendedProperties(id, properties);
        return this;
    }

    @Override
    public EntityHandler.Manager add(String id, IStatus status) {
        Status real = new Status(id, status);
        this.delegate.registerExtendedProperties(id, (IExtendedEntityProperties)real);
        if (status instanceof ITickable) {
            this.updateWeakHashMap.put(this.delegate, (ITickable)status);
        }
        return this;
    }

    @Override
    public Optional<EntityHandler.AIManager> getAIManager() {
        if (this.hasAI) {
            return Optional.of((Object)this.ai);
        }
        return Optional.absent();
    }

    public class AIManagerImpl
    implements EntityHandler.AIManager {
        private EntityAITasks delegate;
        private Set<Class<? extends EntityAIBase>> removedCache = Sets.newHashSet();
        private Set<EntityAIBase> removed = Sets.newHashSet();

        @Override
        public AIManagerImpl addAI(int priority, EntityAIBase ai) {
            this.delegate.func_75776_a(priority, ai);
            return this;
        }

        @Override
        public AIManagerImpl removeAI(Class<? extends EntityAIBase> clz) {
            this.removedCache.add(clz);
            return this;
        }

        @Override
        public AIManagerImpl removeAI(int num) {
            this.delegate.field_75782_a.remove(num);
            return this;
        }

        void end() {
            if (this.delegate == null) {
                return;
            }
            for (Class<? extends EntityAIBase> r : this.removedCache) {
                for (Object obj : this.delegate.field_75782_a) {
                    EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)obj;
                    if (entry.field_75733_a.getClass() != r) continue;
                    this.removed.add(entry.field_75733_a);
                }
            }
            for (EntityAIBase ai : this.removed) {
                this.delegate.func_85156_a(ai);
            }
            this.removed.clear();
            this.removedCache.clear();
            this.delegate = null;
        }

        void start(EntityLiving base) {
            this.delegate = base.field_70714_bg;
        }
    }

    @Cancelable
    class ExtendPropertyAddEvent
    extends Event {
        public Entity entity;
        public String id;
        public IExtendedEntityProperties status;

        public ExtendPropertyAddEvent(Entity entity, String id, IExtendedEntityProperties status) {
            this.entity = entity;
            this.id = id;
            this.status = status;
        }
    }
}

