/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.gui;

import java.util.ListIterator;
import net.infstudio.infinitylib.api.Pipeline;
import net.infstudio.infinitylib.api.remote.gui.node.DrawNode;

public class DrawPipe
implements Pipeline<DrawNode> {
    private Entry head;
    private Entry tail;
    private transient int size;

    private Entry getEntry(DrawNode node) {
        Entry entry = this.head;
        while (entry != null) {
            if (entry.node.equals(node)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private Entry getEntryReverse(DrawNode node) {
        Entry entry = this.tail;
        while (entry != null) {
            if (entry.node.equals(node)) {
                return entry;
            }
            entry = entry.prev;
        }
        return null;
    }

    @Override
    public Pipeline<DrawNode> addLast(DrawNode element) {
        if (this.tail == null) {
            this.tail = new Entry();
            this.tail.node = element;
            this.tail.prev = this.head;
        } else {
            this.tail.next = new Entry();
            this.tail.next.prev = this.tail;
            this.tail = this.tail.next;
            this.tail.node = element;
        }
        ++this.size;
        return this;
    }

    @Override
    public Pipeline<DrawNode> addFirst(DrawNode element) {
        if (this.head == null) {
            this.head = new Entry();
            this.head.node = element;
            this.head.next = this.tail;
        } else {
            this.head.prev = new Entry();
            this.head.prev.next = this.head;
            this.head.prev.node = element;
            this.head = this.head.prev;
        }
        ++this.size;
        return this;
    }

    @Override
    public Pipeline<DrawNode> setAfter(DrawNode target, DrawNode element) {
        Entry t = this.getEntryReverse(target);
        if (t == null) {
            this.addLast(element);
        }
        return this;
    }

    @Override
    public Pipeline<DrawNode> setBefore(DrawNode target, DrawNode element) {
        Entry t = this.getEntry(target);
        if (t == null) {
            this.addFirst(element);
        }
        return this;
    }

    @Override
    public void remove(DrawNode element) {
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (this.size == 0) {
            return false;
        }
        if (this.head != null && this.head.node.getClass() != o.getClass()) {
            return false;
        }
        return false;
    }

    @Override
    public void copy(Pipeline<DrawNode> pipeline) {
    }

    @Override
    public ListIterator<DrawNode> iterator() {
        return null;
    }

    private class Entry {
        Entry prev;
        DrawNode node;
        Entry next;

        private Entry() {
        }
    }
}

