/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.infstudio.infinitylib.api.gui.Properties;
import net.infstudio.infinitylib.api.utils.TypeUtils;
import net.infstudio.infinitylib.api.vars.Var;
import net.infstudio.infinitylib.api.vars.VarBase;
import net.infstudio.infinitylib.api.vars.VarForward;

public class PropertiesImpl
implements Properties {
    private Map<Properties.Key, VarForward> data = Maps.newHashMap();
    private Map<String, Object> cache = Maps.newConcurrentMap();

    @Override
    public <T> VarForward<T> property(Properties.Key<T> location) {
        if (this.data.containsKey(location)) {
            return this.data.get(location);
        }
        VarForwardable var = new VarForwardable();
        this.data.put(location, var);
        return var;
    }

    @Override
    public <T> T getCache(String id) {
        return TypeUtils.cast(this.cache.get(id));
    }

    @Override
    public void putCache(String id, Object cache) {
        this.cache.put(id, cache);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Set<String> allCaches() {
        return this.cache.keySet();
    }

    @Override
    public Set<Properties.Key> allProperties() {
        HashSet set = Sets.newHashSet();
        ArrayList removed = Lists.newArrayListWithCapacity((int)this.data.size());
        for (Properties.Key key : this.data.keySet()) {
            if (!this.property(key).isPresent()) {
                set.add(key);
                continue;
            }
            removed.add(key);
        }
        for (Properties.Key<Object> key : removed) {
            this.data.remove(key);
        }
        return this.data.keySet();
    }

    class VarForwardable<T>
    implements VarForward<T> {
        private Var<T> delegate;

        VarForwardable() {
        }

        @Override
        public boolean isPresent() {
            return this.delegate == null;
        }

        @Override
        public void delegate(Var<T> var) {
            if (PropertiesImpl.this.data != null) {
                this.delegate = var;
            }
        }

        @Override
        public Var<T> delegate() {
            return this.delegate;
        }

        @Override
        public void set(T value) {
            if (this.delegate != null) {
                this.delegate.set(value);
            } else {
                this.delegate = new VarBase<T>(value);
            }
        }

        public T get() {
            return (T)(this.delegate == null ? null : this.delegate.get());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof Var) {
                return this.delegate.equals(((Var)o).get());
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }
}

