/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.inventory;

import com.google.common.base.Optional;
import java.util.Iterator;
import net.infstudio.infinitylib.api.inventory.Inventory;
import net.infstudio.infinitylib.api.inventory.InventoryRule;
import net.infstudio.infinitylib.api.inventory.InventorySpace;
import net.minecraft.item.ItemStack;

public class InvSpaceImpl
implements InventorySpace {
    private int size;
    private int offset;
    private int xSize;
    private int ySize;
    private InventoryRule rule = InventoryRule.COMMON;
    private Inventory parent;
    private String name;

    public InvSpaceImpl(Inventory delegate, int id, int xSize, int ySize) {
        this.size = xSize * ySize;
        this.offset = id;
        this.parent = delegate;
    }

    void setName(String name) {
        this.name = name;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot < this.size) {
            return this.parent.insertItem(slot + this.offset, stack, simulate);
        }
        return null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.size) {
            return this.parent.extractItem(slot + this.offset, amount, simulate);
        }
        return null;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            int current = 0;

            @Override
            public boolean hasNext() {
                return this.current < InvSpaceImpl.this.parent.getSlots();
            }

            @Override
            public ItemStack next() {
                return InvSpaceImpl.this.parent.func_70301_a(this.current++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int id() {
        return this.offset;
    }

    void setRule(InventoryRule rule) {
        this.rule = rule;
    }

    @Override
    public InventoryRule getRule() {
        return this.rule;
    }

    @Override
    public Inventory parent() {
        return this.parent;
    }

    @Override
    public Optional<String> name() {
        return Optional.fromNullable((Object)this.name);
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.parent.func_70301_a(slot + this.offset);
    }

    @Override
    public int xSize() {
        return this.xSize;
    }

    @Override
    public int ySize() {
        return this.ySize;
    }
}

