/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.inventory;

import java.util.ArrayList;
import java.util.EnumMap;
import net.infstudio.infinitylib.api.inventory.InventoryBuilder;
import net.infstudio.infinitylib.api.inventory.InventoryElement;
import net.infstudio.infinitylib.api.inventory.InventoryRule;
import net.infstudio.infinitylib.api.inventory.InventorySlot;
import net.infstudio.infinitylib.api.inventory.InventorySpace;
import net.infstudio.infinitylib.api.inventory.Layout;
import net.infstudio.infinitylib.api.utils.ArrayUtils;
import net.infstudio.infinitylib.api.utils.Nullable;
import net.infstudio.infinitylib.common.Vector2i;
import net.infstudio.infinitylib.inventory.InvImpl;
import net.infstudio.infinitylib.inventory.InvSpaceImpl;
import net.infstudio.infinitylib.inventory.LayoutBase;
import net.infstudio.infinitylib.inventory.SlotSpaceImpl;
import net.minecraft.util.EnumFacing;

public class InventoryBuilderImpl
implements InventoryBuilder {
    private int currentIdx = 0;
    private InvImpl inv = new InvImpl();
    private EnumMap<EnumFacing, int[]> sideMap = new EnumMap(EnumFacing.class);
    private ArrayList<InventoryElement> elements = new ArrayList();
    private LayoutBase layout = new LayoutBase();

    public InvImpl buildInventory() {
        if (this.currentIdx == 0) {
            return null;
        }
        this.inv.build(this.sideMap, this.currentIdx, this.elements, this.layout);
        return this.inv;
    }

    @Override
    public InventorySpace newSpace(int xSize, int ySize, @Nullable EnumFacing facing, InventoryRule rule) {
        int size = xSize * ySize;
        if (facing != null) {
            int[] newArr = new int[size];
            for (int i = 0; i < size; ++i) {
                newArr[i] = this.currentIdx + size;
            }
            if (this.sideMap.containsKey(facing)) {
                newArr = ArrayUtils.concat(this.sideMap.get(facing), newArr);
            }
            this.sideMap.put(facing, newArr);
        }
        InvSpaceImpl space = new InvSpaceImpl(this.inv, this.currentIdx, xSize, ySize);
        space.setRule(rule);
        this.currentIdx += size;
        this.elements.add(space);
        for (int y = 0; y < ySize; ++y) {
            for (int x = 0; x < xSize; ++x) {
                this.layout.list.add(new Vector2i(x * 18, 18 * y));
            }
        }
        return space;
    }

    @Override
    public InventorySpace newSpace(int xSize, int ySize, @Nullable EnumFacing facing) {
        return this.newSpace(xSize, ySize, facing, InventoryRule.COMMON);
    }

    @Override
    public InventorySlot newSlot(EnumFacing facing) {
        return this.newSlot(facing, InventoryRule.COMMON);
    }

    @Override
    public InventorySlot newSlot(EnumFacing facing, InventoryRule rule) {
        if (facing != null) {
            int[] newArr = new int[]{this.currentIdx};
            if (this.sideMap.containsKey(facing)) {
                newArr = ArrayUtils.concat(this.sideMap.get(facing), newArr);
            }
            this.sideMap.put(facing, newArr);
        }
        SlotSpaceImpl slotSpace = new SlotSpaceImpl(this.inv, this.currentIdx);
        slotSpace.setRule(rule);
        ++this.currentIdx;
        this.layout.list.add(Layout.NULL);
        this.elements.add(slotSpace);
        return slotSpace;
    }

    @Override
    public InventoryBuilder allocPos(InventoryElement element, int x, int y) {
        if (element instanceof InventorySpace) {
            InventorySpace space = (InventorySpace)element;
            int count = 0;
            int yP = 0;
            while (y < space.ySize()) {
                int xP = 0;
                while (x < space.xSize()) {
                    this.layout.list.set(count++, new Vector2i(xP * 18 + x, 18 * yP + y));
                    ++x;
                }
                ++y;
            }
        } else {
            this.layout.list.set(element.id(), new Vector2i(x, y));
        }
        return this;
    }

    @Override
    public InventoryBuilder allocName(InventoryElement element, String name) {
        if (element instanceof InvSpaceImpl) {
            ((InvSpaceImpl)element).setName(name);
        } else if (element instanceof SlotSpaceImpl) {
            ((SlotSpaceImpl)element).setName(name);
        }
        return this;
    }

    @Override
    public int currentSize() {
        return this.elements.size();
    }

    @Override
    public InventoryElement getElement(int i) {
        return this.elements.get(i);
    }
}

