/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.login;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.utils.NotNull;
import net.infstudio.infinitylib.login.LoginSystem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;

public class CommonFileLogin
implements LoginSystem.Handler,
LoginSystem.Strategy,
LoginSystem.Source {
    private Cache<UUID, File> cache;

    @Override
    public String id() {
        return "common";
    }

    @Override
    public void setup(Configuration cfg) {
    }

    @Override
    public LoginSystem.Data getData(EntityPlayer player) {
        File f = (File)this.cache.getIfPresent((Object)player.func_110124_au());
        if (f != null && f.exists()) {
            return new LoginData();
        }
        return null;
    }

    public CommonFileLogin() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLoad(PlayerEvent.LoadFromFile event) {
        if (!HelperMod.proxy.isClient()) {
            File psw = event.getPlayerFile(".psw");
            if (this.cache == null) {
                this.setExpireTime(5);
            }
            this.cache.put((Object)event.entityPlayer.func_110124_au(), (Object)psw);
        }
    }

    @Override
    public void setExpireTime(int minute) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)minute, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<UUID, File>(){

            public void onRemoval(RemovalNotification<UUID, File> notification) {
                if (notification.getCause() == RemovalCause.EXPIRED && notification.getKey() != null) {
                    UUID key = (UUID)notification.getKey();
                    EntityPlayerMP playerMP = (EntityPlayerMP)MinecraftServer.func_71276_C().func_130014_f_().func_152378_a(key);
                    playerMP.field_71135_a.func_147360_c("Too long to login");
                }
            }
        }).build();
    }

    @Override
    public void handlePlayer(EntityPlayer player) {
        player.func_71033_a(WorldSettings.GameType.SPECTATOR);
    }

    @Override
    public LoginSystem.LoginState login(EntityPlayer player, String input, LoginSystem.Data data) {
        File f = (File)this.cache.getIfPresent((Object)player.func_110124_au());
        if (f != null && f.exists()) {
            try {
                if (input.equals(FileUtils.readFileToString((File)f))) {
                    return LoginSystem.LoginState.Success;
                }
                return LoginSystem.LoginState.WrongPassword;
            }
            catch (IOException e) {
                return LoginSystem.LoginState.Error;
            }
        }
        return LoginSystem.LoginState.NotRegistered;
    }

    @Override
    public boolean register(EntityPlayer player, String[] input, LoginSystem.Data data) {
        File f = (File)this.cache.getIfPresent((Object)player.func_110124_au());
        if (f != null) {
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private class LoginData
    implements LoginSystem.Data {
        UUID id;
        boolean changed;
        String psw;

        private LoginData() {
        }

        @Override
        public String getInfo(String id) {
            return null;
        }

        @Override
        public String getPassword() {
            if (this.changed) {
                File f = (File)CommonFileLogin.this.cache.getIfPresent((Object)this.id);
                if (f == null) {
                    return "";
                }
                try {
                    return FileUtils.readFileToString((File)f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "";
                }
            }
            return this.psw;
        }

        @Override
        public void setPassword(@NotNull String psw) {
            File f = (File)CommonFileLogin.this.cache.getIfPresent((Object)this.id);
            if (f != null) {
                try {
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    FileUtils.write((File)f, (CharSequence)psw);
                    this.changed = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void setInfo(String id, String info) {
        }
    }
}

