/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.login;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.infstudio.infinitylib.HelperMod;
import net.infstudio.infinitylib.api.Instance;
import net.infstudio.infinitylib.api.registry.ModHandler;
import net.infstudio.infinitylib.api.utils.Local;
import net.infstudio.infinitylib.api.utils.NotNull;
import net.infstudio.infinitylib.api.utils.Nullable;
import net.infstudio.infinitylib.login.CommandLogin;
import net.infstudio.infinitylib.login.CommonFileLogin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@ModHandler
public class LoginSystem {
    @Instance
    private static LoginSystem instance = new LoginSystem();
    private Handler handler;
    private Strategy strategy;
    private Source source;
    private boolean init;
    private Map<String, Handler> handlerMap = Maps.newHashMap();
    private Map<String, Source> sourceMap = Maps.newHashMap();
    private Map<String, Strategy> strategyMap = Maps.newHashMap();

    public static LoginSystem getInstance() {
        return instance;
    }

    private LoginSystem() {
    }

    public void reigsterHandler(String id, Handler handler) {
        this.handlerMap.put(id, handler);
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (this.init) {
            return;
        }
        this.init = true;
        File dir = event.getModConfigurationDirectory();
        for (Source s : this.sourceMap.values()) {
            s.setup(new Configuration(dir, s.id()));
        }
        Configuration cfg = new Configuration(new File(dir, "login"));
        cfg.load();
        String src = cfg.get(Local.trans("cfg.login"), Local.trans("cfg.login.src"), "file", Local.trans("cfg.login.src.comment")).getString();
        this.source = this.sourceMap.get(src);
        if (this.source == null) {
            // empty if block
        }
        String model = cfg.get(Local.trans("cfg.login"), Local.trans("cfg.login.mode"), "direct", Local.trans("cfg.login.mode.comment")).getString();
        this.handler = this.handlerMap.get(model);
        if (this.handler == null) {
            this.handler = new CommonFileLogin();
        }
        String strategy = cfg.get(Local.trans("cfg.login"), Local.trans("cfg.login.strategy"), "specter", Local.trans("cfg.login.strategy.comment")).getString();
        this.strategy = this.strategyMap.get(strategy);
        if (this.strategy == null) {
            this.strategy = this.handler instanceof CommandLogin ? (Strategy)((Object)this.handler) : new CommonFileLogin();
        }
        int i = cfg.get(Local.trans("cfg.login"), Local.trans("cfg.login.expired"), 5, Local.trans("cfg.login.expired.comment")).getInt();
        this.strategy.setExpireTime(i);
        cfg.save();
        this.handlerMap = null;
    }

    public void login(EntityPlayer player, String psw) {
        switch (this.handler.login(player, psw, this.source.getData(player))) {
            case WrongPassword: {
                player.func_146105_b(Local.newChat("command.login.wrong"));
                break;
            }
            case NotRegistered: {
                player.func_146105_b(Local.newChat("command.login.register"));
                break;
            }
            case Success: {
                player.func_146105_b(Local.newChat("command.login.success"));
                player.func_71033_a(WorldSettings.GameType.SURVIVAL);
                break;
            }
            default: {
                player.func_146105_b(Local.newChat("command.login.error"));
            }
        }
    }

    public void register(EntityPlayer player, String[] input) {
        if (this.handler.register(player, input, this.source.getData(player))) {
            player.func_146105_b(Local.newChat("command.login.usage"));
        } else {
            player.func_146105_b(Local.newChat("command.register.usage"));
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!HelperMod.proxy.isClient()) {
            this.strategy.handlePlayer(event.player);
        }
    }

    public static enum LoginState {
        WrongPassword,
        NotRegistered,
        Success,
        Error;

    }

    public static interface Data {
        @Nullable
        public String getInfo(String var1);

        public String getPassword();

        public void setPassword(@NotNull String var1);

        public void setInfo(String var1, String var2);
    }

    public static interface Strategy {
        public void setExpireTime(int var1);

        public void handlePlayer(EntityPlayer var1);
    }

    public static interface Source {
        public String id();

        public void setup(Configuration var1);

        @Nullable
        public Data getData(EntityPlayer var1);
    }

    public static interface Handler {
        public LoginState login(EntityPlayer var1, String var2, Data var3);

        public boolean register(EntityPlayer var1, String[] var2, Data var3);
    }
}

