/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.login.restriction;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.infstudio.infinitylib.api.utils.Local;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ModRestriction {
    private static Type type;
    private static Map<String, String> map;

    public static void preInit(FMLPreInitializationEvent event) {
        if (event.getSide().isServer()) {
            File cfgDir = event.getModConfigurationDirectory();
            Configuration cfg = new Configuration(new File(cfgDir, "ModRestriction.cfg"));
            cfg.load();
            String mode = cfg.get(Local.trans("cfg.restrict.mode"), Local.trans("cfg.restrict.mode.limit"), "BlackList", Local.trans("cfg.restrict.mode.limit.comment")).getString();
            try {
                type = Type.valueOf(mode.toLowerCase());
            }
            catch (Exception e) {
                type = Type.blacklist;
            }
            if (type == Type.weakwhitelist || type == Type.whitelist) {
                map.put("mcp", "*");
                map.put("FML", "*");
                map.put("Forge", "*");
                map.put("helper", "*");
            }
            String src = cfg.get(Local.trans("cfg.restrict.mode"), Local.trans("cfg.restrict.mode.source"), "List", Local.trans("cfg.restrict.mode.source.comment")).getString();
            if ((src = src.toLowerCase()).equals("mod")) {
                for (ModContainer modContainer : Loader.instance().getActiveModList()) {
                    map.put(modContainer.getModId(), "*");
                }
            } else {
                String[] lst;
                for (String s : lst = cfg.get(Local.trans("cfg.restrict.range"), Local.trans("cfg.restrict.range"), new String[]{"xRay *"}, Local.trans("cfg.restrict.range.comment")).getStringList()) {
                    String[] split = s.split(" ");
                    map.put(split[0], split[1]);
                }
            }
            cfg.save();
        }
    }

    public static boolean acceptModList(Map<String, String> modList, Side side) {
        if (side.isClient() && type != null) {
            return type.handle(modList);
        }
        return true;
    }

    static {
        map = Maps.newHashMap();
    }

    static enum Type {
        whitelist{

            @Override
            boolean handle(Map<String, String> modList) {
                if (modList.size() != map.size()) {
                    return false;
                }
                for (Map.Entry<String, String> entry : modList.entrySet()) {
                    String modid = entry.getKey();
                    String version = entry.getValue();
                    String availableVersion = (String)map.get(modid);
                    if (availableVersion == null) {
                        return false;
                    }
                    if (availableVersion.equals("*") || availableVersion.equals(version)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        blacklist{

            @Override
            boolean handle(Map<String, String> modList) {
                for (Map.Entry<String, String> entry : modList.entrySet()) {
                    String modid = entry.getKey();
                    String version = entry.getValue();
                    String availableVersion = (String)map.get(modid);
                    if (availableVersion == null || !availableVersion.equals("*") && !availableVersion.equals(version)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        weakwhitelist{

            @Override
            boolean handle(Map<String, String> modList) {
                for (Map.Entry<String, String> entry : modList.entrySet()) {
                    String modid = entry.getKey();
                    String version = entry.getValue();
                    String availableVersion = (String)map.get(modid);
                    if (availableVersion == null) {
                        return false;
                    }
                    if (availableVersion.equals("*") || availableVersion.equals(version)) continue;
                    return false;
                }
                return true;
            }
        };


        abstract boolean handle(Map<String, String> var1);
    }
}

