/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.time;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.infstudio.infinitylib.api.network.ModNetwork;
import net.infstudio.infinitylib.api.seril.ITagSerializable;
import net.infstudio.infinitylib.api.utils.FileReference;
import net.infstudio.infinitylib.time.ColorModify;
import net.infstudio.infinitylib.time.MessageNewDay;
import net.infstudio.infinitylib.time.TimeEvent;
import net.infstudio.infinitylib.time.TimeMod;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeController
implements ITagSerializable {
    private final World world;
    private long periodTick = 24000L;
    private List<Period> periodList = Lists.newLinkedList();
    private Period current;
    private int currentIdx;
    private int year;
    @SideOnly(value=Side.CLIENT)
    private Map<String, ColorModify> colorMap;

    public Period getCurrent() {
        return this.current;
    }

    TimeController(World world) {
        this.world = world;
    }

    void fallbackSetting() {
        this.setTimePeriod(48000L);
        this.addPeriod("spring", 10);
        this.addPeriod("summer", 10);
        this.addPeriod("fall", 10);
        this.addPeriod("winter", 10);
        this.current = this.periodList.get(0);
    }

    public void setTimePeriod(long tickPerDay) {
        this.periodTick = tickPerDay;
    }

    public long getTickPerDay() {
        return this.periodTick;
    }

    public Period getCurrentPeriod(World world) {
        return this.current;
    }

    public void insertPeriod(int index, String id, int dayPerPeriod) {
        this.periodList.add(index, new Period(id, dayPerPeriod));
    }

    public Period addPeriod(String id, int dayPerPeriod) {
        Period p = new Period(id, dayPerPeriod);
        this.periodList.add(p);
        return p;
    }

    @SideOnly(value=Side.CLIENT)
    public void addColor(String period, ColorModify modify) {
        if (this.colorMap == null) {
            this.colorMap = Maps.newHashMap();
        }
        this.colorMap.put(period, modify);
    }

    @SideOnly(value=Side.CLIENT)
    public int modifyColor(int color) {
        if (this.current == null) {
            return color;
        }
        ColorModify modify = this.colorMap.get(this.current.getId());
        if (modify == null) {
            return color;
        }
        return modify.processColor(color);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList periods = tag.func_150295_c("periods", 10);
        for (int i = 0; i < periods.func_74745_c(); ++i) {
            NBTTagCompound nbt = (NBTTagCompound)periods.func_179238_g(i);
            Period p = new Period();
            p.readFromNBT(nbt);
            if (this.periodList.size() == i) {
                this.periodList.add(p);
                continue;
            }
            this.periodList.set(i, p);
        }
        this.currentIdx = tag.func_74762_e("current");
        this.current = this.periodList.get(this.currentIdx);
        this.periodTick = tag.func_74763_f("periodTick");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList lst = new NBTTagList();
        for (Period period : this.periodList) {
            NBTTagCompound info = new NBTTagCompound();
            period.writeToNBT(info);
            lst.func_74742_a((NBTBase)info);
        }
        tag.func_74782_a("periods", (NBTBase)lst);
        tag.func_74768_a("current", this.currentIdx);
        tag.func_74768_a("year", this.year);
        tag.func_74772_a("periodTick", this.periodTick);
    }

    protected void tick(long worldTime) {
        if (this.current == null) {
            this.current = this.periodList.get(0);
        }
        if (worldTime / this.getTickPerDay() == 0L) {
            this.newDay();
        }
    }

    void newDay() {
        boolean newPeriod = this.current.tickDay();
        MinecraftForge.EVENT_BUS.post((Event)new TimeEvent.NewDay(this.world, this.current));
        if (newPeriod) {
            boolean year = false;
            if (++this.currentIdx == this.periodList.size()) {
                this.currentIdx = 0;
                year = true;
            }
            this.current = this.periodList.get(this.currentIdx);
            MinecraftForge.EVENT_BUS.post((Event)new TimeEvent.NewPeriod(this.world, this.current));
            if (year) {
                MinecraftForge.EVENT_BUS.post((Event)new TimeEvent.NewYear(this.world, this.current, ++this.year));
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!this.world.field_72995_K && event.phase == TickEvent.Phase.END) {
            this.tick(event.world.func_72820_D());
        }
    }

    @SubscribeEvent
    public void onNewDay(TimeEvent.NewDay day) {
        if (!this.world.field_72995_K) {
            ModNetwork.instance().sendToDimension(new MessageNewDay(), this.world.field_73011_w.func_177502_q());
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (this.world.field_73011_w instanceof TimeMod.WorldProviderModified) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeToNBT(tag);
            try {
                File file = new File(FileReference.getSave(), "time");
                if (!file.exists()) {
                    file.createNewFile();
                }
                CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class Period
    implements ITagSerializable {
        private String id;
        private int dayPerPeriod;
        private int currentDay;

        Period() {
        }

        public Period(String id, int dayPerPeriod) {
            this.id = id;
            this.dayPerPeriod = dayPerPeriod;
        }

        boolean tickDay() {
            ++this.currentDay;
            MinecraftForge.EVENT_BUS.post((Event)new TimeEvent.NewDay(TimeController.this.world, this));
            if (this.currentDay >= this.dayPerPeriod) {
                this.currentDay = 0;
                return true;
            }
            return false;
        }

        public int currentDay() {
            return this.currentDay;
        }

        public int totalDay() {
            return this.dayPerPeriod;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.id = tag.func_74779_i("id");
            this.dayPerPeriod = tag.func_74762_e("dayPerPeriod");
            this.currentDay = tag.func_74762_e("currentDay");
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("id", this.id);
            tag.func_74768_a("dayPerPeriod", this.dayPerPeriod);
            tag.func_74768_a("currentDay", this.currentDay);
        }
    }
}

