/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.infinitylib.world.region;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import net.infstudio.infinitylib.api.utils.NBTTagBuilder;
import net.infstudio.infinitylib.world.region.RegionManagerImpl;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

class RegionInternal {
    RegionInternal() {
    }

    static Area fromNBT(NBTTagCompound compound) {
        NBTTagList itr = compound.func_150295_c("itr", 10);
        int rule = compound.func_74762_e("type");
        LinkedList<Token> linkedList = new LinkedList<Token>();
        for (int i = 0; i < itr.func_74745_c(); ++i) {
            NBTTagCompound tag = itr.func_150305_b(i);
            int segType = tag.func_74762_e("type");
            int[] datas = tag.func_74759_k("data");
            linkedList.add(new Token(segType, datas));
        }
        return new Area(new ShapeDummy(rule, linkedList));
    }

    static NBTTagCompound toNBT(Area area) {
        NBTTagBuilder builder = NBTTagBuilder.newBuilder();
        PathIterator iterator = area.getPathIterator(null);
        builder.addInt("type", iterator.getWindingRule());
        float[] data = new float[6];
        while (!iterator.isDone()) {
            int[] ints = new int[6];
            int i = iterator.currentSegment(data);
            for (int j = 0; j < data.length; ++j) {
                ints[j] = (int)data[j];
            }
            builder.addInt("type", i);
            builder.addIntArray("data", ints);
        }
        return builder.build();
    }

    static {
        CapabilityManager.INSTANCE.register(RegionManagerImpl.class, (Capability.IStorage)new Capability.IStorage<RegionManagerImpl>(){

            public NBTBase writeNBT(Capability<RegionManagerImpl> capability, RegionManagerImpl instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<RegionManagerImpl> capability, RegionManagerImpl instance, EnumFacing side, NBTBase nbt) {
            }
        }, (Callable)new Callable<RegionManagerImpl>(){

            @Override
            public RegionManagerImpl call() throws Exception {
                return null;
            }
        });
    }

    static class Token {
        int type;
        int[] data;

        Token(int type, int[] data) {
            this.type = type;
            this.data = data;
        }
    }

    static class ShapeDummy
    implements Shape,
    PathIterator {
        int rule;
        LinkedList<Token> tokenList;
        Token current;

        public ShapeDummy(int rule, LinkedList<Token> tokenList) {
            this.rule = rule;
            this.tokenList = tokenList;
        }

        public ShapeDummy() {
        }

        @Override
        public Rectangle getBounds() {
            return null;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return null;
        }

        @Override
        public boolean contains(double x, double y) {
            return false;
        }

        @Override
        public boolean contains(Point2D p) {
            return false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return false;
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return this;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return this;
        }

        @Override
        public int getWindingRule() {
            return this.rule;
        }

        @Override
        public boolean isDone() {
            return !this.tokenList.isEmpty();
        }

        @Override
        public void next() {
            this.current = this.tokenList.pop();
        }

        @Override
        public int currentSegment(float[] coords) {
            for (int i = 0; i < this.current.data.length; ++i) {
                coords[i] = this.current.data[i];
            }
            return this.current.type;
        }

        @Override
        public int currentSegment(double[] coords) {
            for (int i = 0; i < this.current.data.length; ++i) {
                coords[i] = this.current.data[i];
            }
            return this.current.type;
        }
    }
}

