/************************************************************************
 * Copyright (c) 2014 IoT-Solutions e.U.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ************************************************************************/

package iot.jcypher.query.ast.index;

import iot.jcypher.query.ast.ASTNode;

public class IndexExpression extends ASTNode {

	private IndexAction indexAction;
	private String labelName;
	private String propertyName;
	
	public IndexExpression(IndexAction indexAction) {
		super();
		this.indexAction = indexAction;
	}
	public IndexAction getIndexAction() {
		return indexAction;
	}
	public String getLabelName() {
		return labelName;
	}
	public void setLabelName(String labelName) {
		this.labelName = labelName;
	}
	public String getPropertyName() {
		return propertyName;
	}
	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}
	
	/***************************************/
	public enum IndexAction {
		CREATE, DROP
	}
}
