/*
 * Decompiled with CFR 0.152.
 */
package net.isger.brick.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.isger.brick.ui.Screen;
import net.isger.util.Helpers;
import net.isger.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Screens {
    private static final Logger LOG = LoggerFactory.getLogger(Screens.class);
    private Map<String, Screen> screens = new HashMap<String, Screen>();

    public Screens() {
        this(null);
    }

    public Screens(List<Object> screens) {
        if (screens != null) {
            for (Object instance : screens) {
                if (instance instanceof Screen) {
                    this.add((Screen)instance);
                    continue;
                }
                if (!(instance instanceof Map)) continue;
                for (Map.Entry entry : ((Map)instance).entrySet()) {
                    instance = entry.getValue();
                    if (!(instance instanceof Screen)) continue;
                    this.put((String)entry.getKey(), (Screen)instance);
                }
            }
        }
    }

    public void add(Screen screen) {
        this.put("", screen);
    }

    public void put(String name, Screen screen) {
        String key;
        int index = name.lastIndexOf(".");
        if (index++ > 0) {
            key = name.substring(0, index);
            name = name.substring(index);
        } else {
            key = "";
        }
        key = key + Screens.getName(screen.getClass(), name);
        if (LOG.isDebugEnabled()) {
            LOG.info("Binding [{}] screen [{}]", (Object)key, (Object)screen);
        }
        if ((screen = this.screens.put(key, screen)) != null) {
            LOG.warn("(!) Discard [{}] screen [{}]", (Object)key, (Object)screen);
        }
    }

    public Screen get(String name) {
        return this.screens.get(name);
    }

    public static final String getName(Class<? extends Screen> clazz) {
        return Screens.getName(clazz, "");
    }

    public static final String getName(Class<? extends Screen> clazz, String name) {
        return Helpers.getAliasName(clazz, (String)"Screen$", (String)Strings.toLower((String)name));
    }

    public Map<String, Screen> gets() {
        return Collections.unmodifiableMap(this.screens);
    }
}

