/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.as.ConfigClassBuilder;
import net.jangaroo.exml.config.ExmlConfiguration;
import net.jangaroo.exml.config.ValidationMode;
import net.jangaroo.exml.generator.ExmlConfigPackageXsdGenerator;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ExmlSourceFile;
import net.jangaroo.exml.parser.ExmlValidator;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.utils.CompilerUtils;

public class ConfigClassRegistry {
    private Map<String, ConfigClass> configClassesByName = new HashMap<String, ConfigClass>();
    private ExmlConfiguration config;
    private InputSource sourcePathInputSource;
    private JangarooParser jangarooParser;
    private ExmlConfigPackageXsdGenerator exmlConfigPackageXsdGenerator;
    private Map<String, ExmlSourceFile> exmlFilesByConfigClassName;
    private Set<ConfigClass> sourceConfigClasses;

    public ConfigClassRegistry(ExmlConfiguration config) throws IOException {
        this.config = config;
        this.sourcePathInputSource = PathInputSource.fromFiles((List)config.getSourcePath(), (String[])new String[0], (boolean)true);
        CCRParserOptions parserOptions = new CCRParserOptions();
        this.jangarooParser = new JangarooParser(parserOptions, (CompileLog)new StdOutCompileLog()){

            protected InputSource findSource(String qname) {
                InputSource inputSource = super.findSource(qname);
                if (inputSource != null) {
                    return inputSource;
                }
                ConfigClassRegistry.this.tryGenerateClass(qname);
                return super.findSource(qname);
            }
        };
        ArrayList<File> fullClassPath = new ArrayList<File>(config.getClassPath());
        fullClassPath.add(config.getOutputDirectory());
        PathInputSource classPathInputSource = PathInputSource.fromFiles(fullClassPath, (String[])new String[]{"", "META-INF/joo-api/"}, (boolean)false);
        this.jangarooParser.setUp(this.sourcePathInputSource, (InputSource)classPathInputSource);
        this.jangarooParser.setCompilableSuffixes(Collections.singletonList(".as"));
        this.exmlConfigPackageXsdGenerator = new ExmlConfigPackageXsdGenerator();
    }

    private void tryGenerateClass(String qname) {
        ExmlSourceFile exmlSourceFile = this.getExmlSourceFilesByConfigClassName().get(qname);
        if (exmlSourceFile != null) {
            exmlSourceFile.generateConfigClass();
        } else {
            InputSource exmlInputSource = this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName((String)qname, (InputSource)this.sourcePathInputSource, (String)".exml"));
            if (exmlInputSource != null) {
                String configClassName = this.computeConfigClassNameFromTargetClassName(qname);
                exmlSourceFile = this.getExmlSourceFilesByConfigClassName().get(configClassName);
                if (exmlSourceFile != null) {
                    exmlSourceFile.generateTargetClass();
                }
            }
        }
    }

    public ExmlConfiguration getConfig() {
        return this.config;
    }

    public JangarooParser getJangarooParser() {
        return this.jangarooParser;
    }

    public Collection<ConfigClass> getSourceConfigClasses() {
        if (this.sourceConfigClasses == null) {
            this.sourceConfigClasses = new LinkedHashSet<ConfigClass>();
            LinkedHashMap<String, File> sourceFilesByName = new LinkedHashMap<String, File>();
            this.scanExmlFiles(sourceFilesByName);
            this.scanAsFiles(sourceFilesByName);
        }
        return this.sourceConfigClasses;
    }

    private void scanExmlFiles(Map<String, File> sourceFilesByName) {
        for (ExmlSourceFile exmlFile : this.getExmlSourceFilesByConfigClassName().values()) {
            this.addSourceConfigClass(sourceFilesByName, exmlFile.getSourceFile(), exmlFile.getConfigClass());
        }
    }

    private void scanAsFiles(Map<String, File> sourceFilesByName) {
        InputSource configPackageInputSource = this.sourcePathInputSource.getChild(this.config.getConfigClassPackage().replace('.', File.separatorChar));
        if (configPackageInputSource != null) {
            for (InputSource source : configPackageInputSource.list()) {
                File file = ((FileInputSource)source).getFile();
                if (!file.isFile() || !file.getName().endsWith(".as")) continue;
                try {
                    File sourceDir = this.getConfig().findSourceDir(file);
                    String qName = CompilerUtils.qNameFromFile((File)sourceDir, (File)file);
                    ConfigClass actionScriptConfigClass = this.findActionScriptConfigClass(qName);
                    if (actionScriptConfigClass == null) continue;
                    this.addSourceConfigClass(sourceFilesByName, file, actionScriptConfigClass);
                }
                catch (IOException e) {
                    throw new ExmlcException("could not read AS file", (Throwable)e);
                }
            }
        }
    }

    private void addSourceConfigClass(Map<String, File> sourceFilesByName, File sourceFile, ConfigClass configClass) {
        if (configClass != null) {
            String qname = configClass.getFullName();
            File existingConfigClassSourceFile = sourceFilesByName.get(qname);
            if (existingConfigClassSourceFile != null) {
                throw new ExmlcException(String.format("Config class '%s' already declared in file %s.", qname, existingConfigClassSourceFile.getPath()), sourceFile, null);
            }
            sourceFilesByName.put(qname, sourceFile);
            this.sourceConfigClasses.add(configClass);
        }
    }

    public File generateConfigClass(File exmlFile) {
        return this.getExmlSourceFile(exmlFile).generateConfigClass();
    }

    public ExmlSourceFile getExmlSourceFile(File exmlFile) {
        return this.getExmlSourceFilesByConfigClassName().get(this.computeConfigClassName(exmlFile));
    }

    public Map<String, ExmlSourceFile> getExmlSourceFilesByConfigClassName() {
        if (this.exmlFilesByConfigClassName == null) {
            this.exmlFilesByConfigClassName = new LinkedHashMap<String, ExmlSourceFile>();
            try {
                this.buildConfigClassNameToExmlSourceFileMap(this.sourcePathInputSource);
            }
            catch (IOException e) {
                throw new ExmlcException("Unable to scan source directory for EXML files.", (Throwable)e);
            }
        }
        return this.exmlFilesByConfigClassName;
    }

    private void buildConfigClassNameToExmlSourceFileMap(InputSource inputSource) throws IOException {
        for (InputSource source : inputSource.list()) {
            File exmlFile = ((FileInputSource)source).getFile();
            if (exmlFile.isFile()) {
                if (!exmlFile.getName().endsWith(".exml")) continue;
                this.exmlFilesByConfigClassName.put(this.computeConfigClassName(exmlFile), new ExmlSourceFile(this, exmlFile));
                continue;
            }
            this.buildConfigClassNameToExmlSourceFileMap(source);
        }
    }

    private String computeConfigClassName(File exmlFile) {
        return CompilerUtils.qName((String)this.getConfig().getConfigClassPackage(), (String)CompilerUtils.uncapitalize((String)CompilerUtils.removeExtension((String)exmlFile.getName())));
    }

    private String computeConfigClassNameFromTargetClassName(String targetClassName) {
        return CompilerUtils.qName((String)this.getConfig().getConfigClassPackage(), (String)CompilerUtils.uncapitalize((String)CompilerUtils.className((String)targetClassName)));
    }

    public ConfigClass getConfigClassByName(String name) {
        ConfigClass configClass = this.configClassesByName.get(name);
        if (configClass != null) {
            return configClass;
        }
        ExmlSourceFile exmlFile = this.getExmlSourceFilesByConfigClassName().get(name);
        if (exmlFile != null) {
            return this.addConfigClass(exmlFile.parseExmlToConfigClass());
        }
        configClass = this.findActionScriptConfigClass(name);
        return configClass;
    }

    private ConfigClass addConfigClass(ConfigClass configClass) {
        if (configClass != null) {
            configClass.setConfigClassRegistry(this);
            this.configClassesByName.put(configClass.getFullName(), configClass);
        }
        return configClass;
    }

    private ConfigClass findActionScriptConfigClass(String name) {
        CompilationUnit compilationsUnit = this.jangarooParser.getCompilationUnit(name);
        if (compilationsUnit != null) {
            try {
                return this.buildConfigClass(compilationsUnit);
            }
            catch (RuntimeException e) {
                throw new ExmlcException("while building config class '" + name + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private ConfigClass buildConfigClass(CompilationUnit compilationUnit) {
        ConfigClassBuilder configClassBuilder = new ConfigClassBuilder(compilationUnit);
        return this.addConfigClass(configClassBuilder.buildConfigClass());
    }

    public File generateTargetClass(File exmlSourceFile) {
        return this.getExmlSourceFile(exmlSourceFile).generateTargetClass();
    }

    public void generateXsd(Writer output) throws IOException, TemplateException {
        this.exmlConfigPackageXsdGenerator.generateXsdFile(this.getSourceConfigClasses(), this.config.getConfigClassPackage(), output);
        if (this.getConfig().getValidationMode() != ValidationMode.OFF) {
            try {
                new ExmlValidator(this.getConfig()).validateAllExmlFiles();
            }
            catch (Exception e) {
                throw new ExmlcException("unable to start validation", (Throwable)e);
            }
        }
    }

    private static class CCRParserOptions
    implements ParserOptions {
        private CCRParserOptions() {
        }

        public SemicolonInsertionMode getSemicolonInsertionMode() {
            return SemicolonInsertionMode.QUIRKS;
        }

        public boolean isVerbose() {
            return false;
        }
    }
}

