/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.List;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;

public class ExmlElement {
    private ConfigClass configClass;
    private String ns;
    private ExmlElement superElement;

    public ExmlElement(ConfigClass configClass) {
        this.configClass = configClass;
    }

    public String getNamespace() {
        return "exml:" + this.getPackage();
    }

    public void setNs(String shortNamespace) {
        this.ns = shortNamespace;
    }

    public String getNs() {
        return this.ns;
    }

    public String getFullTypeName() {
        return this.getNs() + ":" + this.getTypeName();
    }

    public String getDescription() {
        return this.configClass.getDescription();
    }

    public List<ConfigAttribute> getDirectCfgs() {
        return this.configClass.getDirectCfgs();
    }

    public ExmlElement getSuperElement() {
        if (this.superElement == null) {
            if (this.configClass.getSuperClass() == null) {
                return null;
            }
            this.superElement = new ExmlElement(this.configClass.getSuperClass());
        }
        return this.superElement;
    }

    public String toString() {
        return "<" + this.getNamespace() + ":" + this.getName() + ">";
    }

    public String getPackage() {
        return this.configClass.getPackageName();
    }

    public String getTypeName() {
        return this.configClass.getFullName();
    }

    public String getName() {
        return this.configClass.getName();
    }
}

