/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.io.File;
import java.io.IOException;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.generator.ExmlComponentClassGenerator;
import net.jangaroo.exml.generator.ExmlConfigClassGenerator;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassRegistry;
import net.jangaroo.exml.model.ExmlModel;
import net.jangaroo.exml.parser.ExmlToConfigClassParser;
import net.jangaroo.exml.parser.ExmlToModelParser;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.utils.CompilerUtils;

public class ExmlSourceFile {
    private ConfigClassRegistry configClassRegistry;
    private File sourceFile;
    private String configClassName;
    private String targetClassName;
    private File generatedConfigClassFile;
    private File generatedTargetClassFile;

    public ExmlSourceFile(ConfigClassRegistry configClassRegistry, File sourceFile) throws IOException {
        this.configClassRegistry = configClassRegistry;
        this.sourceFile = sourceFile;
        this.configClassName = CompilerUtils.qName((String)configClassRegistry.getConfig().getConfigClassPackage(), (String)CompilerUtils.uncapitalize((String)CompilerUtils.removeExtension((String)sourceFile.getName())));
        File sourceDir = configClassRegistry.getConfig().findSourceDir(sourceFile);
        String exmlClassName = CompilerUtils.qNameFromFile((File)sourceDir, (File)sourceFile);
        this.targetClassName = CompilerUtils.qName((String)CompilerUtils.packageName((String)exmlClassName), (String)ExmlUtils.createComponentClassName((String)CompilerUtils.className((String)exmlClassName)));
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getConfigClassName() {
        return this.configClassName;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public ConfigClass getConfigClass() {
        return this.configClassRegistry.getConfigClassByName(this.configClassName);
    }

    public ConfigClass parseExmlToConfigClass() {
        try {
            ConfigClass configClass = new ExmlToConfigClassParser().parseExmlToConfigClass(this.getSourceFile());
            configClass.setFullName(this.getConfigClassName());
            configClass.setComponentClassName(this.getTargetClassName());
            return configClass;
        }
        catch (IOException e) {
            throw new ExmlcException("could not read EXML file", (Throwable)e);
        }
    }

    public File generateConfigClass() {
        if (this.generatedConfigClassFile == null) {
            ConfigClass configClass = this.getConfigClass();
            this.generatedConfigClassFile = this.configClassRegistry.getConfig().computeConfigClassTarget(configClass.getName());
            if (this.mustGenerate(this.generatedConfigClassFile)) {
                try {
                    new ExmlConfigClassGenerator().generateClass(configClass, this.generatedConfigClassFile);
                }
                catch (Exception e) {
                    throw new ExmlcException("unable to generate config class: " + e.getMessage(), this.generatedConfigClassFile, e);
                }
            }
        }
        return this.generatedConfigClassFile;
    }

    public File generateTargetClass() {
        if (this.generatedTargetClassFile == null) {
            this.generatedTargetClassFile = this.computeGeneratedComponentClassFile();
            if (this.mustGenerate(this.generatedTargetClassFile)) {
                try {
                    ExmlModel exmlModel = new ExmlToModelParser(this.configClassRegistry).parse(this.sourceFile);
                    return new ExmlComponentClassGenerator(this.configClassRegistry.getConfig()).generateClass(exmlModel, this.generatedTargetClassFile);
                }
                catch (Exception e) {
                    throw new ExmlcException("unable to generate component class: " + e.getMessage(), this.sourceFile, e);
                }
            }
        }
        return this.generatedTargetClassFile;
    }

    public File computeGeneratedComponentClassFile() {
        try {
            return this.configClassRegistry.getConfig().computeGeneratedComponentClassFile(this.sourceFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean hasSourceTargetClass() {
        return this.computeGeneratedComponentClassFile() == null;
    }

    private boolean mustGenerate(File generatedFile) {
        return this.sourceFile != null && generatedFile != null && (!generatedFile.exists() || generatedFile.lastModified() < this.sourceFile.lastModified());
    }
}

