/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.java.dev.springannotation.annotation.Bean;
import net.java.dev.springannotation.utils.BeanReader;
import net.java.dev.springannotation.utils.IBeanReader;
import net.java.dev.springannotation.utils.Scanner;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBeanDefinitionReader {
    private static Map<Class<? extends Annotation>, IBeanReader> readers = new HashMap<Class<? extends Annotation>, IBeanReader>();

    public static void loadBeansWithAnnotation(BeanDefinitionRegistry registry) {
        AnnotationBeanDefinitionReader.load(registry, new Scanner());
    }

    public static void loadBeansWithAnnotation(BeanDefinitionRegistry registry, boolean scanDirs, ArrayList<String> includePackages, ArrayList<String> excludePackages) {
        AnnotationBeanDefinitionReader.load(registry, new Scanner(scanDirs, includePackages, excludePackages));
    }

    private static void load(BeanDefinitionRegistry registry, Scanner scanner) {
        for (Class<?> c : scanner.getClasses()) {
            for (Class<? extends Annotation> type : readers.keySet()) {
                if (c.getAnnotation(type) == null) continue;
                IBeanReader reader = readers.get(type);
                reader.register(registry, c);
            }
        }
    }

    public static void register(Class<? extends Annotation> type, IBeanReader reader) {
        readers.put(type, reader);
    }

    static {
        AnnotationBeanDefinitionReader.register(Bean.class, new BeanReader());
    }
}

