/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.spec;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.artifact.spec.ci.ArtifactDescriptorCi;
import net.java.trueupdate.util.Objects;
import net.java.trueupdate.util.Strings;
import net.java.trueupdate.util.SystemProperties;
import net.java.trueupdate.util.builder.AbstractBuilder;

@Immutable
public final class ArtifactDescriptor {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;

    ArtifactDescriptor(Builder<?> b) {
        this.groupId = Strings.requireNonEmpty((String)b.groupId);
        this.artifactId = Strings.requireNonEmpty((String)b.artifactId);
        this.version = Strings.requireNonEmpty((String)b.version);
        this.classifier = (String)Objects.nonNullOr((Object)b.classifier, (Object)"");
        this.extension = (String)Objects.nonNullOr((Object)b.extension, (Object)"jar");
    }

    public Builder<Void> update() {
        return ArtifactDescriptor.builder().groupId(this.groupId).artifactId(this.artifactId).version(this.version).classifier(this.classifier).extension(this.extension);
    }

    public static ArtifactDescriptor parse(ArtifactDescriptorCi ci) {
        return ArtifactDescriptor.builder().parse(ci).build();
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public String groupId() {
        return this.groupId;
    }

    public ArtifactDescriptor groupId(String groupId) {
        return groupId.equals(this.groupId) ? this : this.update().groupId(groupId).build();
    }

    public String artifactId() {
        return this.artifactId;
    }

    public ArtifactDescriptor artifactId(String artifactId) {
        return artifactId.equals(this.artifactId) ? this : this.update().artifactId(artifactId).build();
    }

    public String version() {
        return this.version;
    }

    public ArtifactDescriptor version(String version) {
        return version.equals(this.version) ? this : this.update().version(version).build();
    }

    public String classifier() {
        return this.classifier;
    }

    public ArtifactDescriptor classifier(String classifier) {
        return classifier.equals(this.classifier) ? this : this.update().classifier(classifier).build();
    }

    public String extension() {
        return this.extension;
    }

    public ArtifactDescriptor extension(String extension) {
        return extension.equals(this.extension) ? this : this.update().extension(extension).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactDescriptor)) {
            return false;
        }
        ArtifactDescriptor that = (ArtifactDescriptor)obj;
        return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version) && this.classifier.equals(that.classifier) && this.extension.equals(that.extension);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.groupId.hashCode();
        hash = 31 * hash + this.artifactId.hashCode();
        hash = 31 * hash + this.version.hashCode();
        hash = 31 * hash + this.classifier.hashCode();
        hash = 31 * hash + this.extension.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.groupId()).append(':').append(this.artifactId).append(':').append(this.extension);
        if (0 != this.classifier.length()) {
            sb.append(':').append(this.classifier);
        }
        sb.append(':').append(this.version());
        return sb.toString();
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        @CheckForNull
        String groupId;
        @CheckForNull
        String artifactId;
        @CheckForNull
        String version;
        @CheckForNull
        String classifier;
        @CheckForNull
        String extension;

        protected Builder() {
        }

        public final Builder<P> parse(ArtifactDescriptorCi ci) {
            this.groupId = SystemProperties.resolve((String)ci.groupId, (String)this.groupId);
            this.artifactId = SystemProperties.resolve((String)ci.artifactId, (String)this.artifactId);
            this.version = SystemProperties.resolve((String)ci.version, (String)this.version);
            this.classifier = SystemProperties.resolve((String)ci.classifier, (String)this.classifier);
            this.extension = SystemProperties.resolve((String)ci.extension, (String)this.extension);
            return this;
        }

        public final Builder<P> groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final Builder<P> artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public final Builder<P> version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public final Builder<P> classifier(@Nullable String classifier) {
            this.classifier = classifier;
            return this;
        }

        public final Builder<P> extension(@Nullable String extension) {
            this.extension = extension;
            return this;
        }

        public final ArtifactDescriptor build() {
            return new ArtifactDescriptor(this);
        }
    }
}

