/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.Job;
import net.java.trueupdate.core.io.OutputTask;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.WithOutputTask;

@Immutable
public class Sinks {
    public static Sink output() {
        return Sinks.uncloseable(System.out);
    }

    public static Sink error() {
        return Sinks.uncloseable(System.err);
    }

    public static Sink uncloseable(final OutputStream out) {
        return new Sink(){

            @Override
            public OutputStream output() {
                return new FilterOutputStream(out){

                    @Override
                    public void close() throws IOException {
                        this.out.flush();
                    }
                };
            }
        };
    }

    public static <V, X extends Exception> ExecuteStatement<V, X> execute(OutputTask<V, X> task) {
        return new WithOutputTask<V, X>(task);
    }

    public static <V, X extends Exception> BindStatement<V, X> bind(OutputTask<V, X> task) {
        return new WithOutputTask<V, X>(task);
    }

    private Sinks() {
    }

    public static interface BindStatement<V, X extends Exception> {
        public Job<V, X> to(Sink var1);
    }

    public static interface ExecuteStatement<V, X extends Exception> {
        public V on(OutputStream var1) throws X, IOException;

        public V on(Sink var1) throws X, IOException;
    }
}

