/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.io;

import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.core.io.InputTask;
import net.java.trueupdate.core.io.Job;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.WithInputTask;

@Immutable
public class Sources {
    public static Source input() {
        return Sources.uncloseable(System.in);
    }

    public static Source uncloseable(final InputStream in) {
        return new Source(){

            @Override
            public InputStream input() {
                return new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                    }
                };
            }
        };
    }

    public static Source forResource(final String name, final Class<?> clazz) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return Sources.check(clazz.getResourceAsStream(name), name);
            }
        };
    }

    public static Source forResource(final String name, final @CheckForNull ClassLoader loader) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return Sources.check(null != loader ? loader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name), name);
            }
        };
    }

    public static Source forUrl(final URL url) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return url.openStream();
            }
        };
    }

    static InputStream check(@CheckForNull InputStream in, String name) throws FileNotFoundException {
        if (null == in) {
            throw new FileNotFoundException(name);
        }
        return in;
    }

    public static <V, X extends Exception> ExecuteStatement<V, X> execute(InputTask<V, X> task) {
        return new WithInputTask<V, X>(task);
    }

    public static <V, X extends Exception> BindStatement<V, X> bind(InputTask<V, X> task) {
        return new WithInputTask<V, X>(task);
    }

    private Sources() {
    }

    public static interface BindStatement<V, X extends Exception> {
        public Job<V, X> to(Source var1);
    }

    public static interface ExecuteStatement<V, X extends Exception> {
        public V on(InputStream var1) throws X, IOException;

        public V on(Source var1) throws X, IOException;
    }
}

