/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.core.zip.diff;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.trueupdate.core.io.Copy;
import net.java.trueupdate.core.io.MessageDigests;
import net.java.trueupdate.core.io.Sink;
import net.java.trueupdate.core.io.Source;
import net.java.trueupdate.core.io.ZipEntrySink;
import net.java.trueupdate.core.io.ZipEntrySource;
import net.java.trueupdate.core.io.ZipOutputTask;
import net.java.trueupdate.core.io.ZipSinks;
import net.java.trueupdate.core.zip.model.DiffModel;
import net.java.trueupdate.core.zip.model.EntryNameAndDigest;
import net.java.trueupdate.core.zip.model.EntryNameAndTwoDigests;
import net.java.trueupdate.shed.Objects;

@NotThreadSafe
public abstract class ZipDiff {
    @WillNotClose
    abstract ZipFile archive1();

    @WillNotClose
    abstract ZipFile archive2();

    abstract MessageDigest digest();

    public static Builder builder() {
        return new Builder();
    }

    public void writePatchArchiveTo(Sink patchArchive) throws IOException {
        final DiffModel model = this.computeDiffModel();
        class StreamPatchArchiveTask
        implements ZipOutputTask<Void, IOException> {
            StreamPatchArchiveTask() {
            }

            @Override
            public Void execute(ZipOutputStream zipOut) throws IOException {
                ZipDiff.this.streamPatchArchiveTo(model, zipOut);
                return null;
            }
        }
        ZipSinks.execute(new StreamPatchArchiveTask()).on(new ZipOutputStream(patchArchive.output()));
    }

    private void streamPatchArchiveTo(DiffModel model, final @WillNotClose ZipOutputStream zipOut) throws IOException {
        zipOut.setLevel(9);
        final class PatchArchiveStreamer {
            final DiffModel model;

            PatchArchiveStreamer(DiffModel model) throws IOException {
                try {
                    model.encodeToXml(this.entrySink("META-INF/diff.xml"));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
                this.model = model;
            }

            PatchArchiveStreamer streamChangedOrAdded() throws IOException {
                Enumeration<? extends ZipEntry> entries = ZipDiff.this.archive2().entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!this.changedOrAdded(name)) continue;
                    Copy.copy(new ZipEntrySource(entry, ZipDiff.this.archive2()), this.entrySink(name));
                }
                return this;
            }

            Sink entrySink(String name) {
                return new ZipEntrySink(new ZipEntry(name), zipOut);
            }

            boolean changedOrAdded(String name) {
                return null != this.model.changed(name) || null != this.model.added(name);
            }
        }
        new PatchArchiveStreamer(model).streamChangedOrAdded();
    }

    public DiffModel computeDiffModel() throws IOException {
        return new Assembler().walkAndReturn(new Assembly()).buildZipDiffModel();
    }

    public static class Builder {
        @CheckForNull
        private ZipFile archive1;
        @CheckForNull
        private ZipFile archive2;
        @CheckForNull
        private MessageDigest digest;

        Builder() {
        }

        public Builder archive1(@Nullable ZipFile archive2) {
            this.archive1 = archive2;
            return this;
        }

        public Builder archive2(@Nullable ZipFile archive2) {
            this.archive2 = archive2;
            return this;
        }

        public Builder digest(@Nullable MessageDigest digest) {
            this.digest = digest;
            return this;
        }

        public ZipDiff build() {
            return Builder.create(this.archive1, this.archive2, Builder.nonNullOrSha1(this.digest));
        }

        private static MessageDigest nonNullOrSha1(@CheckForNull MessageDigest digest) {
            return null != digest ? digest : MessageDigests.sha1();
        }

        private static ZipDiff create(final ZipFile archive1, final ZipFile archive2, final MessageDigest digest) {
            Objects.requireNonNull((Object)archive1);
            Objects.requireNonNull((Object)archive2);
            assert (null != digest);
            return new ZipDiff(){

                @Override
                ZipFile archive1() {
                    return archive1;
                }

                @Override
                ZipFile archive2() {
                    return archive2;
                }

                @Override
                MessageDigest digest() {
                    return digest;
                }
            };
        }
    }

    private static interface Visitor {
        public void visitEntryInFirstFile(ZipEntrySource var1) throws IOException;

        public void visitEntryInSecondFile(ZipEntrySource var1) throws IOException;

        public void visitEntriesInBothFiles(ZipEntrySource var1, ZipEntrySource var2) throws IOException;
    }

    private class Assembly
    implements Visitor {
        private final Map<String, EntryNameAndTwoDigests> changed = new TreeMap<String, EntryNameAndTwoDigests>();
        private final Map<String, EntryNameAndDigest> unchanged = new TreeMap<String, EntryNameAndDigest>();
        private final Map<String, EntryNameAndDigest> added = new TreeMap<String, EntryNameAndDigest>();
        private final Map<String, EntryNameAndDigest> removed = new TreeMap<String, EntryNameAndDigest>();

        private Assembly() {
        }

        DiffModel buildZipDiffModel() {
            return DiffModel.builder().messageDigest(ZipDiff.this.digest()).changedEntries(this.changed.values()).unchangedEntries(this.unchanged.values()).addedEntries(this.added.values()).removedEntries(this.removed.values()).build();
        }

        @Override
        public void visitEntriesInBothFiles(ZipEntrySource source1, ZipEntrySource source2) throws IOException {
            String digest2;
            String name1 = source1.name();
            assert (name1.equals(source2.name()));
            String digest1 = this.digestValueOf(source1);
            if (digest1.equals(digest2 = this.digestValueOf(source2))) {
                this.unchanged.put(name1, new EntryNameAndDigest(name1, digest1));
            } else {
                this.changed.put(name1, new EntryNameAndTwoDigests(name1, digest1, digest2));
            }
        }

        @Override
        public void visitEntryInFirstFile(ZipEntrySource source1) throws IOException {
            String name = source1.name();
            this.removed.put(name, new EntryNameAndDigest(name, this.digestValueOf(source1)));
        }

        @Override
        public void visitEntryInSecondFile(ZipEntrySource source2) throws IOException {
            String name = source2.name();
            this.added.put(name, new EntryNameAndDigest(name, this.digestValueOf(source2)));
        }

        String digestValueOf(Source source) throws IOException {
            MessageDigest messageDigest = ZipDiff.this.digest();
            messageDigest.reset();
            MessageDigests.updateDigestFrom(messageDigest, source);
            return MessageDigests.valueOf(messageDigest);
        }
    }

    @Immutable
    private class Assembler {
        private Assembler() {
        }

        <V extends Visitor> V walkAndReturn(V visitor) throws IOException {
            String name;
            Enumeration<? extends ZipEntry> entries = ZipDiff.this.archive1().entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry1 = entries.nextElement();
                name = entry1.getName();
                if (name.endsWith("/")) continue;
                ZipEntry entry2 = ZipDiff.this.archive2().getEntry(name);
                ZipEntrySource source1 = new ZipEntrySource(entry1, ZipDiff.this.archive1());
                if (null == entry2) {
                    visitor.visitEntryInFirstFile(source1);
                    continue;
                }
                visitor.visitEntriesInBothFiles(source1, new ZipEntrySource(entry2, ZipDiff.this.archive2()));
            }
            entries = ZipDiff.this.archive2().entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry1;
                ZipEntry entry2 = entries.nextElement();
                name = entry2.getName();
                if (name.endsWith("/") || null != (entry1 = ZipDiff.this.archive1().getEntry(name))) continue;
                visitor.visitEntryInSecondFile(new ZipEntrySource(entry2, ZipDiff.this.archive2()));
            }
            return visitor;
        }
    }
}

