/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.message;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogRecord;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.message.UpdateMessageListener;
import net.java.trueupdate.util.Objects;
import net.java.trueupdate.util.Strings;
import net.java.trueupdate.util.builder.AbstractBuilder;

public final class UpdateMessage {
    private final long timestamp;
    private final String from;
    private final String to;
    private final Type type;
    private final ArtifactDescriptor artifactDescriptor;
    private final String updateVersion;
    private final String currentLocation;
    private final String updateLocation;
    private final List<LogRecord> attachedLogs = new LinkedList<LogRecord>();

    UpdateMessage(Builder<?> b) {
        this.timestamp = UpdateMessage.nonNullOrNow(b.timestamp);
        this.from = Strings.requireNonEmpty((String)b.from);
        this.to = Strings.requireNonEmpty((String)b.to);
        this.type = (Type)((Object)Objects.requireNonNull((Object)((Object)b.type)));
        this.artifactDescriptor = (ArtifactDescriptor)Objects.requireNonNull((Object)b.artifactDescriptor);
        this.updateVersion = (String)Objects.nonNullOr((Object)b.updateVersion, (Object)"");
        this.currentLocation = Strings.requireNonEmpty((String)b.currentLocation);
        this.updateLocation = (String)Objects.nonNullOr((Object)b.updateLocation, (Object)this.currentLocation);
    }

    private static long nonNullOrNow(Long timestamp) {
        return null != timestamp ? timestamp : System.currentTimeMillis();
    }

    public Builder<Void> update() {
        return UpdateMessage.builder().timestamp(this.timestamp).from(this.from).to(this.to).type(this.type).artifactDescriptor(this.artifactDescriptor).updateVersion(this.updateVersion).currentLocation(this.currentLocation).updateLocation(this.updateLocation);
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public long timestamp() {
        return this.timestamp;
    }

    public UpdateMessage timestamp(long timestamp) {
        return timestamp == this.timestamp ? this : this.update().timestamp(timestamp).build();
    }

    public String from() {
        return this.from;
    }

    public UpdateMessage from(String from) {
        return this.from.equals(from) ? this : this.update().from(from).build();
    }

    public String to() {
        return this.to;
    }

    public UpdateMessage to(String to) {
        return to.equals(this.to) ? this : this.update().to(to).build();
    }

    public Type type() {
        return this.type;
    }

    public UpdateMessage type(Type type) {
        return type.equals((Object)this.type) ? this : this.update().type(type).build();
    }

    public ArtifactDescriptor artifactDescriptor() {
        return this.artifactDescriptor;
    }

    public UpdateMessage artifactDescriptor(ArtifactDescriptor artifactDescriptor) {
        return artifactDescriptor.equals((Object)this.artifactDescriptor) ? this : this.update().artifactDescriptor(artifactDescriptor).build();
    }

    public String updateVersion() {
        return this.updateVersion;
    }

    public UpdateMessage updateVersion(String updateVersion) {
        return updateVersion.equals(this.updateVersion) ? this : this.update().updateVersion(updateVersion).build();
    }

    public String currentLocation() {
        return this.currentLocation;
    }

    public UpdateMessage currentLocation(String currentLocation) {
        return currentLocation.equals(this.currentLocation) ? this : this.update().currentLocation(currentLocation).build();
    }

    public String updateLocation() {
        return this.updateLocation;
    }

    public UpdateMessage updateLocation(String updateLocation) {
        return updateLocation.equals(this.updateLocation) ? this : this.update().updateLocation(updateLocation).build();
    }

    public List<LogRecord> attachedLogs() {
        return this.attachedLogs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateMessage)) {
            return false;
        }
        UpdateMessage that = (UpdateMessage)obj;
        return this.timestamp == that.timestamp && this.from.equals(that.from) && this.to.equals(that.to) && this.type.equals((Object)that.type) && this.artifactDescriptor.equals((Object)that.artifactDescriptor) && this.updateVersion.equals(that.updateVersion) && this.currentLocation.equals(that.currentLocation) && this.updateLocation.equals(that.updateLocation);
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + UpdateMessage.hashCode(this.timestamp);
        hash = 31 * hash + this.from.hashCode();
        hash = 31 * hash + this.to.hashCode();
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.artifactDescriptor.hashCode();
        hash = 31 * hash + this.updateVersion.hashCode();
        hash = 31 * hash + this.currentLocation.hashCode();
        hash = 31 * hash + this.updateLocation.hashCode();
        return hash;
    }

    private static int hashCode(long value) {
        return (int)(value >> 32 ^ value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Timestamp: ").append(new Date(this.timestamp)).append('\n').append("From: ").append(this.from).append('\n').append("To: ").append(this.to).append('\n').append("Type: ").append((Object)this.type).append('\n').append("Artifact-descriptor: ").append(this.artifactDescriptor).append('\n');
        if (!this.updateVersion.isEmpty()) {
            sb.append("Update-version: ").append(this.updateVersion).append('\n');
        }
        if (!this.currentLocation.isEmpty()) {
            sb.append("Current-location: ").append(this.currentLocation).append('\n');
        }
        if (!this.updateLocation.isEmpty()) {
            sb.append("Update-location: ").append(this.updateLocation).append('\n');
        }
        sb.append("Attached-log-records: ").append(this.attachedLogs.size());
        return sb.toString();
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        @CheckForNull
        Long timestamp;
        @CheckForNull
        String from;
        @CheckForNull
        String to;
        @CheckForNull
        Type type;
        @CheckForNull
        ArtifactDescriptor artifactDescriptor;
        @CheckForNull
        String updateVersion;
        @CheckForNull
        String currentLocation;
        @CheckForNull
        String updateLocation;

        protected Builder() {
        }

        public final Builder<P> timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder<P> from(@Nullable String from) {
            this.from = from;
            return this;
        }

        public final Builder<P> to(@Nullable String to) {
            this.to = to;
            return this;
        }

        public final Builder<P> type(@Nullable Type type) {
            this.type = type;
            return this;
        }

        public final ArtifactDescriptor.Builder<Builder<P>> artifactDescriptor() {
            return new ArtifactDescriptor.Builder<Builder<P>>(){

                public Builder<P> inject() {
                    return Builder.this.artifactDescriptor(this.build());
                }
            };
        }

        public final Builder<P> artifactDescriptor(@Nullable ArtifactDescriptor artifactDescriptor) {
            this.artifactDescriptor = artifactDescriptor;
            return this;
        }

        public final Builder<P> updateVersion(@Nullable String updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public final Builder<P> currentLocation(@Nullable String currentLocation) {
            this.currentLocation = currentLocation;
            return this;
        }

        public final Builder<P> updateLocation(@Nullable String updateLocation) {
            this.updateLocation = updateLocation;
            return this;
        }

        public final UpdateMessage build() {
            return new UpdateMessage(this);
        }
    }

    public static enum Type {
        SUBSCRIPTION_NOTICE(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionNotice(message);
            }
        }
        ,
        SUBSCRIPTION_REQUEST(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionRequest(message);
            }
        }
        ,
        SUBSCRIPTION_RESPONSE(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onSubscriptionResponse(message);
            }
        }
        ,
        UPDATE_NOTICE(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUpdateNotice(message);
            }
        }
        ,
        INSTALLATION_REQUEST(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationRequest(message);
            }
        }
        ,
        PROGRESS_NOTICE(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onProgressNotice(message);
            }
        }
        ,
        REDEPLOYMENT_REQUEST(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onRedeploymentRequest(message);
            }
        }
        ,
        PROCEED_REDEPLOYMENT_RESPONSE(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onProceedRedeploymentResponse(message);
            }
        }
        ,
        CANCEL_REDEPLOYMENT_RESPONSE(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onCancelRedeploymentResponse(message);
            }
        }
        ,
        INSTALLATION_SUCCESS_RESPONSE(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationSuccessResponse(message);
            }
        }
        ,
        INSTALLATION_FAILURE_RESPONSE(false){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onInstallationFailureResponse(message);
            }
        }
        ,
        UNSUBSCRIPTION_NOTICE(true){

            @Override
            void dispatchMessageTo(UpdateMessage message, UpdateMessageListener listener) throws Exception {
                listener.onUnsubscriptionNotice(message);
            }
        };

        private final boolean forManager;

        private Type(boolean forManager) {
            this.forManager = forManager;
        }

        public final boolean forManager() {
            return this.forManager;
        }

        abstract void dispatchMessageTo(UpdateMessage var1, UpdateMessageListener var2) throws Exception;
    }
}

