/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.server.maven;

import java.net.URL;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXB;
import net.java.trueupdate.artifact.maven.MavenArtifactResolver;
import net.java.trueupdate.artifact.maven.MavenParameters;
import net.java.trueupdate.artifact.maven.dto.MavenParametersDto;
import net.java.trueupdate.artifact.spec.ArtifactResolver;
import net.java.trueupdate.server.maven.dto.MavenUpdateServerParametersDto;
import net.java.trueupdate.util.Resources;
import net.java.trueupdate.util.builder.AbstractBuilder;

@Immutable
public final class MavenUpdateServerParameters {
    private static final String CONFIGURATION = "META-INF/update/server.xml";
    private final ArtifactResolver artifactResolver;

    MavenUpdateServerParameters(Builder<?> b) {
        this.artifactResolver = new MavenArtifactResolver(b.mavenParameters);
    }

    public static MavenUpdateServerParameters load() {
        return MavenUpdateServerParameters.load(Resources.locate((String)CONFIGURATION));
    }

    static MavenUpdateServerParameters load(URL source) {
        try {
            return MavenUpdateServerParameters.parse((MavenUpdateServerParametersDto)JAXB.unmarshal((URL)source, MavenUpdateServerParametersDto.class));
        }
        catch (Exception ex) {
            throw new ServiceConfigurationError(String.format("Failed to load configuration from %s .", source), ex);
        }
    }

    public static MavenUpdateServerParameters parse(MavenUpdateServerParametersDto ci) {
        return MavenUpdateServerParameters.builder().parse(ci).build();
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public ArtifactResolver artifactResolver() {
        return this.artifactResolver;
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        @CheckForNull
        MavenParameters mavenParameters;

        protected Builder() {
        }

        public final Builder<P> parse(MavenUpdateServerParametersDto ci) {
            if (null != ci.repositories) {
                this.mavenParameters = MavenParameters.parse((MavenParametersDto)ci.repositories);
            }
            return this;
        }

        public final Builder<P> mavenParameters(@Nullable MavenParameters mavenParameters) {
            this.mavenParameters = mavenParameters;
            return this;
        }

        public final MavenUpdateServerParameters build() {
            return new MavenUpdateServerParameters(this);
        }
    }
}

