/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.elasticsearch;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.jetbrains.annotations.NotNull;

public class ElasticsearchLockProvider
implements LockProvider {
    static final String SCHEDLOCK_DEFAULT_INDEX = "shedlock";
    static final String SCHEDLOCK_DEFAULT_TYPE = "lock";
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String NAME = "name";
    private static final String UPDATE_SCRIPT = "if (ctx._source.lockUntil <= params.lockedAt) { ctx._source.lockedBy = params.lockedBy; ctx._source.lockedAt = params.lockedAt; ctx._source.lockUntil =  params.lockUntil; } else { ctx.op = 'none' }";
    private final RestHighLevelClient highLevelClient;
    private final String hostname;
    private final String index;
    private final String type;

    private ElasticsearchLockProvider(@NotNull RestHighLevelClient highLevelClient, @NotNull String index, @NotNull String type) {
        this.highLevelClient = highLevelClient;
        this.hostname = Utils.getHostname();
        this.index = index;
        this.type = type;
    }

    public ElasticsearchLockProvider(@NotNull RestHighLevelClient highLevelClient, @NotNull String documentType) {
        this(highLevelClient, SCHEDLOCK_DEFAULT_INDEX, documentType);
    }

    public ElasticsearchLockProvider(@NotNull RestHighLevelClient highLevelClient) {
        this(highLevelClient, SCHEDLOCK_DEFAULT_INDEX, SCHEDLOCK_DEFAULT_TYPE);
    }

    @NotNull
    public Optional<SimpleLock> lock(@NotNull LockConfiguration lockConfiguration) {
        try {
            Map<String, Object> lockObject = this.lockObject(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil(), this.now());
            UpdateRequest ur = ((UpdateRequest)new UpdateRequest().index(this.index)).type(this.type).id(lockConfiguration.getName()).script(new Script(ScriptType.INLINE, "painless", UPDATE_SCRIPT, lockObject)).upsert(lockObject).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            UpdateResponse res = this.highLevelClient.update(ur, RequestOptions.DEFAULT);
            if (res.getResult() != DocWriteResponse.Result.NOOP) {
                return Optional.of(new ElasticsearchSimpleLock(lockConfiguration));
            }
            return Optional.empty();
        }
        catch (IOException | ElasticsearchException e) {
            if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == RestStatus.CONFLICT) {
                return Optional.empty();
            }
            throw new LockException("Unexpected exception occurred", e);
        }
    }

    private Instant now() {
        return Instant.now();
    }

    private Map<String, Object> lockObject(String name, Instant lockUntil, Instant lockedAt) {
        HashMap<String, Object> lock = new HashMap<String, Object>();
        lock.put(NAME, name);
        lock.put(LOCKED_BY, this.hostname);
        lock.put(LOCKED_AT, lockedAt.toEpochMilli());
        lock.put(LOCK_UNTIL, lockUntil.toEpochMilli());
        return lock;
    }

    private final class ElasticsearchSimpleLock
    extends AbstractSimpleLock {
        private ElasticsearchSimpleLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        public void doUnlock() {
            try {
                UpdateRequest ur = ((UpdateRequest)new UpdateRequest().index(ElasticsearchLockProvider.this.index)).type(ElasticsearchLockProvider.this.type).id(this.lockConfiguration.getName()).script(new Script(ScriptType.INLINE, "painless", "ctx._source.lockUntil = params.unlockTime", Collections.singletonMap("unlockTime", this.lockConfiguration.getUnlockTime().toEpochMilli())));
                ElasticsearchLockProvider.this.highLevelClient.update(ur, RequestOptions.DEFAULT);
            }
            catch (IOException | ElasticsearchException e) {
                throw new LockException("Unexpected exception occurred", e);
            }
        }
    }
}

